/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.SystemInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class AbstractManager {
    SystemInfo parent;
    String systemFilename;

    protected AbstractManager(SystemInfo systemInfo, String string) {
        this.parent = systemInfo;
        this.systemFilename = string;
    }

    public SystemInfo getParent() {
        return this.parent;
    }

    public void initByLoad() {
        if (this.systemFilename == null) {
            this.initByClean();
            return;
        }
        try {
            System.out.println("reading database file. [" + this.systemFilename + "]");
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.systemFilename)));
            this.loadClasses(objectInputStream);
        }
        catch (Exception exception) {
            System.err.println(exception.getClass().getName());
            exception.printStackTrace();
            System.err.println("-------------------------");
            this.initByClean();
        }
    }

    public void onStartup() {
    }

    public void onExit() {
        this.save();
    }

    void save() {
        if (this.systemFilename == null) {
            return;
        }
        if (this.systemFilename.equals("")) {
            return;
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.systemFilename)));
            System.out.println("writting database [" + this.systemFilename + "]...");
            this.saveClasses(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
            System.out.println("finished.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract void initByClean();

    protected abstract void loadClasses(ObjectInputStream var1) throws Exception;

    protected abstract void saveClasses(ObjectOutputStream var1) throws Exception;
}

