/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AnnualSubjectFactory;
import arg.money.IdComparator;
import arg.money.NumberIdentical;
import arg.money.ProjectData;
import arg.money.Subject;
import arg.money.SubjectCurrentMoney;
import arg.money.SubjectMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AnnualData
implements NumberIdentical,
Serializable {
    static final long serialVersionUID = -6770198245155884431L;
    transient ProjectData parent;
    int year;
    Date startedDate = null;
    Date closedDate = null;
    List currentMoneys = new ArrayList();
    List initialMoneys = new ArrayList();

    public AnnualData(ProjectData projectData, int n) {
        this.parent = projectData;
        this.setYear(n);
        this.startedDate = new Date();
        this.sync();
    }

    protected AnnualData(AnnualData annualData, ProjectData projectData) {
        this.parent = projectData;
        this.setYear(annualData.getYear());
        this.startedDate = annualData.getStartedDate();
        int n = 0;
        while (n < annualData.initialMoneys.size()) {
            SubjectMoney subjectMoney = (SubjectMoney)annualData.initialMoneys.get(n);
            this.initialMoneys.add(subjectMoney.getCopy(this));
            SubjectCurrentMoney subjectCurrentMoney = (SubjectCurrentMoney)annualData.currentMoneys.get(n);
            this.currentMoneys.add(subjectCurrentMoney.getCopy(this));
            ++n;
        }
    }

    public ProjectData getParent() {
        return this.parent;
    }

    public void setParent(ProjectData projectData) {
        this.parent = projectData;
    }

    public int getId() {
        return this.getYear();
    }

    public void setYear(int n) {
        this.year = n;
    }

    public int getYear() {
        return this.year;
    }

    public Date getStartedDate() {
        return this.startedDate;
    }

    public Date getClosedDate() {
        return this.closedDate;
    }

    public void setStartedDate(Date date) {
        this.startedDate = date;
    }

    public void setClosedDate(Date date) {
        this.closedDate = date;
    }

    public void prepareNextYear(AnnualData annualData) {
    }

    public AnnualData getCopy(ProjectData projectData) {
        AnnualData annualData = new AnnualData(this, projectData);
        return annualData;
    }

    public void sync() {
        ArrayList<SubjectCurrentMoney> arrayList = new ArrayList<SubjectCurrentMoney>();
        ArrayList<SubjectMoney> arrayList2 = new ArrayList<SubjectMoney>();
        Iterator iterator = this.getParent().getSubjects().iterator();
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            int n = subject.getId();
            SubjectMoney subjectMoney = this.getInitialMoney(n);
            SubjectMoney subjectMoney2 = AnnualSubjectFactory.getSubjectMoney(this, subject, subjectMoney);
            arrayList2.add(subjectMoney2);
            SubjectCurrentMoney subjectCurrentMoney = this.getCurrentMoney(n);
            SubjectCurrentMoney subjectCurrentMoney2 = AnnualSubjectFactory.getSubjectCurrentMoney(this, subject, subjectCurrentMoney);
            arrayList.add(subjectCurrentMoney2);
        }
        this.initialMoneys = arrayList2;
        this.currentMoneys = arrayList;
        Collections.sort(this.initialMoneys, IdComparator.getInstance());
        Collections.sort(this.currentMoneys, IdComparator.getInstance());
    }

    public List getInitialMoneys() {
        return this.initialMoneys;
    }

    public List getCurrentMoneys() {
        return this.currentMoneys;
    }

    public SubjectMoney getInitialMoney(int n) {
        return (SubjectMoney)IdComparator.search(this.initialMoneys, n);
    }

    public SubjectCurrentMoney getCurrentMoney(int n) {
        return (SubjectCurrentMoney)IdComparator.search(this.currentMoneys, n);
    }

    public String toString() {
        return this.getClass().getName() + ": INI:" + this.initialMoneys.size() + "  CUR:" + this.currentMoneys.size() + "  :" + this.getStartedDate();
    }
}

