/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.GroupData;
import arg.money.IdComparator;
import arg.money.SecurityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GroupManager {
    List groups;
    int curGid = 0;
    SecurityManager parent;

    public GroupManager(SecurityManager securityManager) {
        this.parent = securityManager;
        this.groups = new ArrayList();
    }

    public SecurityManager getParent() {
        return this.parent;
    }

    public GroupData addGroup(String string, String string2) {
        GroupData groupData = new GroupData(string, string2, this.curGid);
        this.groups.add(groupData);
        Collections.sort(this.groups, IdComparator.getInstance());
        ++this.curGid;
        return groupData;
    }

    public GroupData getGroup(int n) {
        return (GroupData)IdComparator.search(this.groups, n);
    }

    public List getGroups() {
        return this.groups;
    }

    public void removeGroup(int n) {
        if (n == 0) {
            System.out.println("Cannot remove admin group.");
            return;
        }
        GroupData groupData = this.getGroup(n);
        if (groupData != null) {
            this.groups.remove(groupData);
            Collections.sort(this.groups, IdComparator.getInstance());
        }
    }

    boolean getPermission(int n, int n2, int n3) {
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            GroupData groupData = (GroupData)iterator.next();
            if (!groupData.getPermission(n, n2, n3)) continue;
            return true;
        }
        return false;
    }

    boolean getAdminPermission(int n) {
        GroupData groupData = (GroupData)this.groups.get(0);
        return groupData.isBelonging(n);
    }

    void loadClasses(List list) {
        Integer n = (Integer)list.get(0);
        this.curGid = n;
        this.groups = (List)list.get(1);
        Collections.sort(this.groups, IdComparator.getInstance());
    }

    List saveClasses() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new Integer(this.curGid));
        linkedList.add(this.groups);
        return linkedList;
    }

    void initByClean() {
        GroupData groupData = this.addGroup("Admin group", "System Administration Group");
        groupData.addUser(0);
        System.out.println("Made admin group.");
    }
}

