/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AnnualData;
import arg.money.CurrentAmountData;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectSubgroup;
import arg.money.SystemInfo;
import java.util.Iterator;

public class ProjectCalculation {
    SystemInfo system;
    int pid;
    int year;

    public ProjectCalculation(SystemInfo systemInfo, int n, int n2) {
        this.system = systemInfo;
        this.pid = n;
        this.year = n2;
    }

    public ProjectCalculation(SystemInfo systemInfo, int n) {
        this.system = systemInfo;
        this.pid = n;
        this.year = this.getProjectData().getCurYear();
    }

    SlipManager getSlipManager() {
        return this.system.getSlipManager();
    }

    ProjectData getProjectData() {
        return this.system.getProjectManager().getProjectData(this.pid);
    }

    AnnualData getAnnualData() {
        ProjectData projectData = this.getProjectData();
        return projectData.getAnnual(this.year);
    }

    public CurrentAmountData getCurrentAmountDataOfSubject(int n) {
        return this.getAnnualData().getCurrentMoney(n).getAmounts(this.getSlipManager());
    }

    public long getCurrentAmountOfSubject(int n) {
        return this.getAnnualData().getCurrentMoney(n).getAmounts(this.getSlipManager()).getCurrentAmount();
    }

    public long getInitialAmountOfSubject(int n) {
        return this.getAnnualData().getInitialMoney(n).getMoney();
    }

    public long getCurrentAmountOfSubjectGroup(int n) {
        Iterator iterator = this.getProjectData().getSubjects().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            SubjectGroup subjectGroup = this.getProjectData().getGroupBySubject(subject.getId());
            if (subjectGroup.getId() != n) continue;
            n2 = (int)((long)n2 + this.getCurrentAmountOfSubject(subject.getId()));
        }
        return n2;
    }

    public long getCurrentAmountOfSubjectSubgroup(int n) {
        Iterator iterator = this.getProjectData().getSubjects().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            SubjectSubgroup subjectSubgroup = this.getProjectData().getSubgroupBySubject(subject.getId());
            if (subjectSubgroup.getId() != n) continue;
            n2 = (int)((long)n2 + this.getCurrentAmountOfSubject(subject.getId()));
        }
        return n2;
    }

    public long getInitialAmountOfSubjectSubgroup(int n) {
        Iterator iterator = this.getProjectData().getSubjects().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            SubjectSubgroup subjectSubgroup = this.getProjectData().getSubgroupBySubject(subject.getId());
            if (subjectSubgroup.getId() != n) continue;
            n2 = (int)((long)n2 + this.getInitialAmountOfSubject(subject.getId()));
        }
        return n2;
    }

    public long getInitialAmountOfSubjectGroup(int n) {
        Iterator iterator = this.getProjectData().getSubjects().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            SubjectGroup subjectGroup = this.getProjectData().getGroupBySubject(subject.getId());
            if (subjectGroup.getId() != n) continue;
            n2 = (int)((long)n2 + this.getInitialAmountOfSubject(subject.getId()));
        }
        return n2;
    }
}

