/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AmountData;
import arg.money.AnnualData;
import arg.money.CurrentAmountData;
import arg.money.IdComparator;
import arg.money.NumberIdentical;
import arg.money.RemovalException;
import arg.money.ReservableObject;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectCurrentMoney;
import arg.money.SubjectGroup;
import arg.money.SubjectMoney;
import arg.money.SubjectSubgroup;
import arg.money.SystemUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProjectData
implements Serializable,
NumberIdentical,
ReservableObject {
    static final long serialVersionUID = -7499542006944819134L;
    int pid;
    int curYear = 0;
    String name;
    String comment;
    int curReceiptNumber = 0;
    List annuals = new ArrayList();
    List subjects = new ArrayList();
    int curSubjectId = 0;
    List subjectGroups = new ArrayList();
    int curSubjectGroupId = 0;
    List subjectSubgroups = new ArrayList();
    int curSubjectSubgroupId = 0;
    transient boolean lock = false;

    public ProjectData(int n, String string, String string2) {
        this();
        this.pid = n;
        this.name = string;
        this.comment = string2;
        this.curYear = SystemUtil.getYear();
        this.makeNewAnnualData(this.getCurYear());
    }

    protected ProjectData(ProjectData projectData) {
        this();
        this.pid = projectData.getId();
        this.name = projectData.getName();
        this.comment = projectData.getComment();
        this.curYear = projectData.getCurYear();
    }

    public int getId() {
        return this.pid;
    }

    public void setCurYear(int n) {
        this.curYear = n;
    }

    public int getCurYear() {
        return this.curYear;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCurReceiptNumber(int n) {
        this.curReceiptNumber = n;
    }

    public int getCurReceiptNumber() {
        return this.curReceiptNumber;
    }

    public List getAnnuals() {
        return this.annuals;
    }

    public AnnualData makeNewAnnualData(int n) {
        if (this.getAnnual(n) != null) {
            System.err.println("Project " + this.getName() + " has already had annual data...");
            return null;
        }
        AnnualData annualData = new AnnualData(this, n);
        List list = this.annuals;
        synchronized (list) {
            this.annuals.add(annualData);
            Collections.sort(this.annuals, IdComparator.getInstance());
        }
        return annualData;
    }

    public List getSubjects() {
        return this.subjects;
    }

    public Subject addSubject(String string, String string2, int n, int n2) {
        Subject subject = new Subject(this.curSubjectId, n, n2, string, string2);
        ProjectData projectData = this;
        synchronized (projectData) {
            ++this.curSubjectId;
            this.subjects.add(subject);
            Collections.sort(this.subjects, IdComparator.getInstance());
            this.syncAnnualData();
        }
        return subject;
    }

    public void removeSubject(int n, SlipManager slipManager) throws RemovalException {
        Subject subject = this.getSubject(n);
        if (slipManager == null) {
            throw new RemovalException("NullSlipManager");
        }
        if (subject == null) {
            throw new RemovalException("CannotFindSubject");
        }
        if (this.isExistSlip(n, slipManager)) {
            throw new RemovalException("ExistSlip");
        }
        ProjectData projectData = this;
        synchronized (projectData) {
            this.subjects.remove(subject);
            this.syncAnnualData();
        }
    }

    private boolean isExistSlip(int n, SlipManager slipManager) {
        List list = slipManager.query(-1, this.getId());
        slipManager.queryBySubject(n, n, list);
        return !slipManager.getList(list).isEmpty();
    }

    public List getSubjectGroups() {
        return this.subjectGroups;
    }

    public SubjectGroup addSubjectGroup(String string, String string2, int n) {
        SubjectGroup subjectGroup = new SubjectGroup(this.curSubjectGroupId, string, string2, n);
        ProjectData projectData = this;
        synchronized (projectData) {
            ++this.curSubjectGroupId;
            this.subjectGroups.add(subjectGroup);
            Collections.sort(this.subjectGroups, IdComparator.getInstance());
            this.syncAnnualData();
        }
        return subjectGroup;
    }

    public void removeSubjectGroup(int n, SlipManager slipManager) throws RemovalException {
        NumberIdentical numberIdentical;
        SubjectGroup subjectGroup = this.getSubjectGroup(n);
        if (slipManager == null) {
            throw new RemovalException("NullSlipManager");
        }
        if (subjectGroup == null) {
            throw new RemovalException("CannotFindSubjctGroup");
        }
        Iterator iterator = this.subjects.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (Subject)iterator.next();
            if (((Subject)numberIdentical).getGroupId() != n || !this.isExistSlip(((Subject)numberIdentical).getId(), slipManager)) continue;
            throw new RemovalException("ExistSlip");
        }
        iterator = this.subjects.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (Subject)iterator.next();
            if (((Subject)numberIdentical).getGroupId() != n) continue;
            iterator.remove();
        }
        iterator = this.subjectSubgroups.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (SubjectSubgroup)iterator.next();
            if (((SubjectSubgroup)numberIdentical).getGroupId() != n) continue;
            iterator.remove();
        }
        numberIdentical = this;
        synchronized (numberIdentical) {
            this.subjectGroups.remove(subjectGroup);
            this.syncAnnualData();
        }
    }

    public List getSubjectSubgroups() {
        return this.subjectSubgroups;
    }

    public SubjectSubgroup addSubjectSubgroup(String string, String string2, int n) {
        SubjectSubgroup subjectSubgroup = new SubjectSubgroup(this.curSubjectSubgroupId, n, string, string2);
        ProjectData projectData = this;
        synchronized (projectData) {
            ++this.curSubjectSubgroupId;
            this.subjectSubgroups.add(subjectSubgroup);
            Collections.sort(this.subjectSubgroups, IdComparator.getInstance());
            this.syncAnnualData();
        }
        return subjectSubgroup;
    }

    public void removeSubjectSubgroup(int n, SlipManager slipManager) throws RemovalException {
        Object object;
        SubjectSubgroup subjectSubgroup = this.getSubjectSubgroup(n);
        if (subjectSubgroup == null) {
            throw new RemovalException("CannotFindSubgroup");
        }
        if (slipManager == null) {
            throw new RemovalException("NullSlipManager");
        }
        boolean bl = false;
        block3: while (!bl) {
            bl = true;
            object = this.subjects.iterator();
            while (object.hasNext()) {
                Subject subject = (Subject)object.next();
                if (subject.getSubgroupId() != n) continue;
                this.removeSubject(subject.getId(), slipManager);
                bl = false;
                continue block3;
            }
        }
        object = this;
        synchronized (object) {
            this.subjectSubgroups.remove(subjectSubgroup);
            this.syncAnnualData();
        }
    }

    public Subject getSubject(int n) {
        return (Subject)IdComparator.search(this.subjects, n);
    }

    public AnnualData getAnnual(int n) {
        return (AnnualData)IdComparator.search(this.annuals, n);
    }

    public SubjectGroup getGroupBySubject(int n) {
        Subject subject = this.getSubject(n);
        return this.getSubjectGroup(subject.getGroupId());
    }

    public SubjectSubgroup getSubgroupBySubject(int n) {
        Subject subject = this.getSubject(n);
        return this.getSubjectSubgroup(subject.getSubgroupId());
    }

    public SubjectGroup getSubjectGroup(int n) {
        return (SubjectGroup)IdComparator.search(this.subjectGroups, n);
    }

    public SubjectSubgroup getSubjectSubgroup(int n) {
        return (SubjectSubgroup)IdComparator.search(this.subjectSubgroups, n);
    }

    public void balanceSlips(SlipManager slipManager) {
        int n = this.getCurYear();
        AnnualData annualData = this.getAnnual(n);
        this.makeNewAnnualData(n + 1);
        AnnualData annualData2 = this.getAnnual(n + 1);
        Iterator iterator = this.getSubjects().iterator();
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            SubjectGroup subjectGroup = this.getGroupBySubject(subject.getId());
            SubjectCurrentMoney subjectCurrentMoney = annualData.getCurrentMoney(subject.getId());
            CurrentAmountData currentAmountData = subjectCurrentMoney.getAmounts(slipManager);
            if (subjectGroup.isClear()) continue;
            SubjectMoney subjectMoney = annualData2.getInitialMoney(subject.getId());
            subjectMoney.setMoney(currentAmountData.getCurrentAmount());
        }
        annualData.setClosedDate(new Date());
        this.setCurYear(n + 1);
    }

    public CurrentAmountData calculate(SlipManager slipManager, int n, int n2) {
        AnnualData annualData = this.getAnnual(n);
        List list = slipManager.query(n, this.getId());
        slipManager.queryBySubject(n2, n2, list);
        List list2 = slipManager.getList(list);
        AmountData amountData = slipManager.calculate(list2, n2);
        SubjectGroup subjectGroup = this.getGroupBySubject(n2);
        long l = subjectGroup.getTotalAmount(amountData.getCreditAmount(), amountData.getDebitAmount()) + annualData.getInitialMoney(n2).getMoney();
        return new CurrentAmountData(amountData, l);
    }

    public void syncAnnualData() {
        AnnualData annualData = this.getAnnual(this.getCurYear());
        annualData.sync();
    }

    public ProjectData() {
    }

    public void load(List list) {
        try {
            if (list.size() >= 12) {
                int n = 0;
                this.pid = (Integer)list.get(n++);
                this.setCurYear((Integer)list.get(n++));
                this.setName((String)list.get(n++));
                this.setComment((String)list.get(n++));
                this.setCurReceiptNumber((Integer)list.get(n++));
                this.annuals = (List)list.get(n++);
                int n2 = 0;
                while (n2 < this.annuals.size()) {
                    ((AnnualData)this.annuals.get(n2)).setParent(this);
                    ++n2;
                }
                this.subjects = (List)list.get(n++);
                this.curSubjectId = (Integer)list.get(n++);
                this.subjectGroups = (List)list.get(n++);
                this.curSubjectGroupId = (Integer)list.get(n++);
                this.subjectSubgroups = (List)list.get(n++);
                this.curSubjectSubgroupId = (Integer)list.get(n++);
                Collections.sort(this.subjects, IdComparator.getInstance());
                Collections.sort(this.subjectSubgroups, IdComparator.getInstance());
                Collections.sort(this.subjectGroups, IdComparator.getInstance());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List save() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new Integer(this.getId()));
        linkedList.add(new Integer(this.getCurYear()));
        linkedList.add(this.getName());
        linkedList.add(this.getComment());
        linkedList.add(new Integer(this.getCurReceiptNumber()));
        linkedList.add(this.annuals);
        linkedList.add(this.subjects);
        linkedList.add(new Integer(this.curSubjectId));
        linkedList.add(this.subjectGroups);
        linkedList.add(new Integer(this.curSubjectGroupId));
        linkedList.add(this.subjectSubgroups);
        linkedList.add(new Integer(this.curSubjectSubgroupId));
        return linkedList;
    }

    public ProjectData getCopy() {
        NumberIdentical numberIdentical;
        ProjectData projectData = new ProjectData(this);
        projectData.setCurYear(this.getCurYear());
        projectData.setCurReceiptNumber(this.getCurReceiptNumber());
        Iterator iterator = this.subjects.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (Subject)iterator.next();
            projectData.subjects.add(((Subject)numberIdentical).getCopy());
        }
        projectData.curSubjectId = this.curSubjectId;
        iterator = this.subjectGroups.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (SubjectGroup)iterator.next();
            projectData.subjectGroups.add(((SubjectGroup)numberIdentical).getCopy());
        }
        projectData.curSubjectGroupId = this.curSubjectGroupId;
        iterator = this.subjectSubgroups.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (SubjectSubgroup)iterator.next();
            projectData.subjectSubgroups.add(((SubjectSubgroup)numberIdentical).getCopy());
        }
        projectData.curSubjectSubgroupId = this.curSubjectSubgroupId;
        iterator = this.annuals.iterator();
        while (iterator.hasNext()) {
            numberIdentical = (AnnualData)iterator.next();
            projectData.annuals.add(((AnnualData)numberIdentical).getCopy(projectData));
        }
        return projectData;
    }

    public synchronized boolean lock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public synchronized void unlock() {
        this.lock = false;
    }
}

