/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.ProjectData;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectSubgroup;
import arg.money.SystemUtil;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.io.EasyWriter;
import jp.gr.java_conf.ccs2.util.ResourceFile;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class ProjectMaker {
    public static void make(ProjectData projectData, String string) {
        File file;
        ResourceBundle resourceBundle = null;
        if (string == null) {
            string = "";
        }
        if (!(file = new File(string)).exists()) {
            resourceBundle = ProjectMaker.defaultResource();
        } else {
            resourceBundle = ResourceFile.getResourceFile(string);
            if (resourceBundle == null) {
                String string2 = "Project resource file[" + string + "] not found...";
                SystemUtil.logMessage(string2);
                resourceBundle = ProjectMaker.defaultResource();
            }
        }
        if (resourceBundle == null) {
            SystemUtil.logMessage("Can not initialize the project [" + projectData.getName() + "]...");
            return;
        }
        ProjectMaker.init(projectData, resourceBundle);
    }

    private static ResourceBundle defaultResource() {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("arg.money.defaultProject");
        }
        catch (MissingResourceException missingResourceException) {
            SystemUtil.logMessage("Default project resource file not found...");
        }
        return resourceBundle;
    }

    private static void init(ProjectData projectData, ResourceBundle resourceBundle) {
        String string = "";
        try {
            string = resourceBundle.getString("root");
            String[] stringArray = StringUtil.split(string);
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                SubjectGroup subjectGroup = projectData.addSubjectGroup(string2, ProjectMaker.getComment(resourceBundle, string2), ProjectMaker.getBalanceGroup(resourceBundle, string2));
                string = resourceBundle.getString(string2);
                String[] stringArray2 = StringUtil.split(string);
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    string2 = stringArray2[n2];
                    SubjectSubgroup subjectSubgroup = projectData.addSubjectSubgroup(string2, ProjectMaker.getComment(resourceBundle, string2), subjectGroup.getId());
                    string = resourceBundle.getString(string2);
                    String[] stringArray3 = StringUtil.split(string);
                    int n3 = 0;
                    while (n3 < stringArray3.length) {
                        string2 = stringArray3[n3];
                        Subject subject = projectData.addSubject(string2, ProjectMaker.getComment(resourceBundle, string2), subjectGroup.getId(), subjectSubgroup.getId());
                        subject.setSpecialLabel(ProjectMaker.getSpecialLabel(resourceBundle, string2));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (MissingResourceException missingResourceException) {
            SystemUtil.logMessage("Invalid resource file... : " + string);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private static int getSpecialLabel(ResourceBundle resourceBundle, String string) {
        int[] nArray = SystemUtil.getSpecialValues();
        String[] stringArray = SystemUtil.getSpecialLabels();
        int n = 0;
        try {
            String string2 = resourceBundle.getString(string + "_special");
            int n2 = 0;
            while (n2 < nArray.length) {
                if (string2.compareToIgnoreCase(stringArray[n2]) == 0) {
                    n = nArray[n2];
                    break;
                }
                ++n2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return n;
    }

    private static String getComment(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string + "@");
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "";
        }
        return string2;
    }

    private static int getBalanceGroup(ResourceBundle resourceBundle, String string) {
        int[] nArray = SystemUtil.getBalanceGroupValues();
        String[] stringArray = SystemUtil.getBalanceGroupLabels();
        int n = nArray[0];
        try {
            String string2 = resourceBundle.getString(string + "_group");
            int n2 = 0;
            while (n2 < nArray.length) {
                if (string2.compareToIgnoreCase(stringArray[n2]) == 0) {
                    n = nArray[n2];
                    break;
                }
                ++n2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            SystemUtil.logMessage("balance group label : " + string + " not found");
        }
        return n;
    }

    public static void save(ProjectData projectData, String string) {
        String string2;
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = "root=";
        Iterator iterator = projectData.getSubjectGroups().iterator();
        while (iterator.hasNext()) {
            object = (SubjectGroup)iterator.next();
            string3 = string3 + ((SubjectGroup)object).getName() + " ";
            linkedList.add(ProjectMaker.transComment(((SubjectGroup)object).getName(), ((SubjectGroup)object).getComment()));
            linkedList.add(ProjectMaker.transBalanceGroup(((SubjectGroup)object).getName(), ((SubjectGroup)object).getBalanceGroup()));
            string2 = ((SubjectGroup)object).getName() + "=";
            Iterator iterator2 = projectData.getSubjectSubgroups().iterator();
            while (iterator2.hasNext()) {
                SubjectSubgroup subjectSubgroup = (SubjectSubgroup)iterator2.next();
                if (subjectSubgroup.getGroupId() != ((SubjectGroup)object).getId()) continue;
                string2 = string2 + subjectSubgroup.getName() + " ";
                linkedList.add(ProjectMaker.transComment(subjectSubgroup.getName(), subjectSubgroup.getComment()));
                String string4 = subjectSubgroup.getName() + "=";
                Iterator iterator3 = projectData.getSubjects().iterator();
                while (iterator3.hasNext()) {
                    Subject subject = (Subject)iterator3.next();
                    if (subject.getSubgroupId() != subjectSubgroup.getId()) continue;
                    string4 = string4 + subject.getName() + " ";
                    linkedList.add(ProjectMaker.transComment(subject.getName(), subject.getComment()));
                    linkedList.add(ProjectMaker.transSpecialLabel(subject.getName(), subject.getSpecialLabel()));
                }
                linkedList.add(0, string4);
                linkedList.add("");
            }
            linkedList.add(0, string2);
            linkedList.add("");
        }
        linkedList.add(0, string3);
        linkedList.add(0, "");
        object = new EasyWriter(string);
        if (!((EasyWriter)object).isOk()) {
            string2 = "Can not write resource file [" + string + "]";
            SystemUtil.logMessage(string2);
            return;
        }
        ((EasyWriter)object).println("#######################");
        ((EasyWriter)object).println("# Project Resource file");
        ((EasyWriter)object).println("# [" + projectData.getName() + "]");
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((EasyWriter)object).println(iterator.next().toString());
        }
        ((EasyWriter)object).close();
    }

    private static String transComment(String string, String string2) {
        return string + "@=" + string2;
    }

    private static String transSpecialLabel(String string, int n) {
        int[] nArray = SystemUtil.getSpecialValues();
        String[] stringArray = SystemUtil.getSpecialLabels();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return string + "_special=" + stringArray[n2];
            }
            ++n2;
        }
        SystemUtil.logMessage("GSpecial label not found. [" + n + "]");
        return "";
    }

    private static String transBalanceGroup(String string, int n) {
        int[] nArray = SystemUtil.getBalanceGroupValues();
        String[] stringArray = SystemUtil.getBalanceGroupLabels();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return string + "_group=" + stringArray[n2];
            }
            ++n2;
        }
        SystemUtil.logMessage("Group label not found. [" + n + "]");
        return "";
    }
}

