/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AbstractManager;
import arg.money.AnnualData;
import arg.money.DataLockingException;
import arg.money.IdComparator;
import arg.money.ProjectData;
import arg.money.ProjectMaker;
import arg.money.SlipManager;
import arg.money.SubjectCurrentMoney;
import arg.money.SubjectGroup;
import arg.money.SubjectMoney;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProjectManager
extends AbstractManager {
    List projects = new ArrayList();
    int curPid = 0;

    public ProjectManager(SystemInfo systemInfo) {
        super(systemInfo, systemInfo.getProjectsFilename());
    }

    public List getProjects() {
        return this.projects;
    }

    public ProjectData makeProject(String string, String string2) {
        ProjectData projectData = new ProjectData(this.curPid++, string, string2);
        return projectData;
    }

    public void removeProject(int n) throws DataLockingException {
        ProjectData projectData = this.lockProjectData(n);
        SlipManager slipManager = this.getParent().getSlipManager();
        if (projectData != null) {
            projectData = this.getProjectData(n);
            this.projects.remove(projectData);
            slipManager.removeProject(n);
        }
        slipManager.modify(-1, -1);
    }

    public ProjectData getProjectData(int n) {
        return (ProjectData)IdComparator.search(this.projects, n);
    }

    public ProjectData lockProjectData(int n) throws DataLockingException {
        ProjectData projectData = (ProjectData)IdComparator.search(this.projects, n);
        if (projectData.lock()) {
            this.modify(projectData.getCurYear(), n);
            return projectData.getCopy();
        }
        throw new DataLockingException("ProjectDataLocked");
    }

    public void cancelProjectData(ProjectData projectData) {
        ProjectData projectData2 = this.getProjectData(projectData.getId());
        projectData2.unlock();
        this.modify(projectData2.getCurYear(), projectData2.getId());
    }

    public void comitProjectData(ProjectData projectData) {
        ProjectData projectData2 = this.getProjectData(projectData.getId());
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (projectData2 != null) {
                if (projectData2 != projectData) {
                    projectData2.unlock();
                    this.projects.remove(projectData2);
                    this.projects.add(projectData);
                } else {
                    projectData.unlock();
                }
            } else {
                this.projects.add(projectData);
            }
            Collections.sort(this.projects, IdComparator.getInstance());
        }
        projectData = this.getProjectData(projectData.getId());
        this.modify(projectData.getCurYear(), projectData.getId());
    }

    public void modify(int n, int n2) {
        SlipManager slipManager = this.getParent().getSlipManager();
        slipManager.modify(n, n2);
    }

    public void makeNextYear(SlipManager slipManager) throws DataLockingException {
        Iterator iterator = this.projects.iterator();
        while (iterator.hasNext()) {
            ProjectData projectData = (ProjectData)iterator.next();
            this.lockProjectData(projectData.getId());
            AnnualData annualData = projectData.getAnnual(projectData.getCurYear());
            annualData.setClosedDate(new Date());
            AnnualData annualData2 = projectData.makeNewAnnualData(projectData.getCurYear() + 1);
            int n = 0;
            while (n < annualData.currentMoneys.size()) {
                SubjectCurrentMoney subjectCurrentMoney = (SubjectCurrentMoney)annualData.currentMoneys.get(n);
                SubjectGroup subjectGroup = projectData.getGroupBySubject(subjectCurrentMoney.getId());
                if (subjectGroup.getBalanceGroup() == 0 || subjectGroup.getBalanceGroup() == 1) {
                    SubjectMoney subjectMoney = annualData2.getInitialMoney(subjectCurrentMoney.getId());
                    subjectMoney.setMoney(subjectCurrentMoney.getCurrentAmount(slipManager));
                }
                ++n;
            }
            projectData.setCurYear(projectData.getCurYear() + 1);
            this.cancelProjectData(projectData);
        }
    }

    public void loadClasses(ObjectInputStream objectInputStream) throws Exception {
        List list = (List)objectInputStream.readObject();
        Integer n = (Integer)list.get(0);
        this.curPid = n;
        List list2 = (List)objectInputStream.readObject();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            List list3 = (List)iterator.next();
            ProjectData projectData = new ProjectData();
            projectData.load(list3);
            this.projects.add(projectData);
        }
        Collections.sort(this.projects, IdComparator.getInstance());
    }

    protected void initByClean() {
        this.projects.clear();
        System.out.println("New project database was created.");
        ProjectData projectData = this.makeProject(SystemUtil.getResourceString("DefaultProject"), SystemUtil.getResourceString("DefaultProjectCommenct"));
        ProjectMaker.make(projectData, this.getParent().getProjectResourceFilename());
        this.comitProjectData(projectData);
        System.out.println("Made a default project.");
    }

    public void saveClasses(ObjectOutputStream objectOutputStream) throws Exception {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(this.curPid));
        objectOutputStream.writeObject(linkedList);
        LinkedList<List> linkedList2 = new LinkedList<List>();
        Iterator iterator = this.projects.iterator();
        while (iterator.hasNext()) {
            ProjectData projectData = (ProjectData)iterator.next();
            linkedList2.add(projectData.save());
        }
        objectOutputStream.writeObject(linkedList2);
    }
}

