/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AbstractManager;
import arg.money.GroupData;
import arg.money.GroupManager;
import arg.money.ProjectData;
import arg.money.SessionData;
import arg.money.SessionManager;
import arg.money.SystemInfo;
import arg.money.UserManager;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SecurityManager
extends AbstractManager {
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    public static final int EDITABLE = 4;
    public static final int SETTLABLE = 8;
    public static final int ADMIN = 16;
    UserManager userManager = new UserManager(this);
    GroupManager groupManager = new GroupManager(this);
    SessionManager sessionManager;

    private SecurityManager(SystemInfo systemInfo, String string) {
        super(systemInfo, string);
    }

    public SecurityManager(SystemInfo systemInfo) {
        this(systemInfo, systemInfo.getSecurityFilename());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public int login(String string, String string2) {
        return this.getUserManager().login(string, string2);
    }

    public boolean getPermission(SessionData sessionData, int n, int n2) {
        if (!this.sessionManager.checkSession(sessionData)) {
            return false;
        }
        return this.getPermission(sessionData.getUid(), n, n2);
    }

    public boolean getAdminPermission(SessionData sessionData) {
        if (sessionData == null) {
            return false;
        }
        if (!this.sessionManager.checkSession(sessionData)) {
            return false;
        }
        return this.getAdminPermission(sessionData.getUid());
    }

    protected boolean getPermission(int n, int n2, int n3) {
        return this.getGroupManager().getPermission(n, n2, n3);
    }

    protected boolean getAdminPermission(int n) {
        return this.getGroupManager().getAdminPermission(n);
    }

    public List getPermittedProjects(int n, int n2) {
        List list = this.getParent().getProjectManager().getProjects();
        Iterator iterator = list.iterator();
        LinkedList<ProjectData> linkedList = new LinkedList<ProjectData>();
        while (iterator.hasNext()) {
            ProjectData projectData = (ProjectData)iterator.next();
            if (!this.getPermission(n, projectData.getId(), n2)) continue;
            linkedList.add(projectData);
        }
        return linkedList;
    }

    public List getBelongingGroups(int n) {
        List list = this.getGroupManager().getGroups();
        Iterator iterator = list.iterator();
        LinkedList<GroupData> linkedList = new LinkedList<GroupData>();
        while (iterator.hasNext()) {
            GroupData groupData = (GroupData)iterator.next();
            if (!groupData.isBelonging(n)) continue;
            linkedList.add(groupData);
        }
        return linkedList;
    }

    public void update() {
        this.getParent().getSlipManager().modify(-1, -1);
    }

    public void onStartup() {
        this.sessionManager = this.getParent().getSessionManager();
    }

    public void main(String[] stringArray) {
        SecurityManager securityManager = new SecurityManager(null, "test_security.dat");
        securityManager.initByLoad();
    }

    public void initByClean() {
        this.userManager.initByClean();
        this.groupManager.initByClean();
        System.out.println("New security database was created.");
    }

    public void loadClasses(ObjectInputStream objectInputStream) throws Exception {
        List list = (List)objectInputStream.readObject();
        List list2 = (List)objectInputStream.readObject();
        this.userManager.loadClasses(list2);
        list2 = (List)objectInputStream.readObject();
        this.groupManager.loadClasses(list2);
    }

    public void saveClasses(ObjectOutputStream objectOutputStream) throws Exception {
        LinkedList linkedList = new LinkedList();
        objectOutputStream.writeObject(linkedList);
        objectOutputStream.writeObject(this.userManager.saveClasses());
        objectOutputStream.writeObject(this.groupManager.saveClasses());
    }
}

