/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.NumberIdentical;
import arg.money.RuntimeInformation;
import arg.money.SessionManager;
import arg.money.UserData;
import arg.money.UserShell;
import java.io.Serializable;
import java.util.Date;

public class SessionData
implements NumberIdentical,
Serializable {
    int sessionId;
    int uid;
    Date date;
    RuntimeInformation runtimeInfo;
    transient SessionManager parent;
    transient UserShell shell;

    public SessionData(int n, int n2, SessionManager sessionManager, RuntimeInformation runtimeInformation) {
        this.sessionId = n2;
        this.parent = sessionManager;
        this.uid = n;
        this.date = new Date();
        this.runtimeInfo = runtimeInformation;
    }

    void startup() {
        this.shell = this.runtimeInfo.getShellFactory().getUserShell(this);
        this.shell.show();
    }

    public void terminate() {
        if (this.shell != null) {
            this.shell.close();
        }
        this.parent.removeSession(this.getId());
    }

    public void updateData(int n) {
        this.shell.update(n);
    }

    public int getId() {
        return this.sessionId;
    }

    public int getUid() {
        return this.uid;
    }

    public UserData getUser() {
        try {
            return this.getParent().getParent().getSecurityManager().getUserManager().getUser(this.getUid());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
    }

    public Date getDate() {
        return this.date;
    }

    public SessionManager getParent() {
        return this.parent;
    }

    public RuntimeInformation getRuntimeInformation() {
        return this.runtimeInfo;
    }
}

