/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AbstractManager;
import arg.money.IdComparator;
import arg.money.LoginShell;
import arg.money.RuntimeInformation;
import arg.money.SessionData;
import arg.money.SlipManager;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.UserData;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.ccs2.frame.CView;
import jp.gr.java_conf.ccs2.frame.Document;
import jp.gr.java_conf.ccs2.frame.View;
import jp.gr.java_conf.ccs2.io.EasyWriter;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class SessionManager
extends AbstractManager {
    List sessions = new ArrayList();
    int curSessionId = 0;
    List logs;
    int maxLog = 300;
    View view;
    static final String openLog = "+ : {0} opened from {1} at {2}";
    static final String closeLog = "- : {0} closed from {1} at {2}";
    static final String failLog = "* : {0} login failed from {1} at {2}";
    static final String invalidSessionLog = "! : {0} invalid session from {1} at {2}";

    public SessionManager(SystemInfo systemInfo) {
        super(systemInfo, systemInfo.getSessionLogFilename());
    }

    public void login(RuntimeInformation runtimeInformation) {
        block2: {
            int n;
            if (runtimeInformation == null) {
                return;
            }
            LoginShell loginShell = runtimeInformation.getShellFactory().getLoginShell();
            while (true) {
                loginShell.show();
                if (!loginShell.isOk()) break block2;
                n = this.getParent().getSecurityManager().login(loginShell.getName(), loginShell.getPassword());
                if (n != -1) break;
                runtimeInformation.getShellFactory().showMessage(SystemUtil.getResourceString("InvalidPassword"));
                this.log(failLog, runtimeInformation, loginShell.getName());
            }
            this.addSession(runtimeInformation, n);
        }
    }

    public boolean checkSession(SessionData sessionData) {
        try {
            if (sessionData == null) {
                return false;
            }
            SessionData sessionData2 = this.getSessionData(sessionData.getId());
            if (sessionData2 == null) {
                UserData userData = sessionData.getUser();
                String string = "(unknown)";
                if (userData != null) {
                    string = userData.getName();
                    this.log(invalidSessionLog, sessionData.getRuntimeInformation(), string);
                    return false;
                }
            }
            return sessionData2.getUid() == sessionData.getUid();
        }
        catch (RuntimeException runtimeException) {
            this.log("Error : " + runtimeException.getClass().getName() + " [" + runtimeException.getMessage() + "]");
            runtimeException.printStackTrace();
            return false;
        }
    }

    public SessionData addSession(RuntimeInformation runtimeInformation, int n) {
        if (this.getSessionDataByUser(n) != null) {
            runtimeInformation.getShellFactory().showMessage(SystemUtil.getResourceString("HadBeenLogin"));
            return null;
        }
        SessionData sessionData = new SessionData(n, this.curSessionId++, this, runtimeInformation);
        this.sessions.add(sessionData);
        Collections.sort(this.sessions, IdComparator.getInstance());
        UserData userData = sessionData.getUser();
        if (userData == null) {
            this.log(invalidSessionLog, sessionData.getRuntimeInformation(), "<unknown>");
            this.log("Connection refused.");
            this.sessions.remove(sessionData);
            return null;
        }
        this.log(openLog, sessionData.getRuntimeInformation(), userData.getName());
        sessionData.startup();
        return sessionData;
    }

    public void removeSession(int n) {
        SessionData sessionData = this.getSessionData(n);
        if (sessionData == null) {
            return;
        }
        this.sessions.remove(sessionData);
        UserData userData = sessionData.getUser();
        if (userData != null) {
            this.log(closeLog, sessionData.getRuntimeInformation(), userData.getName());
        }
    }

    public List getSessions() {
        return this.sessions;
    }

    public View getView() {
        if (this.view == null) {
            throw new NullPointerException();
        }
        return this.view;
    }

    public SessionData getSessionData(int n) {
        return (SessionData)IdComparator.search(this.sessions, n);
    }

    public SessionData getSessionDataByUser(int n) {
        Iterator iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            SessionData sessionData = (SessionData)iterator.next();
            if (sessionData.getUid() != n) continue;
            return sessionData;
        }
        return null;
    }

    void log(String string, RuntimeInformation runtimeInformation, String string2) {
        String string3 = "(null)";
        if (runtimeInformation != null) {
            string3 = runtimeInformation.getAccessPoint();
        }
        Object[] objectArray = new String[]{string2, string3, StringUtil.dateTimej(new Date())};
        this.log(MessageFormat.format(string, objectArray));
    }

    public void log(String string) {
        this.logs.add(string);
        System.out.println(string);
        if (this.maxLog < this.logs.size()) {
            this.logs.remove(0);
        }
    }

    public void onStartup() {
        SlipManager slipManager = this.getParent().getSlipManager();
        this.view = new SessionView(slipManager.getDocument());
    }

    public void onExit() {
        while (this.sessions.size() > 0) {
            SessionData sessionData = (SessionData)this.sessions.get(0);
            sessionData.terminate();
        }
        super.onExit();
    }

    public void loadClasses(ObjectInputStream objectInputStream) throws Exception {
        this.logs = (List)objectInputStream.readObject();
    }

    public void initByClean() {
        this.logs = new LinkedList();
    }

    public void saveClasses(ObjectOutputStream objectOutputStream) throws Exception {
        objectOutputStream.writeObject(this.logs);
        EasyWriter easyWriter = new EasyWriter("session_log.txt");
        Iterator iterator = this.logs.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            easyWriter.println(string);
        }
        easyWriter.flush();
    }

    void updateSessions(int n) {
        Iterator iterator = this.getSessions().iterator();
        while (iterator.hasNext()) {
            SessionData sessionData = (SessionData)iterator.next();
            sessionData.updateData(n);
        }
    }

    class SessionView
    extends CView {
        public SessionView(Document document) {
            super(document);
        }

        public void update(Object object) {
            int n = (Integer)object;
            SessionManager.this.updateSessions(n);
        }
    }
}

