/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.ASlipLine;
import arg.money.AbstractManager;
import arg.money.AmountData;
import arg.money.DataLockingException;
import arg.money.IdComparator;
import arg.money.ProjectData;
import arg.money.ProjectManager;
import arg.money.SlipElement;
import arg.money.SubjectGroup;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.TransferSlip;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.ccs2.frame.Document;

public class SlipManager
extends AbstractManager {
    List slipBooks = new LinkedList();
    Document document = new Document();

    private List getSlipBooks() {
        return this.slipBooks;
    }

    private SlipBook getSlipBook(int n, int n2) {
        Iterator iterator = this.slipBooks.iterator();
        while (iterator.hasNext()) {
            SlipBook slipBook = (SlipBook)iterator.next();
            if (slipBook.getYear() != n || slipBook.getPid() != n2) continue;
            return slipBook;
        }
        return this.addSlipBook(n, n2);
    }

    private SlipBook addSlipBook(int n, int n2) {
        SlipBook slipBook = new SlipBook(n, n2);
        this.slipBooks.add(slipBook);
        return slipBook;
    }

    void removeProject(int n) {
        Iterator iterator = this.slipBooks.iterator();
        while (iterator.hasNext()) {
            SlipBook slipBook = (SlipBook)iterator.next();
            if (slipBook.getPid() != n) continue;
            iterator.remove();
        }
    }

    public SlipManager(SystemInfo systemInfo) {
        super(systemInfo, systemInfo.getSlipsFilename());
    }

    public Document getDocument() {
        return this.document;
    }

    public TransferSlip getSlip(int n, int n2, int n3) {
        return this.getSlipBook(n, n2).getSlip(n3);
    }

    public TransferSlip lockSlip(int n, int n2, int n3) throws DataLockingException {
        TransferSlip transferSlip = this.getSlipBook(n, n2).getSlip(n3);
        if (transferSlip == null) {
            System.err.println("Y:" + n + "  PID:" + n2 + "  TID:" + n3);
            System.err.println("null slip data?");
            return null;
        }
        if (transferSlip.lock()) {
            this.modify(n, n2);
            return transferSlip.getCopy();
        }
        throw new DataLockingException("TransferSlipLocked");
    }

    public void cancelSlip(TransferSlip transferSlip) {
        TransferSlip transferSlip2 = this.getSlipBook(transferSlip.getYear(), transferSlip.getPid()).getSlip(transferSlip.getId());
        if (!transferSlip2.isLocked()) {
            SystemUtil.logMessage("Cancel TS failed. " + transferSlip2.toString());
            return;
        }
        transferSlip2.unlock();
        this.modify(transferSlip.getYear(), transferSlip.getPid());
    }

    public void comitSlip(TransferSlip transferSlip) {
        SlipBook slipBook;
        SlipBook slipBook2 = slipBook = this.getSlipBook(transferSlip.getYear(), transferSlip.getPid());
        synchronized (slipBook2) {
            slipBook.addSlip(transferSlip);
            transferSlip.unlock();
            transferSlip.modify();
        }
        this.modify(transferSlip.getYear(), transferSlip.getPid());
    }

    public TransferSlip makeSlip(ProjectData projectData, int n) {
        SlipBook slipBook = this.getSlipBook(projectData.getCurYear(), projectData.getId());
        return slipBook.makeSlip(projectData, n);
    }

    public void removeSlip(int n, int n2, int n3) {
        this.getSlipBook(n, n2).removeSlip(n3);
        this.modify(n, n2);
    }

    public void modify(int n, int n2) {
        if (n < 0 || n2 < 0) {
            Iterator iterator = this.slipBooks.iterator();
            while (iterator.hasNext()) {
                SlipBook slipBook = (SlipBook)iterator.next();
                if (slipBook.getPid() != n2 && slipBook.getYear() != n && (n >= 0 || n2 >= 0)) continue;
                slipBook.modify();
            }
        } else {
            this.getSlipBook(n, n2).modify();
        }
        this.document.updateViews(new Integer(n2));
    }

    public Date getLastModified(int n, int n2) {
        return this.getSlipBook(n, n2).getLastModified();
    }

    public List query(int n, int n2) {
        LinkedList linkedList = new LinkedList();
        if (n >= 0) {
            if (n2 >= 0) {
                linkedList.addAll(this.getSlipBook(n, n2).getSlips());
            } else {
                Iterator iterator = this.getSlipBooks().iterator();
                while (iterator.hasNext()) {
                    SlipBook slipBook = (SlipBook)iterator.next();
                    if (slipBook.getYear() != n) continue;
                    linkedList.addAll(slipBook.getSlips());
                }
            }
        } else if (n2 >= 0) {
            Iterator iterator = this.getSlipBooks().iterator();
            while (iterator.hasNext()) {
                SlipBook slipBook = (SlipBook)iterator.next();
                if (slipBook.getPid() != n2) continue;
                linkedList.addAll(slipBook.getSlips());
            }
        } else {
            Iterator iterator = this.getSlipBooks().iterator();
            while (iterator.hasNext()) {
                SlipBook slipBook = (SlipBook)iterator.next();
                linkedList.addAll(slipBook.getSlips());
            }
        }
        return this.query(linkedList);
    }

    public List query(List list) {
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        LinkedList<SlipWrapper> linkedList = new LinkedList<SlipWrapper>();
        while (iterator.hasNext()) {
            TransferSlip transferSlip = (TransferSlip)iterator.next();
            linkedList.add(new SlipWrapper(transferSlip, true));
        }
        return linkedList;
    }

    public List getList(List list) {
        Iterator iterator = list.iterator();
        LinkedList<TransferSlip> linkedList = new LinkedList<TransferSlip>();
        while (iterator.hasNext()) {
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected()) continue;
            linkedList.add(slipWrapper.getSlip());
        }
        return linkedList;
    }

    public void queryByDate(Date date, Date date2, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected()) continue;
            if (date != null && slipWrapper.getSlip().getDate().before(date)) {
                slipWrapper.setSelected(false);
                continue;
            }
            if (date2 == null || !slipWrapper.getSlip().getDate().after(date2)) continue;
            slipWrapper.setSelected(false);
        }
    }

    public void queryByGroup(int n, int n2, List list) {
        Iterator iterator = list.iterator();
        ProjectManager projectManager = this.getParent().getProjectManager();
        block0: while (iterator.hasNext()) {
            SubjectGroup subjectGroup;
            SlipElement slipElement;
            ASlipLine aSlipLine;
            int n3;
            ProjectData projectData;
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected()) continue;
            List list2 = slipWrapper.getLines();
            if (n != -1) {
                projectData = projectManager.getProjectData(slipWrapper.getSlip().getPid());
                n3 = 0;
                while (n3 < list2.size()) {
                    aSlipLine = (ASlipLine)list2.get(n3);
                    slipElement = aSlipLine.getLeft();
                    subjectGroup = projectData.getGroupBySubject(slipElement.getId());
                    if (subjectGroup.getId() == n) continue block0;
                    ++n3;
                }
            }
            if (n2 != -1) {
                projectData = projectManager.getProjectData(slipWrapper.getSlip().getPid());
                n3 = 0;
                while (n3 < list2.size()) {
                    aSlipLine = (ASlipLine)list2.get(n3);
                    slipElement = aSlipLine.getRight();
                    subjectGroup = projectData.getGroupBySubject(slipElement.getId());
                    if (subjectGroup.getId() == n2) continue block0;
                    ++n3;
                }
            }
            slipWrapper.setSelected(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void queryBySubject(int var1_1, int var2_2, List var3_3) {
        if (var1_1 == -1 && var2_2 == -1) {
            return;
        }
        var4_4 = var3_3.iterator();
        if (var1_1 != -1 && var2_2 != -1) {
            while (var4_4.hasNext()) {
                var5_5 = (SlipWrapper)var4_4.next();
                if (!var5_5.isSelected()) continue;
                var5_5.setSelected(var5_5.getSlip().existsSlipLineByLeftSubject(var1_1) != false || var5_5.getSlip().existsSlipLineByRightSubject(var2_2) != false);
            }
            return;
        }
        if (var1_1 == -1) ** GOTO lbl21
        while (var4_4.hasNext()) {
            var5_6 = (SlipWrapper)var4_4.next();
            if (!var5_6.isSelected()) continue;
            var5_6.setSelected(var5_6.getSlip().existsSlipLineByLeftSubject(var1_1));
        }
        return;
lbl-1000:
        // 1 sources

        {
            var5_7 = (SlipWrapper)var4_4.next();
            if (!var5_7.isSelected()) continue;
            var5_7.setSelected(var5_7.getSlip().existsSlipLineByRightSubject(var2_2));
lbl21:
            // 3 sources

            ** while (var4_4.hasNext())
        }
lbl22:
        // 1 sources

    }

    public void queryBySummary(String string, List list) {
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected()) continue;
            List list2 = slipWrapper.getLines();
            int n = 0;
            while (n < list2.size()) {
                ASlipLine aSlipLine = (ASlipLine)list2.get(n);
                if (aSlipLine.getSummary().indexOf(string) != -1) continue block0;
                ++n;
            }
            slipWrapper.setSelected(false);
        }
    }

    public void queryByUser(int n, List list) {
        if (n == -1) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected() || slipWrapper.getSlip().getUid() == n) continue;
            slipWrapper.setSelected(false);
        }
    }

    public void queryByReceipt(int n, List list) {
        if (n == -1) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected() || slipWrapper.getSlip().getReceiptNumber() == n) continue;
            slipWrapper.setSelected(false);
        }
    }

    public void queryByMoney(long l, List list) {
        if (l == -1L) {
            return;
        }
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            SlipWrapper slipWrapper = (SlipWrapper)iterator.next();
            if (!slipWrapper.isSelected()) continue;
            List list2 = slipWrapper.getLines();
            int n = 0;
            while (n < list2.size()) {
                ASlipLine aSlipLine = (ASlipLine)list2.get(n);
                if (aSlipLine.getLeft().getMoney() == l || aSlipLine.getRight().getMoney() == l) continue block0;
                ++n;
            }
            slipWrapper.setSelected(false);
        }
    }

    public AmountData calculate(List list, int n) {
        Iterator iterator = list.iterator();
        long l = 0L;
        long l2 = 0L;
        while (iterator.hasNext()) {
            TransferSlip transferSlip = (TransferSlip)iterator.next();
            List list2 = transferSlip.getLines();
            int n2 = 0;
            while (n2 < list2.size()) {
                ASlipLine aSlipLine = (ASlipLine)list2.get(n2);
                if (aSlipLine.existLeft() && (aSlipLine.getLeft().getId() == n || n < 0)) {
                    l += aSlipLine.getLeft().getMoney();
                }
                if (aSlipLine.existRight() && (aSlipLine.getRight().getId() == n || n < 0)) {
                    l2 += aSlipLine.getRight().getMoney();
                }
                ++n2;
            }
        }
        return new AmountData(l, l2);
    }

    protected void loadClasses(ObjectInputStream objectInputStream) throws Exception {
        List list = (List)objectInputStream.readObject();
        List list2 = (List)objectInputStream.readObject();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            List list3 = (List)iterator.next();
            SlipBook slipBook = new SlipBook();
            slipBook.loadClasses(list3);
            this.slipBooks.add(slipBook);
        }
    }

    protected void initByClean() {
        this.slipBooks.clear();
        System.out.println("New slip database was created.");
    }

    public void saveClasses(ObjectOutputStream objectOutputStream) throws Exception {
        LinkedList linkedList = new LinkedList();
        objectOutputStream.writeObject(linkedList);
        LinkedList<List> linkedList2 = new LinkedList<List>();
        Iterator iterator = this.slipBooks.iterator();
        while (iterator.hasNext()) {
            SlipBook slipBook = (SlipBook)iterator.next();
            linkedList2.add(slipBook.saveClasses());
        }
        objectOutputStream.writeObject(linkedList2);
    }

    class SlipWrapper {
        boolean selected;
        TransferSlip slip;

        SlipWrapper(TransferSlip transferSlip, boolean bl) {
            this.slip = transferSlip;
            this.selected = bl;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean bl) {
            this.selected = bl;
        }

        TransferSlip getSlip() {
            return this.slip;
        }

        List getLines() {
            return this.slip.getLines();
        }
    }

    class SlipBook
    implements Comparator {
        int pid;
        int year;
        int curSlipId = 0;
        List slips = new ArrayList();
        Date lastModified = new Date();

        SlipBook() {
        }

        SlipBook(int n, int n2) {
            this();
            this.setYear(n);
            this.setPid(n2);
        }

        void loadClasses(List list) throws Exception {
            Iterator iterator = list.iterator();
            this.setYear((Integer)iterator.next());
            this.setPid((Integer)iterator.next());
            this.setCurSlipId((Integer)iterator.next());
            this.lastModified = (Date)iterator.next();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                int n = (Integer)list2.get(0);
                TransferSlip transferSlip = new TransferSlip();
                transferSlip.load(list2);
                this.slips.add(transferSlip);
            }
            this.modify();
        }

        List saveClasses() throws Exception {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(new Integer(this.getYear()));
            linkedList.add(new Integer(this.getPid()));
            linkedList.add(new Integer(this.getCurSlipId()));
            linkedList.add(this.lastModified);
            Iterator iterator = this.slips.iterator();
            while (iterator.hasNext()) {
                TransferSlip transferSlip = (TransferSlip)iterator.next();
                linkedList.add(transferSlip.save());
            }
            return linkedList;
        }

        void setPid(int n) {
            this.pid = n;
        }

        void setYear(int n) {
            this.year = n;
        }

        void setCurSlipId(int n) {
            this.curSlipId = n;
        }

        int getPid() {
            return this.pid;
        }

        int getYear() {
            return this.year;
        }

        int getCurSlipId() {
            return this.curSlipId;
        }

        List getSlips() {
            return this.slips;
        }

        Date getLastModified() {
            return this.lastModified;
        }

        void modify() {
            Collections.sort(this.slips, this);
            this.lastModified.setTime(System.currentTimeMillis());
        }

        synchronized void addSlip(TransferSlip transferSlip) {
            TransferSlip transferSlip2 = this.getSlip(transferSlip.getId());
            if (transferSlip2 != null) {
                this.removeSlip(transferSlip2.getId());
            }
            this.slips.add(transferSlip);
            this.modify();
        }

        synchronized TransferSlip makeSlip(ProjectData projectData, int n) {
            TransferSlip transferSlip = new TransferSlip(this.curSlipId, projectData.getCurYear(), projectData.getCurReceiptNumber(), projectData.getId(), n, null);
            ++this.curSlipId;
            return transferSlip;
        }

        synchronized void removeSlip(int n) {
            TransferSlip transferSlip = this.getSlip(n);
            if (transferSlip == null) {
                return;
            }
            this.modify();
            this.slips.remove(transferSlip);
        }

        TransferSlip getSlip(int n) {
            return (TransferSlip)IdComparator.search(this.getSlips(), n);
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int compare(Object object, Object object2) {
            if (object instanceof TransferSlip && object2 instanceof TransferSlip) {
                TransferSlip transferSlip = (TransferSlip)object;
                TransferSlip transferSlip2 = (TransferSlip)object2;
                if (transferSlip.getDate().getTime() < transferSlip2.getDate().getTime()) {
                    return -1;
                }
                if (transferSlip.getDate().getTime() == transferSlip2.getDate().getTime()) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
    }
}

