/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AnnualData;
import arg.money.CurrentAmountData;
import arg.money.NumberIdentical;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import java.io.Serializable;
import java.util.Date;

public class SubjectCurrentMoney
implements NumberIdentical,
Serializable {
    static final long serialVersionUID = 4332927089652257543L;
    Date lastCalculated = new Date();
    CurrentAmountData amount;
    int sid;
    AnnualData parent;

    public SubjectCurrentMoney(AnnualData annualData, Subject subject) {
        this.parent = annualData;
        this.sid = subject.getId();
    }

    protected SubjectCurrentMoney(SubjectCurrentMoney subjectCurrentMoney, AnnualData annualData) {
        this.parent = annualData;
        this.sid = subjectCurrentMoney.getId();
    }

    public int getId() {
        return this.sid;
    }

    public CurrentAmountData getAmounts(SlipManager slipManager) {
        ProjectData projectData = this.parent.getParent();
        Date date = slipManager.getLastModified(this.parent.getYear(), projectData.getId());
        if (date.after(this.lastCalculated) || this.amount == null) {
            this.amount = this.calculate(projectData, slipManager);
            this.lastCalculated.setTime(System.currentTimeMillis());
        }
        return this.amount;
    }

    public long getCreditAmount(SlipManager slipManager) {
        return this.getAmounts(slipManager).getCreditAmount();
    }

    public long getDebitAmount(SlipManager slipManager) {
        return this.getAmounts(slipManager).getDebitAmount();
    }

    public long getCurrentAmount(SlipManager slipManager) {
        return this.getAmounts(slipManager).getCurrentAmount();
    }

    protected CurrentAmountData calculate(ProjectData projectData, SlipManager slipManager) {
        return projectData.calculate(slipManager, this.parent.getYear(), this.sid);
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.sid + "   money:" + this.amount;
    }

    public SubjectCurrentMoney getCopy(AnnualData annualData) {
        SubjectCurrentMoney subjectCurrentMoney = new SubjectCurrentMoney(this, annualData);
        return subjectCurrentMoney;
    }
}

