/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.AbstractManager;
import arg.money.ProjectManager;
import arg.money.ReportManager;
import arg.money.SecurityManager;
import arg.money.SessionManager;
import arg.money.SlipManager;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SystemInfo {
    SessionManager sessionManager;
    SecurityManager securityManager;
    ProjectManager projectManager;
    SlipManager slipManager;
    ReportManager reportManager;
    List managers = new LinkedList();
    String projectResource = null;
    String projectsFilename;
    String slipsFilename;
    String securityFilename;
    String sessionLogFilename;

    public SystemInfo(String string) {
    }

    public SystemInfo() {
        this.initByDefault();
        this.securityManager = new SecurityManager(this);
        this.managers.add(this.securityManager);
        this.projectManager = new ProjectManager(this);
        this.managers.add(this.projectManager);
        this.slipManager = new SlipManager(this);
        this.managers.add(this.slipManager);
        this.reportManager = new ReportManager(this);
        this.managers.add(this.reportManager);
        this.sessionManager = new SessionManager(this);
        this.managers.add(this.sessionManager);
        Iterator iterator = this.managers.iterator();
        while (iterator.hasNext()) {
            ((AbstractManager)iterator.next()).initByLoad();
        }
        this.onStartup();
    }

    protected void onStartup() {
        Iterator iterator = this.managers.iterator();
        while (iterator.hasNext()) {
            ((AbstractManager)iterator.next()).onStartup();
        }
        Date date = new Date();
        System.out.println("System is started up at " + date.toString());
    }

    public void onExit() {
        Iterator iterator = this.managers.iterator();
        while (iterator.hasNext()) {
            ((AbstractManager)iterator.next()).onExit();
        }
        Date date = new Date();
        System.out.println("System was terminated at " + date.toString());
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public SlipManager getSlipManager() {
        return this.slipManager;
    }

    public ReportManager getReportManager() {
        return this.reportManager;
    }

    public String getProjectResourceFilename() {
        return this.projectResource;
    }

    public String getProjectsFilename() {
        return this.projectsFilename;
    }

    public String getSlipsFilename() {
        return this.slipsFilename;
    }

    public String getSecurityFilename() {
        return this.securityFilename;
    }

    public String getSessionLogFilename() {
        return this.sessionLogFilename;
    }

    void initByDefault() {
        System.out.println("Startup...");
        this.projectsFilename = "projects.dat";
        this.slipsFilename = "slips.dat";
        this.securityFilename = "security.dat";
        this.sessionLogFilename = "sessionlog.dat";
    }
}

