/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.frame.Singleton;

public class SystemUtil {
    private static int[] specialValues = new int[]{0, 1, 2, 3};
    private static String[] specialLabels = new String[]{"Normal", "Capital", "Depreciation", "GroupTransaction"};
    private static int[] groupValues = new int[]{0, 1, 2, 3, 4};
    private static String[] groupLabels = new String[]{"Assets", "Debt", "Capital", "Profit", "Expense"};
    protected static MessageMonitor monitor = new MessageMonitor("errorlogs.txt", 4, System.err);
    static ResourceBundle resources;
    static boolean loadFailed;

    public static int getYear() {
        return SystemUtil.getCalendar().get(1);
    }

    public static int getMonth() {
        return SystemUtil.getCalendar().get(2) + 1;
    }

    public static int getDay() {
        return SystemUtil.getCalendar().get(5);
    }

    private static Calendar getCalendar() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int[] getSpecialValues() {
        return specialValues;
    }

    public static String[] getSpecialLabels() {
        return specialLabels;
    }

    public static String[] getBalanceGroupLabels() {
        return groupLabels;
    }

    public static int[] getBalanceGroupValues() {
        return groupValues;
    }

    public static FocusListener getIMEvent() {
        try {
            return (FocusListener)Singleton.instance(SystemUtil.getResourceString("FocusIMEvent"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void logMessage(String string) {
        monitor.error(string);
    }

    protected static void loadResources() {
        String string = null;
        Locale locale = Locale.getDefault();
        if (string != null) {
            String string2 = string;
            String string3 = "";
            String string4 = "";
            int n = string2.indexOf("_");
            if (n > -1) {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                string4 = string2;
                string3 = "";
            }
            locale = new Locale(string4, string3);
            System.out.println("locale set to " + locale);
        } else {
            System.out.println("default locale [" + locale.toString() + "] was set.");
        }
        try {
            resources = ResourceBundle.getBundle("arg.money.message", locale);
            System.out.println(SystemUtil.getResourceString("WelcomeMessage"));
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("[message.properties] not found");
            loadFailed = true;
        }
    }

    public static String getResourceString(String string) {
        if (resources == null && !loadFailed) {
            SystemUtil.loadResources();
        }
        try {
            return resources.getString(string);
        }
        catch (Exception exception) {
            System.err.println("no string :" + string);
            return string;
        }
    }

    static {
        loadFailed = false;
    }
}

