/*
 * Decompiled with CFR 0.152.
 */
package arg.money;

import arg.money.ASlipLine;
import arg.money.NumberIdentical;
import arg.money.ReservableObject;
import arg.money.SlipElement;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class TransferSlip
implements NumberIdentical,
ReservableObject {
    int tid;
    int year;
    Date date;
    Date lastmodified = new Date();
    int receiptNumber;
    int pid;
    int uid;
    List lines;
    boolean lock = false;

    public TransferSlip() {
        this(null);
    }

    public TransferSlip(List list) {
        this.setLines(list);
    }

    public TransferSlip(int n, int n2, int n3, int n4, int n5, List list) {
        this(list);
        this.tid = n;
        this.setYear(n2);
        this.setDate(new Date());
        this.setReceiptNumber(n3);
        this.setPid(n4);
        this.setUid(n5);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("----------------");
        stringBuffer.append("TSlip # " + StringUtil.datej(this.date)).append("\n");
        int n = 0;
        while (n < this.lines.size()) {
            ASlipLine aSlipLine = (ASlipLine)this.lines.get(n);
            stringBuffer.append(aSlipLine.toString()).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public TransferSlip getCopy() {
        TransferSlip transferSlip = new TransferSlip();
        this.copyTo(transferSlip);
        return transferSlip;
    }

    public void copyTo(TransferSlip transferSlip) {
        transferSlip.tid = this.tid;
        transferSlip.year = this.year;
        transferSlip.date = new Date(this.date.getTime());
        transferSlip.receiptNumber = this.receiptNumber;
        transferSlip.pid = this.pid;
        transferSlip.uid = this.uid;
        if (transferSlip.getLines() != null) {
            transferSlip.getLines().clear();
        } else {
            transferSlip.setLines(null);
        }
        Iterator iterator = this.getLines().iterator();
        while (iterator.hasNext()) {
            ASlipLine aSlipLine = (ASlipLine)iterator.next();
            SlipElement slipElement = aSlipLine.existLeft() ? aSlipLine.getLeft().getCopy() : null;
            SlipElement slipElement2 = aSlipLine.existRight() ? aSlipLine.getRight().getCopy() : null;
            transferSlip.addLine(aSlipLine.getSummary(), slipElement, slipElement2);
        }
    }

    public int getId() {
        return this.tid;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public int getYear() {
        return this.year;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setLastmodified(Date date) {
        this.lastmodified = date;
    }

    public Date getLastmodified() {
        return this.lastmodified;
    }

    public void modify() {
        this.lastmodified.setTime(System.currentTimeMillis());
    }

    public void setReceiptNumber(int n) {
        this.receiptNumber = n;
    }

    public int getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setPid(int n) {
        this.pid = n;
    }

    public int getPid() {
        return this.pid;
    }

    public void setUid(int n) {
        this.uid = n;
    }

    public int getUid() {
        return this.uid;
    }

    public void setLines(List list) {
        this.lines = list == null ? new LinkedList() : list;
        if (this.lines.size() == 0) {
            this.addLine("", new SlipElement(-1, 0L), new SlipElement(-1, 0L));
        }
    }

    public List getLines() {
        return this.lines;
    }

    public boolean existsSlipLineByLeftSubject(int n) {
        int n2 = 0;
        while (n2 < this.lines.size()) {
            ASlipLine aSlipLine = (ASlipLine)this.lines.get(n2);
            if (aSlipLine.getLeft().getId() == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Iterator getSlipLineByLeftSubject(int n) {
        LinkedList<ASlipLine> linkedList = new LinkedList<ASlipLine>();
        int n2 = 0;
        while (n2 < this.lines.size()) {
            ASlipLine aSlipLine = (ASlipLine)this.lines.get(n2);
            if (aSlipLine.getLeft().getId() == n) {
                linkedList.add(aSlipLine);
            }
            ++n2;
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList.iterator();
    }

    public boolean existsSlipLineByRightSubject(int n) {
        int n2 = 0;
        while (n2 < this.lines.size()) {
            ASlipLine aSlipLine = (ASlipLine)this.lines.get(n2);
            if (aSlipLine.getRight().getId() == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Iterator getSlipLineByRightSubject(int n) {
        LinkedList<ASlipLine> linkedList = new LinkedList<ASlipLine>();
        int n2 = 0;
        while (n2 < this.lines.size()) {
            ASlipLine aSlipLine = (ASlipLine)this.lines.get(n2);
            if (aSlipLine.getRight().getId() == n) {
                linkedList.add(aSlipLine);
            }
            ++n2;
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList.iterator();
    }

    public ASlipLine getASlipLine(int n) {
        return (ASlipLine)this.lines.get(n);
    }

    public ASlipLine addLine(String string, SlipElement slipElement, SlipElement slipElement2) {
        ASlipLine aSlipLine = null;
        if (this.lines.size() != 0) {
            aSlipLine = (ASlipLine)this.lines.get(this.lines.size() - 1);
        }
        ASlipLine aSlipLine2 = new ASlipLine(this, aSlipLine, string, slipElement, slipElement2);
        this.lines.add(aSlipLine2);
        return aSlipLine2;
    }

    public void removeLine(ASlipLine aSlipLine) {
        if (aSlipLine.getForward() == null) {
            return;
        }
        this.lines.remove(aSlipLine);
        Object[] objectArray = this.lines.toArray();
        this.lines.clear();
        int n = 0;
        while (n < objectArray.length) {
            ASlipLine aSlipLine2 = (ASlipLine)objectArray[n];
            if (aSlipLine2 != null) {
                SlipElement slipElement = aSlipLine2.existLeft() ? aSlipLine2.getLeft() : null;
                SlipElement slipElement2 = aSlipLine2.existRight() ? aSlipLine2.getRight() : null;
                ASlipLine aSlipLine3 = this.addLine(aSlipLine2.getSummary(), slipElement, slipElement2);
                if (aSlipLine3.getForward() == null) {
                    if (!aSlipLine3.existLeft()) {
                        aSlipLine3.setLeft(new SlipElement(-1, 0L));
                    }
                    if (!aSlipLine3.existRight()) {
                        aSlipLine3.setRight(new SlipElement(-1, 0L));
                    }
                }
            }
            ++n;
        }
        if (this.lines.size() == 0) {
            this.setLines(null);
        }
    }

    public void load(List list) {
        try {
            if (list.size() >= 7) {
                Iterator iterator = list.iterator();
                this.tid = (Integer)iterator.next();
                this.setYear((Integer)iterator.next());
                this.setDate((Date)iterator.next());
                this.setReceiptNumber((Integer)iterator.next());
                this.setPid((Integer)iterator.next());
                this.setUid((Integer)iterator.next());
                this.lines = (List)iterator.next();
                int n = 0;
                while (n < this.lines.size()) {
                    ASlipLine aSlipLine = (ASlipLine)this.lines.get(n);
                    aSlipLine.setParent(this);
                    ++n;
                }
                if (iterator.hasNext()) {
                    this.setLastmodified((Date)iterator.next());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List save() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new Integer(this.getId()));
        linkedList.add(new Integer(this.getYear()));
        linkedList.add(this.getDate());
        linkedList.add(new Integer(this.getReceiptNumber()));
        linkedList.add(new Integer(this.getPid()));
        linkedList.add(new Integer(this.getUid()));
        linkedList.add(this.lines);
        linkedList.add(this.getLastmodified());
        return linkedList;
    }

    public synchronized boolean lock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public synchronized void unlock() {
        this.lock = false;
    }
}

