/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.GroupData;
import arg.money.NumberIdentical;
import arg.money.ProjectData;
import arg.money.SecurityManager;
import arg.money.SystemUtil;
import arg.money.UserData;
import arg.money.UserManager;
import arg.money.gui.BooleanCellRenderer;
import arg.money.gui.DGeneralList;
import arg.money.gui.SubjectsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class DGroupEditor
extends JDialog {
    protected boolean ok;
    protected GroupData group;
    protected SecurityManager manager;
    Frame ownerFrame;
    UserData[] uarray;
    AccessModel accessModel;
    private JPanel jPanel6;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel centerPanel;
    private JPanel groupNamePanel;
    private JTextField groupNameText;
    private JPanel groupMemberPanel;
    private JTextField groupCommentText;
    private JTabbedPane propPage;
    private JPanel memberPage;
    private JPanel jPanel9;
    private JScrollPane jScrollPane4;
    private JList memberList;
    private JPanel jPanel8;
    private JButton addMemberButton;
    private JButton delMemberButton;
    private JPanel accessPage;
    private JScrollPane jScrollPane1;
    private JTable accessTable;
    private JLabel jLabel1;

    public DGroupEditor(Frame frame, GroupData groupData, SecurityManager securityManager) {
        this(frame, true);
        this.ownerFrame = frame;
        this.group = groupData;
        this.manager = securityManager;
        this.propPage.setTitleAt(0, SystemUtil.getResourceString("Member"));
        this.propPage.setTitleAt(1, SystemUtil.getResourceString("Access"));
        this.updateMemberList();
        this.updateProjectList();
        this.groupNameText.addFocusListener(SystemUtil.getIMEvent());
        this.groupCommentText.addFocusListener(SystemUtil.getIMEvent());
        this.groupNameText.setText(groupData.getName());
        this.groupCommentText.setText(groupData.getComment());
        this.pack();
        SubjectsUtil.setCenter(this);
    }

    public DGroupEditor(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.centerPanel = new JPanel();
        this.groupNamePanel = new JPanel();
        this.groupNameText = new JTextField();
        this.groupMemberPanel = new JPanel();
        this.groupCommentText = new JTextField();
        this.propPage = new JTabbedPane();
        this.memberPage = new JPanel();
        this.jPanel9 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.memberList = new JList();
        this.jPanel8 = new JPanel();
        this.addMemberButton = new JButton();
        this.delMemberButton = new JButton();
        this.accessPage = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.accessTable = new JTable();
        this.jLabel1 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DGroupEditor.this.closeDialog(windowEvent);
            }
        });
        this.okButton.setText(SystemUtil.getResourceString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGroupEditor.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.okButton);
        this.cancelButton.setText(SystemUtil.getResourceString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGroupEditor.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel6, "South");
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.groupNamePanel.setBorder(new TitledBorder("Group Name"));
        SubjectsUtil.borderTitle(this.groupNamePanel, SystemUtil.getResourceString("GroupName"));
        this.groupNameText.setColumns(20);
        this.groupNameText.setText("jTextField5");
        this.groupNamePanel.add(this.groupNameText);
        this.centerPanel.add(this.groupNamePanel);
        this.groupMemberPanel.setBorder(new TitledBorder("Comment"));
        SubjectsUtil.borderTitle(this.groupMemberPanel, SystemUtil.getResourceString("GroupComment"));
        this.groupCommentText.setColumns(30);
        this.groupCommentText.setText("jTextField6");
        this.groupMemberPanel.add(this.groupCommentText);
        this.centerPanel.add(this.groupMemberPanel);
        this.memberPage.setLayout(new BoxLayout(this.memberPage, 0));
        this.memberPage.setBorder(new TitledBorder(new EtchedBorder(), "Member"));
        SubjectsUtil.borderTitle(this.memberPage, SystemUtil.getResourceString("Member"));
        this.jPanel9.setLayout(new BoxLayout(this.jPanel9, 0));
        this.jScrollPane4.setViewportView(this.memberList);
        this.jPanel9.add(this.jScrollPane4);
        this.memberPage.add(this.jPanel9);
        this.jPanel8.setLayout(new BoxLayout(this.jPanel8, 1));
        this.addMemberButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Import24.gif")));
        this.addMemberButton.setText(SystemUtil.getResourceString("AddMember"));
        this.addMemberButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGroupEditor.this.addMemberButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel8.add(this.addMemberButton);
        this.delMemberButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Export24.gif")));
        this.delMemberButton.setForeground(Color.red);
        this.delMemberButton.setText(SystemUtil.getResourceString("RemoveMember"));
        this.delMemberButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGroupEditor.this.delMemberButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel8.add(this.delMemberButton);
        this.memberPage.add(this.jPanel8);
        this.propPage.addTab("jPanel7", this.memberPage);
        this.accessPage.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.accessTable);
        this.accessPage.add((Component)this.jScrollPane1, "Center");
        this.propPage.addTab("jPanel2", this.accessPage);
        this.centerPanel.add(this.propPage);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.jLabel1.setText(SystemUtil.getResourceString("GroupManager"));
        this.jLabel1.setFont(new Font("Serif", 0, 36));
        this.getContentPane().add((Component)this.jLabel1, "North");
    }

    private void delMemberButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.memberList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.group.removeUser(this.uarray[n].getId());
        this.updateMemberList();
    }

    private void addMemberButtonActionPerformed(ActionEvent actionEvent) {
        List list = this.manager.getUserManager().getUsers();
        DGeneralList dGeneralList = new DGeneralList(this.ownerFrame, "", list);
        dGeneralList.show();
        int n = dGeneralList.getIndex();
        if (n == -1) {
            return;
        }
        UserData userData = (UserData)list.get(n);
        this.group.addUser(userData.getId());
        this.updateMemberList();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.onOk();
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new DGroupEditor((Frame)new JFrame(), true).show();
    }

    void updateMemberList() {
        List list = this.group.getUsers();
        UserManager userManager = this.manager.getUserManager();
        this.uarray = new UserData[list.size()];
        if (list.size() != 0) {
            int n = 0;
            while (n < list.size()) {
                NumberIdentical numberIdentical = (NumberIdentical)list.get(n);
                this.uarray[n] = userManager.getUser(numberIdentical.getId());
                ++n;
            }
        }
        this.memberList.setListData(this.uarray);
    }

    void updateProjectList() {
        List list = this.manager.getParent().getProjectManager().getProjects();
        this.accessModel = new AccessModel(list);
        this.accessTable.setDefaultEditor(Boolean.TYPE, new DefaultCellEditor(new JCheckBox()));
        this.accessTable.setDefaultRenderer(Boolean.TYPE, new BooleanCellRenderer());
        this.accessTable.setModel(this.accessModel);
    }

    public boolean isOk() {
        return this.ok;
    }

    void onOk() {
        String string = this.groupNameText.getText();
        if (string.length() == 0) {
            String string2 = SystemUtil.getResourceString("InputGroupName");
            JOptionPane.showMessageDialog(this, string2);
            return;
        }
        this.group.setName(string);
        this.group.setComment(this.groupCommentText.getText());
        this.accessModel.confirm();
        List list = this.group.getUsers();
        list.clear();
        if (this.uarray.length != 0) {
            int n = 0;
            while (n < this.uarray.length) {
                this.group.addUser(this.uarray[n].getId());
                ++n;
            }
        }
        this.ok = true;
        this.dispose();
    }

    class AccessModel
    extends AbstractTableModel {
        List projects;
        final String[] titles = new String[]{SystemUtil.getResourceString("Project"), SystemUtil.getResourceString("GroupComment"), SystemUtil.getResourceString("Readable"), SystemUtil.getResourceString("Writable"), SystemUtil.getResourceString("EditSubject"), SystemUtil.getResourceString("SettleAccount")};
        boolean[][] accesses;

        AccessModel(List list) {
            this.projects = list;
            this.accesses = new boolean[list.size()][GroupData.masks.length];
            if (list.size() != 0) {
                int n = 0;
                while (n < list.size()) {
                    ProjectData projectData = (ProjectData)this.projects.get(n);
                    int n2 = 0;
                    while (n2 < GroupData.masks.length) {
                        this.accesses[n][n2] = DGroupEditor.this.group.isPermitted(projectData.getId(), GroupData.masks[n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
        }

        public int getColumnCount() {
            return this.titles.length;
        }

        public Class getColumnClass(int n) {
            if (n >= 2 && n <= 5) {
                return Boolean.TYPE;
            }
            return super.getColumnClass(n);
        }

        public int getRowCount() {
            return this.projects.size();
        }

        public String getColumnName(int n) {
            return this.titles[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 >= 2 && n2 <= 5;
        }

        public Object getValueAt(int n, int n2) {
            ProjectData projectData = (ProjectData)this.projects.get(n);
            switch (n2) {
                case 0: {
                    return projectData.getName();
                }
                case 1: {
                    return projectData.getComment();
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return new Boolean(this.accesses[n][n2 - 2]);
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            Boolean bl;
            if (object instanceof String) {
                bl = new Boolean((String)object);
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.accesses[n][n2 - 2] = bl;
                        return;
                    }
                }
            }
            if (object instanceof Boolean) {
                bl = (Boolean)object;
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.accesses[n][n2 - 2] = bl;
                        return;
                    }
                }
            }
        }

        public void confirm() {
            if (this.projects.size() != 0) {
                int n = 0;
                while (n < this.projects.size()) {
                    ProjectData projectData = (ProjectData)this.projects.get(n);
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < GroupData.masks.length) {
                        if (this.accesses[n][n3]) {
                            n2 += GroupData.masks[n3];
                        }
                        ++n3;
                    }
                    DGroupEditor.this.group.setProject(projectData.getId(), n2);
                    ++n;
                }
            }
        }
    }
}

