/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.DataLockingException;
import arg.money.ProjectManager;
import arg.money.SessionData;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.UserData;
import arg.money.UserShell;
import arg.money.gui.DProjectManager;
import arg.money.gui.DSecurityManager;
import arg.money.gui.DUserEditor;
import arg.money.gui.FReport;
import arg.money.gui.FSlipExplorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.frame.Document;

public class DMenu
extends JFrame
implements UserShell {
    SessionData session;
    SystemInfo systemInfo;
    Document document = new Document();
    JLabel nameLabel;
    JLabel commentLabel;
    JPopupMenu specialPopupMenu;

    public DMenu(SessionData sessionData) {
        super(SystemUtil.getResourceString("MenuTitle"));
        this.session = sessionData;
        this.systemInfo = sessionData.getParent().getParent();
        this.initGui();
    }

    void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 1));
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 1);
        jPanel2.setLayout(boxLayout);
        this.nameLabel = new JLabel(this.session.getUser().getName());
        this.nameLabel.setFont(new Font("SansSerif", 0, 28));
        this.nameLabel.setForeground(Color.black);
        jPanel2.add(this.nameLabel);
        this.commentLabel = new JLabel(this.session.getUser().getComment());
        this.commentLabel.setFont(new Font("Serif", 0, 12));
        this.commentLabel.setForeground(Color.yellow);
        jPanel2.add(this.commentLabel);
        jPanel2.setBorder(new TitledBorder(SystemUtil.getResourceString("User")));
        this.getContentPane().add((Component)jPanel2, "North");
        JButton jButton = new JButton(SystemUtil.getResourceString("ExplorerButton"));
        jButton.setHorizontalAlignment(2);
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/development/Applet24.gif")));
        jPanel.add(jButton);
        JButton jButton2 = new JButton(SystemUtil.getResourceString("ReportButton"));
        jButton2.setHorizontalAlignment(2);
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/History24.gif")));
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(SystemUtil.getResourceString("ProjectButton"));
        jButton3.setHorizontalAlignment(2);
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy24.gif")));
        jPanel.add(jButton3);
        JButton jButton4 = new JButton(SystemUtil.getResourceString("SecurityButton"));
        jButton4.setHorizontalAlignment(2);
        jButton4.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Home24.gif")));
        jPanel.add(jButton4);
        final JButton jButton5 = new JButton(SystemUtil.getResourceString("SpecialButton"));
        jButton5.setHorizontalAlignment(2);
        jButton5.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Export24.gif")));
        jPanel.add(jButton5);
        JButton jButton6 = new JButton(SystemUtil.getResourceString("UserDataButton"));
        jButton6.setHorizontalAlignment(2);
        jButton6.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Information24.gif")));
        jPanel.add(jButton6);
        JButton jButton7 = new JButton(SystemUtil.getResourceString("Exit"));
        jButton7.setHorizontalAlignment(2);
        jButton7.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
        jPanel.add(jButton7);
        JLabel jLabel = new JLabel(SystemUtil.getResourceString("Copyright"));
        this.getContentPane().add((Component)jLabel, "South");
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMenu.this.editUserData();
                UserData userData = DMenu.this.session.getUser();
                DMenu.this.nameLabel.setText(userData.getName());
                DMenu.this.commentLabel.setText(userData.getComment());
                DMenu.this.pack();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMenu.this.onExplorer();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMenu.this.onReport();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager dProjectManager = new DProjectManager((Frame)DMenu.this, DMenu.this.session, DMenu.this.systemInfo.getProjectManager());
                dProjectManager.show();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager dSecurityManager = new DSecurityManager((Frame)DMenu.this, DMenu.this.systemInfo.getSecurityManager());
                dSecurityManager.show();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dimension dimension = jButton5.getSize();
                DMenu.this.specialPopupMenu.show(jButton5, (int)(dimension.getWidth() / 2.0), (int)(dimension.getHeight() / 2.0));
            }
        });
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMenu.this.session.terminate();
                DMenu.this.onExit();
            }
        });
        this.makePopupMenu();
        boolean bl = this.systemInfo.getSecurityManager().getAdminPermission(this.session);
        if (!bl) {
            jButton4.setEnabled(false);
        }
        if (!bl) {
            jButton5.setEnabled(false);
        }
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    public void show() {
        super.show();
    }

    public void update(int n) {
        this.document.updateViews(new Integer(n));
    }

    public void close() {
        this.document.updateViews(null);
        this.dispose();
    }

    void editUserData() {
        DUserEditor dUserEditor = new DUserEditor((Frame)this, this.session.getUser());
        dUserEditor.show();
    }

    void onExit() {
        this.close();
        this.session.terminate();
    }

    void onExplorer() {
        FSlipExplorer fSlipExplorer = new FSlipExplorer(this.systemInfo.getSlipManager(), this.session, this.document);
        fSlipExplorer.show();
    }

    void onReport() {
        FReport fReport = new FReport(this.systemInfo.getSlipManager(), this.session, this.document);
        fReport.show();
    }

    void onExport() {
    }

    void onNextYear() {
        try {
            ProjectManager projectManager = this.systemInfo.getProjectManager();
            projectManager.makeNextYear(this.systemInfo.getSlipManager());
        }
        catch (DataLockingException dataLockingException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("ProjectLockError"));
            return;
        }
    }

    void makePopupMenu() {
        this.specialPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SystemUtil.getResourceString("SpecialNextYear"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMenu.this.onNextYear();
            }
        });
        this.specialPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(SystemUtil.getResourceString("SpecialExport"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMenu.this.onExport();
            }
        });
        this.specialPopupMenu.add(jMenuItem);
    }
}

