/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.AnnualData;
import arg.money.NameCommentObject;
import arg.money.ProjectData;
import arg.money.ProjectMaker;
import arg.money.RemovalException;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectMoney;
import arg.money.SubjectSubgroup;
import arg.money.SystemUtil;
import arg.money.gui.DSubject;
import arg.money.gui.DSubjectGroup;
import arg.money.gui.SubjectsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.swing.DateComponent;
import jp.gr.java_conf.ccs2.comp.swing.DirectIMFocusListener;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class DProjectEditor
extends JDialog {
    Frame ownerFrame;
    ProjectData project;
    SlipManager manager;
    SubjectsUtil utils;
    boolean okFlag = false;
    DateComponent startedDate;
    DateComponent closedDate;
    SubjectMoney lastMoney;
    NumberFormat form = NumberFormat.getInstance();
    private JPanel jPanel2;
    private JLabel titleLabel;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel13;
    private JLabel jLabel1;
    private JTextField projectNameText;
    private JPanel jPanel14;
    private JLabel jLabel2;
    private JTextField commentText;
    private JPanel annualDataPanel;
    private JLabel yearLabel;
    private JComboBox yearComboBox;
    private JPanel jPanel6;
    private JPanel groupPanel;
    private JScrollPane jScrollPane1;
    private JList groupList;
    private JPanel jPanel5;
    private JButton groupAddButton;
    private JButton groupModButton;
    private JButton groupDelButton;
    private JPanel subgroupPanel;
    private JScrollPane jScrollPane2;
    private JList subgroupList;
    private JPanel jPanel10;
    private JButton subAddButton;
    private JButton subModButton;
    private JButton subDelButton;
    private JPanel subjectPanel;
    private JScrollPane jScrollPane3;
    private JList subjectList;
    private JPanel jPanel11;
    private JButton subjectAddButton;
    private JButton subjectModButton;
    private JButton subjectDelButton;
    private JPanel annualPanel;
    private JPanel jPanel15;
    private JLabel groupNameLabel;
    private JLabel groupCommentLabel;
    private JPanel jPanel16;
    private JLabel subgroupNameLabel;
    private JLabel subgroupCommentLabel;
    private JPanel jPanel17;
    private JLabel subjectNameLabel;
    private JLabel subjectCommentLabel;
    private JPanel jPanel18;
    private JLabel moneyLabel;
    private JTextField moneyText;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;

    public DProjectEditor(Frame frame, ProjectData projectData, SlipManager slipManager) {
        this(frame, true);
        this.ownerFrame = frame;
        this.project = projectData;
        this.manager = slipManager;
        this.okFlag = false;
        this.projectNameText.addFocusListener(SystemUtil.getIMEvent());
        this.commentText.addFocusListener(SystemUtil.getIMEvent());
        this.moneyText.addFocusListener(new DirectIMFocusListener());
        this.startedDate = new DateComponent();
        this.startedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("StartedDate")));
        this.annualDataPanel.add(this.startedDate);
        this.closedDate = new DateComponent();
        this.closedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("ClosedDate")));
        this.annualDataPanel.add(this.closedDate);
        List list = this.project.getAnnuals();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AnnualData annualData = (AnnualData)iterator.next();
            this.yearComboBox.addItem(new Integer(annualData.getId()));
        }
        this.projectNameText.setText(this.project.getName());
        this.commentText.setText(this.project.getComment());
        this.utils = new SubjectsUtil(this.project, this.groupList, this.subgroupList, this.subjectList, new MessageListener(){

            public void message(String string, int n, Object object) {
                DProjectEditor.this.updateMoney();
            }
        });
        this.updateYear();
        this.pack();
        SubjectsUtil.setCenter(this);
    }

    void updateYear() {
        try {
            Integer n = (Integer)this.yearComboBox.getSelectedItem();
            AnnualData annualData = this.project.getAnnual(n);
            Date date = annualData.getStartedDate();
            this.startedDate.setDate(date);
            date = annualData.getClosedDate();
            this.closedDate.setDate(date);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.updateMoney();
    }

    void updateMoney() {
        NameCommentObject nameCommentObject;
        this.setMoney();
        String string = "";
        String string2 = "";
        string = SystemUtil.getResourceString("non");
        string2 = "";
        try {
            nameCommentObject = this.utils.getSelectedGroup();
            if (nameCommentObject != null) {
                string = ((SubjectGroup)nameCommentObject).getName();
                string2 = ((SubjectGroup)nameCommentObject).getComment();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.groupNameLabel.setText(string);
        this.groupCommentLabel.setText(string2);
        string = SystemUtil.getResourceString("non");
        string2 = "";
        try {
            nameCommentObject = this.utils.getSelectedSubgroup();
            if (nameCommentObject != null) {
                string = ((SubjectSubgroup)nameCommentObject).getName();
                string2 = ((SubjectSubgroup)nameCommentObject).getComment();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.subgroupNameLabel.setText(string);
        this.subgroupCommentLabel.setText(string2);
        string = SystemUtil.getResourceString("non");
        string2 = "";
        nameCommentObject = null;
        try {
            nameCommentObject = this.utils.getSelectedSubject();
            if (nameCommentObject != null) {
                string = ((Subject)nameCommentObject).getName();
                string2 = ((Subject)nameCommentObject).getComment();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.subjectNameLabel.setText(string);
        this.subjectCommentLabel.setText(string2);
        try {
            if (nameCommentObject != null) {
                Integer n = (Integer)this.yearComboBox.getSelectedItem();
                AnnualData annualData = this.project.getAnnual(n);
                SubjectMoney subjectMoney = annualData.getInitialMoney(((Subject)nameCommentObject).getId());
                this.moneyText.setText(this.form.format(subjectMoney.getMoney()));
                this.lastMoney = subjectMoney;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("RTException at updateMoney4 in DProjectEditor.");
            runtimeException.printStackTrace();
        }
    }

    void setMoney() {
        if (this.lastMoney != null) {
            try {
                long l = this.form.parse(StringUtil.transform(this.moneyText.getText())).longValue();
                this.lastMoney.setMoney(l);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    void setDate() {
        Integer n = (Integer)this.yearComboBox.getSelectedItem();
        AnnualData annualData = this.project.getAnnual(n);
        Date date = this.startedDate.getDate();
        if (date != null) {
            annualData.setStartedDate(date);
        }
        if ((date = this.closedDate.getDate()) != null) {
            annualData.setClosedDate(date);
        }
    }

    void onOk() {
        this.setMoney();
        this.setDate();
        this.project.setName(this.projectNameText.getText());
        this.project.setComment(this.commentText.getText());
        this.okFlag = true;
        this.dispose();
    }

    void onCancel() {
        this.okFlag = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.okFlag;
    }

    public DProjectEditor(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jLabel1 = new JLabel();
        this.projectNameText = new JTextField();
        this.jPanel14 = new JPanel();
        this.jLabel2 = new JLabel();
        this.commentText = new JTextField();
        this.annualDataPanel = new JPanel();
        this.yearLabel = new JLabel();
        this.yearComboBox = new JComboBox();
        this.jPanel6 = new JPanel();
        this.groupPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.groupList = new JList();
        this.jPanel5 = new JPanel();
        this.groupAddButton = new JButton();
        this.groupModButton = new JButton();
        this.groupDelButton = new JButton();
        this.subgroupPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.subgroupList = new JList();
        this.jPanel10 = new JPanel();
        this.subAddButton = new JButton();
        this.subModButton = new JButton();
        this.subDelButton = new JButton();
        this.subjectPanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.subjectList = new JList();
        this.jPanel11 = new JPanel();
        this.subjectAddButton = new JButton();
        this.subjectModButton = new JButton();
        this.subjectDelButton = new JButton();
        this.annualPanel = new JPanel();
        this.jPanel15 = new JPanel();
        this.groupNameLabel = new JLabel();
        this.groupCommentLabel = new JLabel();
        this.jPanel16 = new JPanel();
        this.subgroupNameLabel = new JLabel();
        this.subgroupCommentLabel = new JLabel();
        this.jPanel17 = new JPanel();
        this.subjectNameLabel = new JLabel();
        this.subjectCommentLabel = new JLabel();
        this.jPanel18 = new JPanel();
        this.moneyLabel = new JLabel();
        this.moneyText = new JTextField();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DProjectEditor.this.closeDialog(windowEvent);
            }
        });
        this.jPanel2.setLayout(new BorderLayout());
        this.titleLabel.setText(SystemUtil.getResourceString("ProjectEditor"));
        this.titleLabel.setFont(new Font("Serif", 0, 36));
        this.jPanel2.add((Component)this.titleLabel, "North");
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jPanel4.setBorder(new EtchedBorder());
        this.jPanel13.setLayout(new FlowLayout(0, 15, 5));
        this.jLabel1.setText(SystemUtil.getResourceString("ProjectName") + " : ");
        this.jPanel13.add(this.jLabel1);
        this.projectNameText.setColumns(20);
        this.jPanel13.add(this.projectNameText);
        this.jPanel4.add(this.jPanel13);
        this.jPanel14.setLayout(new FlowLayout(0, 15, 5));
        this.jLabel2.setText(SystemUtil.getResourceString("ProjectComment") + " : ");
        this.jPanel14.add(this.jLabel2);
        this.commentText.setColumns(30);
        this.jPanel14.add(this.commentText);
        this.jPanel4.add(this.jPanel14);
        this.yearLabel.setText(SystemUtil.getResourceString("CurrentYear"));
        this.annualDataPanel.add(this.yearLabel);
        this.yearComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DProjectEditor.this.yearComboBoxItemStateChanged(itemEvent);
            }
        });
        this.annualDataPanel.add(this.yearComboBox);
        this.jPanel4.add(this.annualDataPanel);
        this.jPanel3.add(this.jPanel4);
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.getContentPane().add(this.jPanel2);
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 0));
        this.groupPanel.setLayout(new BorderLayout());
        this.groupPanel.setBorder(new TitledBorder("Group"));
        SubjectsUtil.borderTitle(this.groupPanel, SystemUtil.getResourceString("Group"));
        this.groupList.setFixedCellWidth(140);
        this.groupList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DProjectEditor.this.groupListKeyPressed(keyEvent);
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DProjectEditor.this.groupListValueChanged(listSelectionEvent);
            }
        });
        this.groupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DProjectEditor.this.groupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.groupList);
        this.groupPanel.add((Component)this.jScrollPane1, "Center");
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 0));
        this.groupAddButton.setText(SystemUtil.getResourceString("Add"));
        this.groupAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.groupAddButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel5.add(this.groupAddButton);
        this.groupModButton.setText(SystemUtil.getResourceString("Mod"));
        this.groupModButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.groupModButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel5.add(this.groupModButton);
        this.groupDelButton.setForeground(Color.red);
        this.groupDelButton.setText(SystemUtil.getResourceString("Del"));
        this.groupDelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.groupDelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel5.add(this.groupDelButton);
        this.groupPanel.add((Component)this.jPanel5, "South");
        this.jPanel6.add(this.groupPanel);
        this.subgroupPanel.setLayout(new BorderLayout());
        this.subgroupPanel.setBorder(new TitledBorder("Subgroup"));
        SubjectsUtil.borderTitle(this.subgroupPanel, SystemUtil.getResourceString("Subgroup"));
        this.subgroupList.setFixedCellWidth(140);
        this.subgroupList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DProjectEditor.this.subgroupListKeyPressed(keyEvent);
            }
        });
        this.subgroupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DProjectEditor.this.subgroupListValueChanged(listSelectionEvent);
            }
        });
        this.subgroupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DProjectEditor.this.subgroupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.subgroupList);
        this.subgroupPanel.add((Component)this.jScrollPane2, "Center");
        this.jPanel10.setLayout(new BoxLayout(this.jPanel10, 0));
        this.subAddButton.setText(SystemUtil.getResourceString("Add"));
        this.subAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.subAddButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel10.add(this.subAddButton);
        this.subModButton.setText(SystemUtil.getResourceString("Mod"));
        this.subModButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.subModButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel10.add(this.subModButton);
        this.subDelButton.setForeground(Color.red);
        this.subDelButton.setText(SystemUtil.getResourceString("Del"));
        this.subDelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.subDelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel10.add(this.subDelButton);
        this.subgroupPanel.add((Component)this.jPanel10, "South");
        this.jPanel6.add(this.subgroupPanel);
        this.subjectPanel.setLayout(new BorderLayout());
        this.subjectPanel.setBorder(new TitledBorder("Subject"));
        SubjectsUtil.borderTitle(this.subjectPanel, SystemUtil.getResourceString("Subject"));
        this.subjectList.setFixedCellWidth(140);
        this.subjectList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DProjectEditor.this.subjectListKeyPressed(keyEvent);
            }
        });
        this.subjectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DProjectEditor.this.subjectListValueChanged(listSelectionEvent);
            }
        });
        this.subjectList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DProjectEditor.this.subjectListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane3.setViewportView(this.subjectList);
        this.subjectPanel.add((Component)this.jScrollPane3, "Center");
        this.jPanel11.setLayout(new BoxLayout(this.jPanel11, 0));
        this.subjectAddButton.setText(SystemUtil.getResourceString("Add"));
        this.subjectAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.subjectAddButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.subjectAddButton);
        this.subjectModButton.setText(SystemUtil.getResourceString("Mod"));
        this.subjectModButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.subjectModButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.subjectModButton);
        this.subjectDelButton.setForeground(Color.red);
        this.subjectDelButton.setText(SystemUtil.getResourceString("Del"));
        this.subjectDelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.subjectDelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.subjectDelButton);
        this.subjectPanel.add((Component)this.jPanel11, "South");
        this.jPanel6.add(this.subjectPanel);
        this.getContentPane().add(this.jPanel6);
        this.annualPanel.setLayout(new BoxLayout(this.annualPanel, 1));
        this.annualPanel.setBorder(new TitledBorder("Annual Money"));
        SubjectsUtil.borderTitle(this.annualPanel, SystemUtil.getResourceString("AnnualAmount"));
        this.jPanel15.setLayout(new FlowLayout(0, 15, 5));
        this.jPanel15.setAlignmentX(0.1f);
        this.groupNameLabel.setForeground(Color.black);
        this.jPanel15.add(this.groupNameLabel);
        this.groupCommentLabel.setForeground(Color.white);
        this.jPanel15.add(this.groupCommentLabel);
        this.annualPanel.add(this.jPanel15);
        this.jPanel16.setLayout(new FlowLayout(0, 15, 5));
        this.jPanel16.setAlignmentX(0.1f);
        this.subgroupNameLabel.setForeground(Color.black);
        this.jPanel16.add(this.subgroupNameLabel);
        this.subgroupCommentLabel.setForeground(Color.white);
        this.jPanel16.add(this.subgroupCommentLabel);
        this.annualPanel.add(this.jPanel16);
        this.jPanel17.setLayout(new FlowLayout(0, 15, 5));
        this.jPanel17.setAlignmentX(0.1f);
        this.subjectNameLabel.setForeground(Color.black);
        this.jPanel17.add(this.subjectNameLabel);
        this.subjectCommentLabel.setForeground(Color.white);
        this.jPanel17.add(this.subjectCommentLabel);
        this.annualPanel.add(this.jPanel17);
        this.moneyLabel.setAlignmentX(1.0f);
        this.moneyLabel.setText(SystemUtil.getResourceString("InitialAmount"));
        this.moneyLabel.setHorizontalAlignment(4);
        this.jPanel18.add(this.moneyLabel);
        this.moneyText.setColumns(15);
        this.moneyText.setFont(new Font("Monospaced", 0, 14));
        this.jPanel18.add(this.moneyText);
        this.annualPanel.add(this.jPanel18);
        this.getContentPane().add(this.annualPanel);
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save24.gif")));
        this.okButton.setText(SystemUtil.getResourceString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
        this.cancelButton.setText(SystemUtil.getResourceString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectEditor.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add(this.jPanel1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.onCancel();
    }

    private void groupDelButtonActionPerformed(ActionEvent actionEvent) {
        SubjectGroup subjectGroup = this.utils.getSelectedGroup();
        if (subjectGroup == null) {
            return;
        }
        Object[] objectArray = new String[]{subjectGroup.getName()};
        String string = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"), objectArray);
        int n = JOptionPane.showConfirmDialog(this, string, SystemUtil.getResourceString("Confirm"), 0);
        if (n != 0) {
            return;
        }
        try {
            this.project.removeSubjectGroup(subjectGroup.getId(), this.manager);
        }
        catch (RemovalException removalException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString(removalException.getMessage()));
        }
        this.lastMoney = null;
        this.utils.updateGroupList();
        this.updateMoney();
    }

    private void groupModButtonActionPerformed(ActionEvent actionEvent) {
        SubjectGroup subjectGroup = this.utils.getSelectedGroup();
        if (subjectGroup == null) {
            return;
        }
        DSubjectGroup dSubjectGroup = new DSubjectGroup(this.ownerFrame, SystemUtil.getResourceString("InputSubgroupData"), SystemUtil.getResourceString("SubgroupName"), SystemUtil.getResourceString("SubgroupComment"), subjectGroup, subjectGroup.getBalanceGroup());
        dSubjectGroup.show();
        subjectGroup.setBalanceGroup(dSubjectGroup.getBalanceGroup());
        this.project.syncAnnualData();
        this.utils.updateGroupList();
        this.updateMoney();
    }

    private void groupAddButtonActionPerformed(ActionEvent actionEvent) {
        SubjectGroup subjectGroup = this.project.addSubjectGroup(SystemUtil.getResourceString("DefaultSubjectGroupName"), SystemUtil.getResourceString("DefaultSubjectGroupComment"), 0);
        DSubjectGroup dSubjectGroup = new DSubjectGroup(this.ownerFrame, SystemUtil.getResourceString("InputSubjectGroupData"), SystemUtil.getResourceString("SubjectGroupName"), SystemUtil.getResourceString("SubjectGroupComment"), subjectGroup, subjectGroup.getBalanceGroup());
        dSubjectGroup.show();
        subjectGroup.setBalanceGroup(dSubjectGroup.getBalanceGroup());
        this.utils.updateGroupList();
        this.updateMoney();
    }

    private void subjectListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.subgroupList.requestFocus();
        }
    }

    private void subgroupListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 39) {
            this.subjectList.requestFocus();
        }
        if (keyEvent.getKeyCode() == 37) {
            this.groupList.requestFocus();
        }
    }

    private void groupListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 39) {
            this.subgroupList.requestFocus();
        }
    }

    private void subjectListMouseClicked(MouseEvent mouseEvent) {
        this.updateMoney();
        if (mouseEvent.getClickCount() == 2) {
            this.subjectModButtonActionPerformed(null);
        }
    }

    private void subjectListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateMoney();
    }

    private void yearComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.updateYear();
    }

    private void subgroupListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.utils.updateSubjectList();
    }

    private void subgroupListMouseClicked(MouseEvent mouseEvent) {
        this.utils.updateSubjectList();
        if (mouseEvent.getClickCount() == 2) {
            this.subModButtonActionPerformed(null);
        }
    }

    private void groupListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.utils.updateSubgroupList();
    }

    private void groupListMouseClicked(MouseEvent mouseEvent) {
        this.utils.updateSubgroupList();
        if (mouseEvent.getClickCount() == 2) {
            this.groupModButtonActionPerformed(null);
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.onOk();
    }

    private void subjectDelButtonActionPerformed(ActionEvent actionEvent) {
        Subject subject = this.utils.getSelectedSubject();
        if (subject == null) {
            return;
        }
        Object[] objectArray = new String[]{subject.getName()};
        String string = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"), objectArray);
        int n = JOptionPane.showConfirmDialog(this, string, SystemUtil.getResourceString("Confirm"), 0);
        if (n == 1) {
            return;
        }
        try {
            this.project.removeSubject(subject.getId(), this.manager);
        }
        catch (RemovalException removalException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString(removalException.getMessage()));
        }
        this.lastMoney = null;
        this.utils.updateSubjectList();
    }

    private void subjectModButtonActionPerformed(ActionEvent actionEvent) {
        Subject subject = this.utils.getSelectedSubject();
        if (subject == null) {
            return;
        }
        this.checkSpecialLabel(subject);
        this.project.syncAnnualData();
        this.utils.updateSubjectList();
        this.updateMoney();
    }

    private void subjectAddButtonActionPerformed(ActionEvent actionEvent) {
        SubjectSubgroup subjectSubgroup = this.utils.getSelectedSubgroup();
        if (subjectSubgroup == null) {
            return;
        }
        SubjectGroup subjectGroup = this.utils.getSelectedGroup();
        if (subjectGroup == null) {
            return;
        }
        Subject subject = this.project.addSubject(SystemUtil.getResourceString("DefaultSubjectName"), SystemUtil.getResourceString("DefaultSubjectComment"), subjectGroup.getId(), subjectSubgroup.getId());
        this.checkSpecialLabel(subject);
        this.utils.updateSubjectList();
        this.updateMoney();
    }

    private void checkSpecialLabel(Subject subject) {
        int n = subject.getSpecialLabel();
        DSubject dSubject = new DSubject(this.ownerFrame, SystemUtil.getResourceString("InputSubjectData"), SystemUtil.getResourceString("SubjectName"), SystemUtil.getResourceString("SubjectComment"), subject);
        dSubject.show();
        if (subject.getSpecialLabel() != 0 && subject.getSpecialLabel() != 3) {
            Iterator iterator = this.project.getSubjects().iterator();
            while (iterator.hasNext()) {
                Subject subject2 = (Subject)iterator.next();
                if (subject.getSpecialLabel() != subject2.getSpecialLabel() || subject2.getId() == subject.getId()) continue;
                String string = SystemUtil.getResourceString("WrongSpecialLabel");
                JOptionPane.showMessageDialog(this, string);
                subject.setSpecialLabel(n);
                break;
            }
        }
    }

    private void subDelButtonActionPerformed(ActionEvent actionEvent) {
        SubjectSubgroup subjectSubgroup = this.utils.getSelectedSubgroup();
        if (subjectSubgroup == null) {
            return;
        }
        Object[] objectArray = new String[]{subjectSubgroup.getName()};
        String string = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"), objectArray);
        int n = JOptionPane.showConfirmDialog(this, string, SystemUtil.getResourceString("Confirm"), 0);
        if (n != 0) {
            return;
        }
        try {
            this.project.removeSubjectSubgroup(subjectSubgroup.getId(), this.manager);
        }
        catch (RemovalException removalException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString(removalException.getMessage()));
        }
        this.lastMoney = null;
        this.utils.updateSubgroupList();
        this.updateMoney();
    }

    private void subModButtonActionPerformed(ActionEvent actionEvent) {
        SubjectSubgroup subjectSubgroup = this.utils.getSelectedSubgroup();
        if (subjectSubgroup == null) {
            return;
        }
        DSubject dSubject = new DSubject(this.ownerFrame, SystemUtil.getResourceString("InputSubgroupData"), SystemUtil.getResourceString("SubgroupName"), SystemUtil.getResourceString("SubgroupComment"), subjectSubgroup);
        dSubject.show();
        this.project.syncAnnualData();
        this.utils.updateSubgroupList();
        this.updateMoney();
    }

    private void subAddButtonActionPerformed(ActionEvent actionEvent) {
        SubjectGroup subjectGroup = this.utils.getSelectedGroup();
        if (subjectGroup == null) {
            return;
        }
        SubjectSubgroup subjectSubgroup = this.project.addSubjectSubgroup(SystemUtil.getResourceString("DefaultSubgroupName"), SystemUtil.getResourceString("DefaultSubgroupComment"), subjectGroup.getId());
        DSubject dSubject = new DSubject(this.ownerFrame, SystemUtil.getResourceString("InputSubgroupData"), SystemUtil.getResourceString("SubgroupName"), SystemUtil.getResourceString("SubgroupComment"), subjectSubgroup);
        dSubject.show();
        this.utils.updateSubgroupList();
        this.updateMoney();
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        ProjectData projectData = new ProjectData(0, "Project", "test project");
        ProjectMaker.make(projectData, null);
        DProjectEditor dProjectEditor = new DProjectEditor((Frame)new JFrame(), projectData, null);
        dProjectEditor.show();
    }
}

