/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.DataLockingException;
import arg.money.ProjectData;
import arg.money.ProjectMaker;
import arg.money.ProjectManager;
import arg.money.SecurityManager;
import arg.money.SessionData;
import arg.money.SlipManager;
import arg.money.SystemUtil;
import arg.money.gui.DProjectEditor;
import arg.money.gui.DProjectSource;
import arg.money.gui.SubjectsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DProjectManager
extends JDialog {
    Frame ownerFrame;
    ProjectManager manager;
    SlipManager slipManager;
    SessionData session;
    ProjectData[] parray;
    private JPanel jPanel1;
    private JButton okButton;
    private JPanel jPanel6;
    private JScrollPane jScrollPane3;
    private JList projectList;
    private JPanel jPanel7;
    private JButton addButton;
    private JButton modButton;
    private JButton delButton;
    private JButton copyButton;
    private JButton extButton;
    private JLabel titleLabel;

    public DProjectManager(Frame frame, SessionData sessionData, ProjectManager projectManager) {
        this(frame, true);
        this.ownerFrame = frame;
        this.manager = projectManager;
        this.slipManager = this.manager.getParent().getSlipManager();
        this.session = sessionData;
        this.updateProjectList();
        this.userButton();
        this.pack();
        SubjectsUtil.setCenter(this);
    }

    public DProjectManager(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.jPanel6 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.projectList = new JList();
        this.jPanel7 = new JPanel();
        this.addButton = new JButton();
        this.modButton = new JButton();
        this.delButton = new JButton();
        this.copyButton = new JButton();
        this.extButton = new JButton();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DProjectManager.this.closeDialog(windowEvent);
            }
        });
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
        this.okButton.setText(SystemUtil.getResourceString("Exit"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel6.setLayout(new BorderLayout(5, 5));
        this.jPanel6.setName("UserPanel");
        this.projectList.setFixedCellWidth(240);
        this.projectList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DProjectManager.this.projectListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane3.setViewportView(this.projectList);
        this.jPanel6.add((Component)this.jScrollPane3, "Center");
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New24.gif")));
        this.addButton.setText(SystemUtil.getResourceString("Add"));
        this.addButton.setFont(new Font("Serif", 0, 14));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.addButton);
        this.modButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif")));
        this.modButton.setText(SystemUtil.getResourceString("Modify"));
        this.modButton.setFont(new Font("Serif", 0, 14));
        this.modButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager.this.modButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.modButton);
        this.delButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif")));
        this.delButton.setText(SystemUtil.getResourceString("Delete"));
        this.delButton.setForeground(Color.red);
        this.delButton.setFont(new Font("Serif", 0, 14));
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager.this.delButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.delButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy24.gif")));
        this.copyButton.setText(SystemUtil.getResourceString("Copy"));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager.this.copyButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.copyButton);
        this.extButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Export24.gif")));
        this.extButton.setText(SystemUtil.getResourceString("Export"));
        this.extButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DProjectManager.this.extButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.extButton);
        this.jPanel6.add((Component)this.jPanel7, "East");
        this.getContentPane().add((Component)this.jPanel6, "Center");
        this.titleLabel.setText(SystemUtil.getResourceString("ProjectManager"));
        this.titleLabel.setFont(new Font("Serif", 0, 36));
        this.getContentPane().add((Component)this.titleLabel, "North");
    }

    private void extButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.projectList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ProjectData projectData = this.parray[n];
        JFileChooser jFileChooser = new JFileChooser();
        int n2 = jFileChooser.showSaveDialog(this.ownerFrame);
        if (n2 == 0) {
            ProjectMaker.save(projectData, jFileChooser.getSelectedFile().getPath());
        }
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.projectList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ProjectData projectData = this.parray[n];
        String string = "temp.txt";
        ProjectMaker.save(projectData, string);
        projectData = this.manager.makeProject(SystemUtil.getResourceString("DefaultProject"), SystemUtil.getResourceString("DefaultProjectComment"));
        ProjectMaker.make(projectData, string);
        DProjectEditor dProjectEditor = new DProjectEditor(this.ownerFrame, projectData, this.slipManager);
        dProjectEditor.show();
        if (dProjectEditor.isOk()) {
            this.manager.comitProjectData(projectData);
        }
        this.updateProjectList();
    }

    private void projectListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.modButtonActionPerformed(null);
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.onOk();
    }

    private void delButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.projectList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ProjectData projectData = this.parray[n];
        Object[] objectArray = new String[]{projectData.getName()};
        String string = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"), objectArray);
        int n2 = JOptionPane.showConfirmDialog(this, string, SystemUtil.getResourceString("Confirm"), 0);
        if (n2 == 0) {
            try {
                this.manager.removeProject(projectData.getId());
            }
            catch (DataLockingException dataLockingException) {
                JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("ProjectLockError"));
                return;
            }
        }
        this.updateProjectList();
    }

    private void modButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.projectList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ProjectData projectData = null;
        try {
            projectData = this.manager.lockProjectData(this.parray[n].getId());
        }
        catch (DataLockingException dataLockingException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("ProjectLockError"));
            return;
        }
        DProjectEditor dProjectEditor = new DProjectEditor(this.ownerFrame, projectData, this.slipManager);
        dProjectEditor.show();
        if (dProjectEditor.isOk()) {
            this.manager.comitProjectData(projectData);
        } else {
            this.manager.cancelProjectData(projectData);
        }
        this.updateProjectList();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        ProjectData projectData = this.manager.makeProject("NewProject", "project comment");
        String string = this.manager.getParent().getProjectResourceFilename();
        DProjectSource dProjectSource = new DProjectSource(this.ownerFrame, string);
        dProjectSource.show();
        if (!dProjectSource.isOk()) {
            return;
        }
        string = dProjectSource.getSource();
        ProjectMaker.make(projectData, string);
        DProjectEditor dProjectEditor = new DProjectEditor(this.ownerFrame, projectData, this.slipManager);
        dProjectEditor.show();
        if (dProjectEditor.isOk()) {
            this.manager.comitProjectData(projectData);
        }
        this.updateProjectList();
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void updateProjectList() {
        SecurityManager securityManager = this.manager.getParent().getSecurityManager();
        List list = this.manager.getProjects();
        LinkedList<ProjectData> linkedList = new LinkedList<ProjectData>();
        int n = 0;
        while (n < list.size()) {
            ProjectData projectData = (ProjectData)list.get(n);
            if (securityManager.getPermission(this.session, projectData.getId(), 4)) {
                linkedList.add(projectData);
            }
            ++n;
        }
        this.parray = new ProjectData[linkedList.size()];
        int n2 = 0;
        while (n2 < this.parray.length) {
            this.parray[n2] = (ProjectData)linkedList.get(n2);
            ++n2;
        }
        this.projectList.setListData(this.parray);
    }

    private void userButton() {
        SecurityManager securityManager = this.manager.getParent().getSecurityManager();
        if (!securityManager.getAdminPermission(this.session)) {
            this.addButton.setEnabled(false);
            this.delButton.setEnabled(false);
            this.copyButton.setEnabled(false);
        }
    }

    void onOk() {
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new DProjectManager((Frame)new JFrame(), true).show();
    }
}

