/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.GroupData;
import arg.money.GroupManager;
import arg.money.NumberIdentical;
import arg.money.ProjectData;
import arg.money.ProjectManager;
import arg.money.SecurityManager;
import arg.money.SystemUtil;
import arg.money.UserData;
import arg.money.UserManager;
import arg.money.gui.DGroupEditor;
import arg.money.gui.DUserEditor;
import arg.money.gui.SubjectsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DSecurityManager
extends JDialog {
    SecurityManager manager;
    Frame parentFrame;
    UserData[] uarray;
    GroupData[] garray;
    private JLabel jLabel1;
    private JTabbedPane jTab;
    private JPanel userPanel;
    private JScrollPane jScrollPane1;
    private JList userList;
    private JPanel jPanel3;
    private JButton userAddButton;
    private JButton userModButton;
    private JButton userDelButton;
    private JPanel jPanel4;
    private JPanel groupListPanel;
    private JScrollPane jScrollPane2;
    private JList groupList;
    private JPanel aboutPanel;
    private JPanel comPanel;
    private JTextField gCommentText;
    private JPanel memPanel;
    private JTextField gMemberText;
    private JPanel axsPanel;
    private JScrollPane jScrollPane3;
    private JList projectsList;
    private JPanel jPanel11;
    private JButton addGButton;
    private JButton modGButton;
    private JButton delGButton;
    private JPanel jPanel1;
    private JButton okButton;

    public DSecurityManager(Frame frame, SecurityManager securityManager) {
        this(frame, true);
        frame = this.parentFrame;
        this.manager = securityManager;
        this.initData();
        SubjectsUtil.setCenter(this);
    }

    void initData() {
        this.updateUserList();
        this.userList.setSelectedIndex(0);
        this.updateGroupList();
        this.selectGroup(0);
        this.pack();
    }

    void updateUserList() {
        UserManager userManager = this.manager.getUserManager();
        List list = userManager.getUsers();
        this.uarray = new UserData[list.size()];
        String[] stringArray = new String[list.size()];
        int n = 0;
        while (n < list.size()) {
            this.uarray[n] = (UserData)list.get(n);
            stringArray[n] = this.uarray[n].getName() + " [" + this.uarray[n].getComment() + "]";
            ++n;
        }
        this.userList.setListData(stringArray);
    }

    void updateGroupList() {
        GroupManager groupManager = this.manager.getGroupManager();
        List list = groupManager.getGroups();
        this.garray = new GroupData[list.size()];
        int n = 0;
        while (n < list.size()) {
            GroupData groupData;
            this.garray[n] = groupData = (GroupData)list.get(n);
            ++n;
        }
        this.groupList.setListData(this.garray);
    }

    void selectGroup(int n) {
        Object object;
        Object object2;
        if (n < 0) {
            return;
        }
        if (n >= this.garray.length) {
            return;
        }
        GroupManager groupManager = this.manager.getGroupManager();
        UserManager userManager = this.manager.getUserManager();
        List list = groupManager.getGroups();
        GroupData groupData = this.garray[n];
        this.gCommentText.setText(groupData.getComment());
        this.gCommentText.setEditable(false);
        StringBuffer stringBuffer = new StringBuffer();
        List list2 = groupData.getUsers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object2 = (NumberIdentical)iterator.next();
            object = userManager.getUser(object2.getId());
            stringBuffer.append(((UserData)object).getName()).append(" ");
        }
        this.gMemberText.setText(stringBuffer.toString());
        this.gMemberText.setEditable(false);
        object2 = this.manager.getParent().getProjectManager();
        object = ((ProjectManager)object2).getProjects();
        String[] stringArray = new String[object.size()];
        int n2 = 0;
        while (n2 < object.size()) {
            ProjectData projectData = (ProjectData)object.get(n2);
            stringBuffer = new StringBuffer();
            stringBuffer.append(projectData.getName());
            int n3 = 0;
            while (n3 < GroupData.masks.length) {
                if (groupData.isPermitted(projectData.getId(), GroupData.masks[n3])) {
                    stringBuffer.append(" : [" + SystemUtil.getResourceString(GroupData.resourceStrings[n3]) + "]");
                }
                ++n3;
            }
            stringArray[n2] = stringBuffer.toString();
            ++n2;
        }
        this.projectsList.setListData(stringArray);
    }

    public DSecurityManager(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.jTab.setTitleAt(0, SystemUtil.getResourceString("UserData"));
        this.jTab.setTitleAt(1, SystemUtil.getResourceString("GroupData"));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTab = new JTabbedPane();
        this.userPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.userList = new JList();
        this.jPanel3 = new JPanel();
        this.userAddButton = new JButton();
        this.userModButton = new JButton();
        this.userDelButton = new JButton();
        this.jPanel4 = new JPanel();
        this.groupListPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.groupList = new JList();
        this.aboutPanel = new JPanel();
        this.comPanel = new JPanel();
        this.gCommentText = new JTextField();
        this.memPanel = new JPanel();
        this.gMemberText = new JTextField();
        this.axsPanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.projectsList = new JList();
        this.jPanel11 = new JPanel();
        this.addGButton = new JButton();
        this.modGButton = new JButton();
        this.delGButton = new JButton();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DSecurityManager.this.closeDialog(windowEvent);
            }
        });
        this.jLabel1.setText(SystemUtil.getResourceString("SecurityManager"));
        this.jLabel1.setFont(new Font("Serif", 0, 36));
        this.getContentPane().add((Component)this.jLabel1, "North");
        this.jTab.setName("GroupPanel");
        this.jTab.setFont(new Font("Serif", 0, 14));
        this.userPanel.setLayout(new BorderLayout(5, 5));
        this.userPanel.setName("UserPanel");
        this.userList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DSecurityManager.this.userListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.userList);
        this.userPanel.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.userAddButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New24.gif")));
        this.userAddButton.setFont(new Font("Serif", 0, 14));
        this.userAddButton.setText(SystemUtil.getResourceString("Add"));
        this.userAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.userAddButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.userAddButton);
        this.userModButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif")));
        this.userModButton.setFont(new Font("Serif", 0, 14));
        this.userModButton.setText(SystemUtil.getResourceString("Modify"));
        this.userModButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.userModButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.userModButton);
        this.userDelButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif")));
        this.userDelButton.setForeground(Color.red);
        this.userDelButton.setFont(new Font("Serif", 0, 14));
        this.userDelButton.setText(SystemUtil.getResourceString("Delete"));
        this.userDelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.userDelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.userDelButton);
        this.userPanel.add((Component)this.jPanel3, "East");
        this.jTab.addTab("jPanel2", this.userPanel);
        this.jPanel4.setLayout(new BorderLayout());
        this.groupListPanel.setLayout(new BoxLayout(this.groupListPanel, 1));
        this.groupListPanel.setBorder(new TitledBorder(new EtchedBorder(), "Choose groups", 4, 2, new Font("SansSerif", 0, 12), Color.black));
        SubjectsUtil.borderTitle(this.groupListPanel, SystemUtil.getResourceString("ChooseGroup"));
        this.groupList.setFixedCellWidth(150);
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DSecurityManager.this.groupListValueChanged(listSelectionEvent);
            }
        });
        this.groupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DSecurityManager.this.groupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.groupList);
        this.groupListPanel.add(this.jScrollPane2);
        this.jPanel4.add((Component)this.groupListPanel, "West");
        this.aboutPanel.setLayout(new BoxLayout(this.aboutPanel, 1));
        this.aboutPanel.setBorder(new TitledBorder("About group"));
        SubjectsUtil.borderTitle(this.aboutPanel, SystemUtil.getResourceString("AboutPanel"));
        this.comPanel.setBorder(new TitledBorder("Comment"));
        SubjectsUtil.borderTitle(this.comPanel, SystemUtil.getResourceString("GroupComment"));
        this.gCommentText.setColumns(40);
        this.gCommentText.setText("jTextField1");
        this.gCommentText.setBackground(new Color(237, 237, 237));
        this.comPanel.add(this.gCommentText);
        this.aboutPanel.add(this.comPanel);
        this.memPanel.setBorder(new TitledBorder("Members"));
        SubjectsUtil.borderTitle(this.memPanel, SystemUtil.getResourceString("GroupMember"));
        this.gMemberText.setColumns(40);
        this.gMemberText.setText("jTextField2");
        this.gMemberText.setBackground(new Color(237, 237, 237));
        this.memPanel.add(this.gMemberText);
        this.aboutPanel.add(this.memPanel);
        this.axsPanel.setLayout(new BorderLayout());
        this.axsPanel.setBorder(new TitledBorder("Access"));
        SubjectsUtil.borderTitle(this.axsPanel, SystemUtil.getResourceString("AccessPanel"));
        this.projectsList.setBackground(new Color(237, 237, 237));
        this.jScrollPane3.setViewportView(this.projectsList);
        this.axsPanel.add((Component)this.jScrollPane3, "Center");
        this.aboutPanel.add(this.axsPanel);
        this.jPanel4.add((Component)this.aboutPanel, "Center");
        this.addGButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New24.gif")));
        this.addGButton.setFont(new Font("Serif", 0, 12));
        this.addGButton.setText(SystemUtil.getResourceString("AddGroup"));
        this.addGButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.addGButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.addGButton);
        this.modGButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif")));
        this.modGButton.setFont(new Font("Serif", 0, 12));
        this.modGButton.setText(SystemUtil.getResourceString("ModGroup"));
        this.modGButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.modGButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.modGButton);
        this.delGButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif")));
        this.delGButton.setForeground(Color.red);
        this.delGButton.setFont(new Font("Serif", 0, 12));
        this.delGButton.setText(SystemUtil.getResourceString("DelGroup"));
        this.delGButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.delGButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.delGButton);
        this.jPanel4.add((Component)this.jPanel11, "South");
        this.jTab.addTab("jPanel4", this.jPanel4);
        this.getContentPane().add((Component)this.jTab, "Center");
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
        this.okButton.setFont(new Font("Serif", 0, 14));
        this.okButton.setText(SystemUtil.getResourceString("Exit"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSecurityManager.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
    }

    private void userListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.userModButtonActionPerformed(null);
        }
    }

    private void groupListMouseClicked(MouseEvent mouseEvent) {
        int n = this.getSelected();
        if (n >= 0) {
            this.selectGroup(n);
        }
        if (mouseEvent.getClickCount() == 2) {
            this.modGButtonActionPerformed(null);
        }
    }

    private void groupListValueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.getSelected();
        if (n >= 0) {
            this.selectGroup(n);
        }
    }

    private void userDelButtonActionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        int n = this.userList.getSelectedIndex();
        if (n < 0 || n >= this.uarray.length) {
            return;
        }
        UserData userData = this.uarray[n];
        String string = SystemUtil.getResourceString("RemoveConfirm");
        MessageFormat messageFormat = new MessageFormat(string);
        int n2 = JOptionPane.showConfirmDialog(this, messageFormat.format(stringArray = new String[]{userData.getName()}), "Remove?", 0);
        if (n2 == 0) {
            this.manager.getUserManager().removeUser(userData.getId());
            this.updateUserList();
        }
    }

    private void userModButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.userList.getSelectedIndex();
        UserManager userManager = this.manager.getUserManager();
        if (n >= 0 && this.uarray.length > n) {
            UserData userData = this.uarray[n];
            DUserEditor dUserEditor = new DUserEditor(this.parentFrame, userData);
            dUserEditor.show();
            this.updateUserList();
        }
    }

    private void userAddButtonActionPerformed(ActionEvent actionEvent) {
        UserManager userManager = this.manager.getUserManager();
        UserData userData = userManager.addUser(SystemUtil.getResourceString("DefaultUserName"), SystemUtil.getResourceString("DefaultUserComment"), "");
        DUserEditor dUserEditor = new DUserEditor(this.parentFrame, userData);
        dUserEditor.show();
        if (!dUserEditor.isOk()) {
            userManager.removeUser(userData.getId());
            return;
        }
        this.updateUserList();
    }

    private void delGButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.getSelected();
        GroupManager groupManager = this.manager.getGroupManager();
        if (n >= 0 && this.garray.length > n) {
            String[] stringArray;
            GroupData groupData = this.garray[n];
            if (groupData == null) {
                System.err.println("Group not found.");
                return;
            }
            String string = SystemUtil.getResourceString("RemoveConfirm");
            MessageFormat messageFormat = new MessageFormat(string);
            int n2 = JOptionPane.showConfirmDialog(this, messageFormat.format(stringArray = new String[]{groupData.getName()}), SystemUtil.getResourceString("Remove"), 0);
            if (n2 == 0) {
                groupManager.removeGroup(groupData.getId());
                this.updateGroupList();
            }
        }
    }

    private void modGButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.getSelected();
        GroupManager groupManager = this.manager.getGroupManager();
        if (n >= 0 && this.garray.length > n) {
            GroupData groupData = this.garray[n];
            DGroupEditor dGroupEditor = new DGroupEditor(this.parentFrame, groupData, this.manager);
            dGroupEditor.show();
            this.updateGroupList();
            this.selectGroup(n);
        }
    }

    private void addGButtonActionPerformed(ActionEvent actionEvent) {
        GroupManager groupManager = this.manager.getGroupManager();
        GroupData groupData = groupManager.addGroup(SystemUtil.getResourceString("DefaultGroupName"), SystemUtil.getResourceString("DefaultGroupComment"));
        DGroupEditor dGroupEditor = new DGroupEditor(this.parentFrame, groupData, this.manager);
        dGroupEditor.show();
        if (!dGroupEditor.isOk()) {
            groupManager.removeGroup(groupData.getId());
            return;
        }
        this.updateGroupList();
        this.selectGroup(this.garray.length - 1);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.manager.update();
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new DSecurityManager((Frame)new JFrame(), true).show();
    }

    int getSelected() {
        return this.groupList.getSelectedIndex();
    }
}

