/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ProjectData;
import arg.money.ProjectMaker;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectSubgroup;
import arg.money.SystemUtil;
import arg.money.gui.SubjectsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.gr.java_conf.ccs2.comp.MessageListener;

public class DSubjectSelect
extends JDialog {
    boolean ok = false;
    int id = -1;
    ProjectData project;
    SubjectsUtil utils;
    private JLabel titleLabel;
    private JPanel mainPanel;
    private JPanel groupPanel;
    private JScrollPane jScrollPane1;
    private JList groupList;
    private JLabel groupLabel;
    private JPanel subgroupPanel;
    private JScrollPane jScrollPane2;
    private JList subgroupList;
    private JLabel subgroupLabel;
    private JPanel subjectPanel;
    private JScrollPane jScrollPane3;
    private JList subjectList;
    private JLabel subjectLabel;
    private JPanel southPanel;
    private JButton okButton;
    private JButton cancelButton;

    public DSubjectSelect(Frame frame, ProjectData projectData) {
        this(frame, true);
        this.project = projectData;
        this.utils = new SubjectsUtil(this.project, this.groupList, this.subgroupList, this.subjectList, new MessageListener(){

            public void message(String string, int n, Object object) {
                DSubjectSelect.this.updateId();
            }
        });
        this.updateId();
    }

    public DSubjectSelect(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
    }

    public int getId() {
        return this.id;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.groupPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.groupList = new JList();
        this.groupLabel = new JLabel();
        this.subgroupPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.subgroupList = new JList();
        this.subgroupLabel = new JLabel();
        this.subjectPanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.subjectList = new JList();
        this.subjectLabel = new JLabel();
        this.southPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DSubjectSelect.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setText(SystemUtil.getResourceString("SubjectSelection"));
        this.titleLabel.setFont(new Font("Serif", 0, 36));
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.mainPanel.setLayout(new GridLayout(1, 3));
        this.groupPanel.setLayout(new BorderLayout());
        this.groupPanel.setBorder(new TitledBorder(new EtchedBorder(), "Group"));
        SubjectsUtil.borderTitle(this.groupPanel, SystemUtil.getResourceString("Group"));
        this.groupList.setVisibleRowCount(12);
        this.groupList.setMaximumSize(new Dimension(120, 240));
        this.groupList.setMinimumSize(new Dimension(120, 240));
        this.groupList.setFixedCellWidth(150);
        this.groupList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DSubjectSelect.this.groupListKeyPressed(keyEvent);
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DSubjectSelect.this.groupListValueChanged(listSelectionEvent);
            }
        });
        this.groupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DSubjectSelect.this.groupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.groupList);
        this.groupPanel.add((Component)this.jScrollPane1, "Center");
        this.groupLabel.setMaximumSize(new Dimension(180, 16));
        this.groupLabel.setAlignmentX(0.5f);
        this.groupLabel.setMinimumSize(new Dimension(180, 16));
        this.groupLabel.setForeground(Color.white);
        this.groupLabel.setHorizontalAlignment(2);
        this.groupPanel.add((Component)this.groupLabel, "South");
        this.mainPanel.add(this.groupPanel);
        this.subgroupPanel.setLayout(new BorderLayout());
        this.subgroupPanel.setBorder(new TitledBorder(new EtchedBorder(), "Subgroup"));
        SubjectsUtil.borderTitle(this.subgroupPanel, SystemUtil.getResourceString("Subgroup"));
        this.subgroupList.setVisibleRowCount(12);
        this.subgroupList.setMaximumSize(new Dimension(120, 240));
        this.subgroupList.setMinimumSize(new Dimension(120, 240));
        this.subgroupList.setFixedCellWidth(150);
        this.subgroupList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DSubjectSelect.this.subgroupListKeyPressed(keyEvent);
            }
        });
        this.subgroupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DSubjectSelect.this.subgroupListValueChanged(listSelectionEvent);
            }
        });
        this.subgroupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DSubjectSelect.this.subgroupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.subgroupList);
        this.subgroupPanel.add((Component)this.jScrollPane2, "Center");
        this.subgroupLabel.setMaximumSize(new Dimension(180, 16));
        this.subgroupLabel.setAlignmentX(0.5f);
        this.subgroupLabel.setMinimumSize(new Dimension(180, 16));
        this.subgroupLabel.setForeground(Color.white);
        this.subgroupLabel.setHorizontalAlignment(2);
        this.subgroupPanel.add((Component)this.subgroupLabel, "South");
        this.mainPanel.add(this.subgroupPanel);
        this.subjectPanel.setLayout(new BorderLayout());
        this.subjectPanel.setBorder(new TitledBorder(new EtchedBorder(), "Subject"));
        SubjectsUtil.borderTitle(this.subjectPanel, SystemUtil.getResourceString("Subject"));
        this.subjectList.setVisibleRowCount(12);
        this.subjectList.setMaximumSize(new Dimension(120, 240));
        this.subjectList.setMinimumSize(new Dimension(120, 240));
        this.subjectList.setFixedCellWidth(150);
        this.subjectList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DSubjectSelect.this.subjectListKeyPressed(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                DSubjectSelect.this.subjectListKeyTyped(keyEvent);
            }
        });
        this.subjectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DSubjectSelect.this.subjectListValueChanged(listSelectionEvent);
            }
        });
        this.subjectList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DSubjectSelect.this.subjectListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane3.setViewportView(this.subjectList);
        this.subjectPanel.add((Component)this.jScrollPane3, "Center");
        this.subjectLabel.setMaximumSize(new Dimension(180, 16));
        this.subjectLabel.setAlignmentX(0.5f);
        this.subjectLabel.setMinimumSize(new Dimension(180, 16));
        this.subjectLabel.setForeground(Color.white);
        this.subjectLabel.setHorizontalAlignment(2);
        this.subjectPanel.add((Component)this.subjectLabel, "South");
        this.mainPanel.add(this.subjectPanel);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.okButton.setText(SystemUtil.getResourceString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSubjectSelect.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.southPanel.add(this.okButton);
        this.cancelButton.setText(SystemUtil.getResourceString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSubjectSelect.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.southPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    private void subjectListMouseClicked(MouseEvent mouseEvent) {
        this.updateId();
    }

    private void subjectListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateId();
    }

    private void subgroupListMouseClicked(MouseEvent mouseEvent) {
        this.utils.updateSubjectList();
    }

    private void subgroupListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.utils.updateSubjectList();
    }

    private void groupListMouseClicked(MouseEvent mouseEvent) {
        this.utils.updateSubgroupList();
    }

    private void groupListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.utils.updateSubgroupList();
    }

    private void groupListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 39) {
            this.subgroupList.requestFocus();
            if (this.subgroupList.getModel().getSize() != 0) {
                this.subgroupList.setSelectedIndex(0);
            }
        }
    }

    private void subjectListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.subgroupList.requestFocus();
            if (this.subgroupList.getModel().getSize() != 0) {
                this.subgroupList.setSelectedIndex(0);
            }
        }
    }

    private void subgroupListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 39) {
            this.subjectList.requestFocus();
            if (this.subjectList.getModel().getSize() != 0) {
                this.subjectList.setSelectedIndex(0);
            }
        }
        if (keyEvent.getKeyCode() == 37) {
            this.groupList.requestFocus();
            if (this.groupList.getModel().getSize() != 0) {
                this.groupList.setSelectedIndex(0);
            }
        }
    }

    private void subjectListKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.onOk();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.onOk();
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void onOk() {
        this.updateId();
        if (this.id == -1) {
            return;
        }
        this.ok = true;
        this.dispose();
    }

    void updateId() {
        if (this.utils != null) {
            SubjectGroup subjectGroup = this.utils.getSelectedGroup();
            String string = "";
            if (subjectGroup != null) {
                string = subjectGroup.getComment();
            }
            this.groupLabel.setText(string);
            string = "";
            SubjectSubgroup subjectSubgroup = this.utils.getSelectedSubgroup();
            if (subjectSubgroup != null) {
                string = subjectSubgroup.getComment();
            }
            this.subgroupLabel.setText(string);
            Subject subject = this.utils.getSelectedSubject();
            string = "";
            if (subject != null) {
                string = subject.getComment();
            }
            this.subjectLabel.setText(string);
            this.id = this.utils.getSelectedSubject().getId();
        }
    }

    public static void main(String[] stringArray) {
        ProjectData projectData = new ProjectData(0, "Project", "test project");
        ProjectMaker.make(projectData, null);
        DSubjectSelect dSubjectSelect = new DSubjectSelect((Frame)new JFrame(), projectData);
        while (!dSubjectSelect.isOk()) {
            dSubjectSelect.show();
        }
        System.out.println(projectData.getSubject(dSubjectSelect.getId()) + " was selected.");
    }
}

