/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ASlipLine;
import arg.money.ProjectData;
import arg.money.SlipElement;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.TransferSlip;
import arg.money.UserData;
import arg.money.gui.DSubjectSelect;
import arg.money.gui.SubjectsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.swing.DateComponent;
import jp.gr.java_conf.ccs2.comp.swing.DirectIMFocusListener;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class DTransferSlipEdit
extends JDialog {
    TransferSlip slip;
    TransferSlip backupSlip;
    SlipManager manager;
    ProjectData project;
    UserData user;
    boolean ok = false;
    Frame ownerFrame;
    JTextField yearLabel;
    JTextField rnText;
    JTextField projectLabel;
    DateComponent dateField;
    JTextField userLabel;
    String[] titles = new String[]{SystemUtil.getResourceString("Credit"), SystemUtil.getResourceString("Amount"), SystemUtil.getResourceString("Summary"), SystemUtil.getResourceString("Debtor"), SystemUtil.getResourceString("Amount")};
    final int[] columns = new int[]{10, 10, 30, 10, 10};
    final int CREDIT = 0;
    final int LAMOUNT = 1;
    final int SUMMARY = 2;
    final int DEBTOR = 3;
    final int RAMOUNT = 4;
    JPanel table;
    JButton radd;
    JButton ladd;
    JButton del;
    List lines;
    NumberFormat form = NumberFormat.getInstance();

    public DTransferSlipEdit(Frame frame, TransferSlip transferSlip, SlipManager slipManager) {
        super(frame, SystemUtil.getResourceString("TransferSlip"), true);
        this.ownerFrame = frame;
        if (transferSlip == null) {
            throw new NullPointerException("Slip data is null.");
        }
        this.slip = transferSlip;
        this.backupSlip = transferSlip.getCopy();
        this.manager = slipManager;
        SystemInfo systemInfo = this.manager.getParent();
        this.project = systemInfo.getProjectManager().getProjectData(transferSlip.getPid());
        this.user = systemInfo.getSecurityManager().getUserManager().getUser(transferSlip.getUid());
        this.setupGui();
        this.pack();
        SubjectsUtil.setCenter(this);
    }

    private void setupGui() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(7, 7));
        Box box = new Box(1);
        JPanel jPanel = new JPanel(new FlowLayout(20));
        JLabel jLabel = new JLabel(SystemUtil.getResourceString("TransferSlip"));
        jLabel.setFont(new Font("Serif", 0, 36));
        box.add(jLabel);
        box.add(jPanel);
        this.userLabel = new JTextField(this.user.getName());
        this.userLabel.setEditable(false);
        jPanel.add(this.setCompProperty(this.userLabel, SystemUtil.getResourceString("User")));
        this.projectLabel = new JTextField(this.project.getName());
        this.projectLabel.setEditable(false);
        jPanel.add(this.setCompProperty(this.projectLabel, SystemUtil.getResourceString("Project")));
        this.yearLabel = new JTextField(Integer.toString(this.slip.getYear()));
        this.yearLabel.setEditable(false);
        jPanel.add(this.setCompProperty(this.yearLabel, SystemUtil.getResourceString("CurrentYear")));
        this.dateField = new DateComponent(this.slip.getDate(), SystemUtil.getResourceString("Date"), false);
        jPanel.add(this.setCompProperty(this.dateField, SystemUtil.getResourceString("Date")));
        this.rnText = new JTextField(5);
        this.rnText.setText(Integer.toString(this.slip.getReceiptNumber()));
        jPanel.add(this.setCompProperty(this.rnText, SystemUtil.getResourceString("ReceiptNumber")));
        container.add((Component)box, "North");
        container.add(this.makeTable(), "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(SystemUtil.getResourceString("Ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTransferSlipEdit.this.onOk();
            }
        });
        JButton jButton2 = new JButton(SystemUtil.getResourceString("Cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTransferSlipEdit.this.onCancel();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        container.add((Component)jPanel2, "South");
    }

    private JComponent setCompProperty(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(jComponent);
        return jPanel;
    }

    public boolean isOk() {
        return this.ok;
    }

    Component makeTable() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.table = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.table, 1);
        this.table.setLayout(boxLayout);
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel jPanel2 = new JPanel();
        this.radd = new JButton(SystemUtil.getResourceString("AddRight"));
        this.radd.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward24.gif")));
        this.ladd = new JButton(SystemUtil.getResourceString("AddLeft"));
        this.ladd.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back24.gif")));
        this.radd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTransferSlipEdit.this.onRadd();
            }
        });
        this.ladd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTransferSlipEdit.this.onLadd();
            }
        });
        jPanel2.add(this.ladd);
        jPanel2.add(Box.createHorizontalStrut(30));
        jPanel2.add(this.radd);
        jPanel.add((Component)jPanel2, "South");
        this.updateFromDataLines();
        return jPanel;
    }

    void onRadd() {
        this.updateFromComps();
        this.slip.addLine("", null, new SlipElement(-1, 0L));
        this.updateFromDataLines();
    }

    void onLadd() {
        this.updateFromComps();
        this.slip.addLine("", new SlipElement(-1, 0L), null);
        this.updateFromDataLines();
    }

    void updateFromDataLines() {
        this.radd.setEnabled(true);
        this.ladd.setEnabled(true);
        if (this.table != null) {
            this.table.removeAll();
        }
        if (this.lines == null) {
            this.lines = new LinkedList();
        } else {
            this.lines.clear();
        }
        JPanel jPanel = new JPanel(new FlowLayout(0));
        int n = 0;
        while (n < this.titles.length) {
            JTextField jTextField = new JTextField(this.titles[n], this.columns[n]);
            jTextField.setEnabled(false);
            jPanel.add(jTextField);
            ++n;
        }
        jPanel.add(new Label("---"));
        this.table.add(jPanel);
        int n2 = 0;
        while (n2 < this.slip.getLines().size()) {
            LineComponent lineComponent = new LineComponent(this.slip.getASlipLine(n2));
            this.table.add(lineComponent);
            this.lines.add(lineComponent);
            ++n2;
        }
        this.pack();
    }

    void onCancel() {
        this.dispose();
        this.backupSlip.copyTo(this.slip);
    }

    void onOk() {
        Date date = this.dateField.getDate();
        if (date == null) {
            return;
        }
        this.slip.setDate(date);
        try {
            String string = this.rnText.getText();
            this.slip.setReceiptNumber(Integer.parseInt(StringUtil.transform(string)));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("ReceiptNumberWrongMessage"));
            return;
        }
        if (!this.updateFromComps()) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("SlipWrongMessage"));
            return;
        }
        this.project.setCurReceiptNumber(this.slip.getReceiptNumber());
        this.ok = true;
        this.dispose();
    }

    boolean updateFromComps() {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < this.lines.size()) {
            LineComponent lineComponent = (LineComponent)this.lines.get(n);
            if (!lineComponent.updateFromComp()) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.lines.size()) {
            ASlipLine aSlipLine = this.slip.getASlipLine(n2);
            if (aSlipLine.existLeft()) {
                l += aSlipLine.getLeft().getMoney();
            }
            if (aSlipLine.existRight()) {
                l2 += aSlipLine.getRight().getMoney();
            }
            ++n2;
        }
        if (l != l2) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("TotalAmountWrongMessage"));
            return false;
        }
        return true;
    }

    class LineComponent
    extends JPanel {
        JTextField[] texts;
        ASlipLine aline;

        LineComponent(ASlipLine aSlipLine) {
            super(new FlowLayout(0));
            this.aline = aSlipLine;
            this.texts = new JTextField[DTransferSlipEdit.this.titles.length];
            int n = 0;
            while (n < DTransferSlipEdit.this.titles.length) {
                this.texts[n] = new JTextField(DTransferSlipEdit.this.columns[n]);
                this.add(this.texts[n]);
                ++n;
            }
            JButton jButton = new JButton(SystemUtil.getResourceString("Del"));
            jButton.setForeground(Color.red);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LineComponent this$1;
                {
                    this.this$1 = lineComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.onDelThis();
                }
            });
            this.add(jButton);
            if (aSlipLine.getForward() == null) {
                jButton.setEnabled(false);
            }
            this.updateFromData();
        }

        void onDelThis() {
            DTransferSlipEdit.this.updateFromComps();
            Object[] objectArray = new String[]{this.aline.getSummary()};
            String string = MessageFormat.format(SystemUtil.getResourceString("RemoveLineConfirm"), objectArray);
            int n = JOptionPane.showConfirmDialog(this, string, SystemUtil.getResourceString("Confirm"), 0);
            if (n == 1) {
                return;
            }
            this.aline.getParent().removeLine(this.aline);
            DTransferSlipEdit.this.updateFromDataLines();
        }

        void updateFromData() {
            String string;
            Subject subject;
            Object object;
            if (this.aline == null) {
                return;
            }
            if (this.aline.existLeft()) {
                object = this.aline.getLeft();
                if (object != null) {
                    subject = DTransferSlipEdit.this.project.getSubject(((SlipElement)object).getId());
                    string = "";
                    if (subject != null) {
                        string = subject.getName();
                    }
                    this.texts[0].setText(string);
                    this.texts[1].setText(DTransferSlipEdit.this.form.format(((SlipElement)object).getMoney()));
                    this.texts[0].addFocusListener(new FocusMan(this.texts[0], (SlipElement)object));
                }
            } else {
                this.texts[0].setEnabled(false);
                this.texts[1].setEnabled(false);
                this.texts[0].setBackground(Color.lightGray);
                this.texts[1].setBackground(Color.lightGray);
                DTransferSlipEdit.this.ladd.setEnabled(false);
            }
            if (this.aline.existRight()) {
                object = this.aline.getRight();
                if (object != null) {
                    subject = DTransferSlipEdit.this.project.getSubject(((SlipElement)object).getId());
                    string = "";
                    if (subject != null) {
                        string = subject.getName();
                    }
                    this.texts[3].setText(string);
                    this.texts[4].setText(DTransferSlipEdit.this.form.format(((SlipElement)object).getMoney()));
                    this.texts[3].addFocusListener(new FocusMan(this.texts[3], (SlipElement)object));
                }
            } else {
                this.texts[3].setEnabled(false);
                this.texts[4].setEnabled(false);
                this.texts[3].setBackground(Color.lightGray);
                this.texts[4].setBackground(Color.lightGray);
                DTransferSlipEdit.this.radd.setEnabled(false);
            }
            this.texts[2].setText(this.aline.getSummary());
            object = SystemUtil.getIMEvent();
            if (object != null) {
                this.texts[2].addFocusListener((FocusListener)object);
            }
            object = new DirectIMFocusListener();
            this.texts[1].addFocusListener((FocusListener)object);
            this.texts[4].addFocusListener((FocusListener)object);
            this.texts[2].addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ LineComponent this$1;
                {
                    this.this$1 = lineComponent;
                }

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        LineComponent.access$000(this.this$1).onOk();
                    }
                }
            });
            this.texts[4].addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ LineComponent this$1;
                {
                    this.this$1 = lineComponent;
                }

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        LineComponent.access$000(this.this$1).onOk();
                    }
                    if (keyEvent.getKeyChar() == ' ') {
                        long l = 0L;
                        int n = 0;
                        while (n < LineComponent.access$000((LineComponent)this.this$1).lines.size()) {
                            LineComponent lineComponent = (LineComponent)LineComponent.access$000((LineComponent)this.this$1).lines.get(n);
                            l += this.this$1.getNumber(lineComponent.texts[1]);
                            ++n;
                        }
                        this.this$1.texts[4].setText(LineComponent.access$000((LineComponent)this.this$1).form.format(l));
                    }
                }
            });
            this.texts[1].addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ LineComponent this$1;
                {
                    this.this$1 = lineComponent;
                }

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        LineComponent.access$000(this.this$1).onOk();
                    }
                    if (keyEvent.getKeyChar() == ' ') {
                        long l = 0L;
                        int n = 0;
                        while (n < LineComponent.access$000((LineComponent)this.this$1).lines.size()) {
                            LineComponent lineComponent = (LineComponent)LineComponent.access$000((LineComponent)this.this$1).lines.get(n);
                            l += this.this$1.getNumber(lineComponent.texts[4]);
                            ++n;
                        }
                        this.this$1.texts[1].setText(LineComponent.access$000((LineComponent)this.this$1).form.format(l));
                    }
                }
            });
        }

        long getNumber(JTextField jTextField) {
            if (jTextField == null) {
                return 0L;
            }
            long l = 0L;
            try {
                l = DTransferSlipEdit.this.form.parse(StringUtil.transform(jTextField.getText())).longValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return l;
        }

        boolean updateFromComp() {
            this.aline.setSummary(this.texts[2].getText());
            try {
                if (this.aline.existLeft()) {
                    this.aline.getLeft().setMoney(this.getNumber(this.texts[1]));
                    if (this.aline.getLeft().getId() == -1) {
                        return false;
                    }
                }
                if (this.aline.existRight()) {
                    this.aline.getRight().setMoney(this.getNumber(this.texts[4]));
                    if (this.aline.getRight().getId() == -1) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{this.aline.getSummary()};
                String string = MessageFormat.format(SystemUtil.getResourceString("WrongMoneyMessage"), objectArray);
                JOptionPane.showMessageDialog(this, string);
                return false;
            }
            return true;
        }

        class FocusMan
        implements FocusListener {
            JTextField f_text;
            SlipElement f_slip;

            FocusMan(JTextField jTextField, SlipElement slipElement) {
                this.f_text = jTextField;
                this.f_slip = slipElement;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.f_text.transferFocus();
                DSubjectSelect dSubjectSelect = new DSubjectSelect(((LineComponent)LineComponent.this).DTransferSlipEdit.this.ownerFrame, ((LineComponent)LineComponent.this).DTransferSlipEdit.this.project);
                dSubjectSelect.show();
                if (dSubjectSelect.isOk()) {
                    this.f_slip.setId(dSubjectSelect.getId());
                    this.f_text.setText(((LineComponent)LineComponent.this).DTransferSlipEdit.this.project.getSubject(dSubjectSelect.getId()).getName());
                }
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        }
    }
}

