/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ProjectData;
import arg.money.SecurityManager;
import arg.money.SessionData;
import arg.money.SlipManager;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.UserData;
import arg.money.gui.AbstractReportPanel;
import arg.money.gui.GroupReportPanel;
import arg.money.gui.PReport;
import arg.money.gui.SubjectsUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.frame.CView;
import jp.gr.java_conf.ccs2.frame.Document;

public class FReport
extends JFrame
implements MessageListener {
    SlipManager manager;
    UserData user;
    SessionData session;
    int[] parray;
    AbstractReportPanel[] preport;
    CView view;
    JTabbedPane reportPanel;

    public FReport(SlipManager slipManager, SessionData sessionData, Document document) {
        this.initGui();
        this.setDocument(document);
        SystemInfo systemInfo = slipManager.getParent();
        this.manager = slipManager;
        this.session = sessionData;
        this.user = systemInfo.getSecurityManager().getUserManager().getUser(sessionData.getUid());
        this.initData();
        this.pack();
        SubjectsUtil.setCenter(this);
    }

    ProjectData getProjectData(int n) {
        return this.manager.getParent().getProjectManager().getProjectData(n);
    }

    void initData() {
        this.reportPanel.removeAll();
        SystemInfo systemInfo = this.manager.getParent();
        SecurityManager securityManager = systemInfo.getSecurityManager();
        List list = securityManager.getPermittedProjects(this.user.getId(), 1);
        Object[] objectArray = list.toArray();
        this.parray = new int[objectArray.length + 1];
        this.preport = new AbstractReportPanel[objectArray.length + 1];
        int n = 0;
        while (n < this.parray.length - 1) {
            this.parray[n] = ((ProjectData)objectArray[n]).getId();
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/History24.gif"));
            this.preport[n] = new PReport(this.parray[n], this.manager);
            this.reportPanel.addTab(this.getProjectData(this.parray[n]).getName(), imageIcon, this.preport[n]);
            ++n;
        }
        this.preport[objectArray.length] = new GroupReportPanel(this.manager);
        this.parray[objectArray.length] = -1;
        this.reportPanel.addTab(SystemUtil.getResourceString("ConsolidatedAccounts"), null, this.preport[objectArray.length]);
    }

    private void initGui() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FReport.this.onExit();
            }
        });
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(SystemUtil.getResourceString("Print"));
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Print24.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FReport.this.onPrint();
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "North");
        this.reportPanel = new JTabbedPane();
        this.getContentPane().add((Component)this.reportPanel, "Center");
    }

    void onPrint() {
        int n = this.reportPanel.getSelectedIndex();
        if (n >= 0) {
            this.preport[n].print();
        }
    }

    void setDocument(Document document) {
        this.view = new CView(document){

            public void update(Object object) {
                if (object == null) {
                    FReport.this.onExit();
                    return;
                }
                int n = (Integer)object;
                FReport.this.updateContents(n);
            }
        };
    }

    public void updateContents(int n) {
        if (n < 0) {
            this.initData();
            return;
        }
        int n2 = this.reportPanel.getSelectedIndex();
        if (this.parray[n2] == n || n < 0) {
            this.preport[n2].update();
        }
        this.preport[this.preport.length - 1].update();
    }

    void onExit() {
        this.dispose();
    }

    public void message(String string, int n, Object object) {
    }
}

