/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ProjectData;
import arg.money.SecurityManager;
import arg.money.SessionData;
import arg.money.SlipManager;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.gui.PProjectPanel;
import arg.money.gui.SearchPanel;
import arg.money.gui.SubjectsUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.gr.java_conf.ccs2.frame.CView;
import jp.gr.java_conf.ccs2.frame.Document;

public class FSlipExplorer
extends JFrame {
    SlipManager manager;
    SessionData session;
    CView view;
    int[] parray;
    PProjectPanel[] ppjarray;
    private JPanel jPanel1;
    private JButton inputButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton findButton;
    private JButton printButton;
    private JButton exitButton;
    private JTabbedPane projectPanel;

    public FSlipExplorer(SlipManager slipManager, SessionData sessionData, Document document) {
        this();
        this.setDocument(document);
        SystemInfo systemInfo = slipManager.getParent();
        this.manager = slipManager;
        this.session = sessionData;
        this.initData();
        Object[] objectArray = new String[]{this.session.getUser().getName()};
        this.setTitle(MessageFormat.format(SystemUtil.getResourceString("FSlipExplorerTitle"), objectArray));
        this.pack();
        SubjectsUtil.setCenter(this);
    }

    void setDocument(Document document) {
        this.view = new CView(document){

            public void update(Object object) {
                if (object == null) {
                    FSlipExplorer.this.onExit();
                    return;
                }
                int n = (Integer)object;
                FSlipExplorer.this.updateContents(n);
            }
        };
    }

    void updateContents(int n) {
        if (n < 0) {
            this.initData();
            return;
        }
        int n2 = this.projectPanel.getSelectedIndex();
        if (this.parray[n2] == n) {
            this.ppjarray[n2].initData();
        }
    }

    void onExit() {
        this.dispose();
    }

    ProjectData getProjectData(int n) {
        return this.manager.getParent().getProjectManager().getProjectData(n);
    }

    void initData() {
        this.projectPanel.removeAll();
        SystemInfo systemInfo = this.manager.getParent();
        SecurityManager securityManager = systemInfo.getSecurityManager();
        SlipManager slipManager = systemInfo.getSlipManager();
        List list = securityManager.getPermittedProjects(this.session.getUid(), 1);
        Object[] objectArray = list.toArray();
        this.parray = new int[objectArray.length];
        this.ppjarray = new PProjectPanel[objectArray.length];
        int n = 0;
        while (n < this.parray.length) {
            ImageIcon imageIcon;
            this.parray[n] = ((ProjectData)objectArray[n]).getId();
            boolean bl = true;
            if (securityManager.getPermission(this.session, this.parray[n], 2)) {
                imageIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif"));
            } else {
                imageIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/PrintPreview24.gif"));
                bl = false;
            }
            this.ppjarray[n] = new PProjectPanel(this, this.parray[n], slipManager, this.session, bl);
            this.projectPanel.addTab(this.getProjectData(this.parray[n]).getName(), imageIcon, this.ppjarray[n]);
            ++n;
        }
    }

    protected FSlipExplorer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.inputButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.findButton = new JButton();
        this.printButton = new JButton();
        this.exitButton = new JButton();
        this.projectPanel = new JTabbedPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FSlipExplorer.this.exitForm(windowEvent);
            }
        });
        this.inputButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New24.gif")));
        this.inputButton.setText(SystemUtil.getResourceString("InputTS"));
        this.inputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FSlipExplorer.this.inputButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.inputButton);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif")));
        this.editButton.setText(SystemUtil.getResourceString("Modify"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FSlipExplorer.this.editButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.editButton);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif")));
        this.removeButton.setText(SystemUtil.getResourceString("Delete"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FSlipExplorer.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.removeButton);
        this.findButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Find24.gif")));
        this.findButton.setText(SystemUtil.getResourceString("Find"));
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FSlipExplorer.this.findButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.findButton);
        this.printButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Print24.gif")));
        this.printButton.setText(SystemUtil.getResourceString("Print"));
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FSlipExplorer.this.printButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.printButton);
        this.exitButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
        this.exitButton.setText(SystemUtil.getResourceString("Exit"));
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FSlipExplorer.this.exitButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.exitButton);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.projectPanel, "Center");
    }

    private void printButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.projectPanel.getSelectedIndex();
        if (n < 0 || n >= this.parray.length) {
            return;
        }
        this.ppjarray[n].print();
    }

    private void findButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = new JFrame(SystemUtil.getResourceString("SearchFrame"));
        jFrame.getContentPane().add((Component)new SearchPanel(jFrame, this.manager.getParent(), this.session, this.view.getDocument()), "Center");
        ((Component)jFrame).setSize(650, 700);
        jFrame.show();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        PProjectPanel pProjectPanel = this.editCheck();
        if (pProjectPanel == null) {
            return;
        }
        pProjectPanel.onDelete();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        PProjectPanel pProjectPanel = this.editCheck();
        if (pProjectPanel == null) {
            return;
        }
        pProjectPanel.onModify();
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.onExit();
    }

    private void inputButtonActionPerformed(ActionEvent actionEvent) {
        PProjectPanel pProjectPanel = this.editCheck();
        if (pProjectPanel == null) {
            return;
        }
        pProjectPanel.onAdd();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.onExit();
    }

    PProjectPanel editCheck() {
        int n = this.projectPanel.getSelectedIndex();
        if (n < 0 || n >= this.parray.length) {
            return null;
        }
        ProjectData projectData = this.getProjectData(this.parray[n]);
        int n2 = projectData.getId();
        boolean bl = this.manager.getParent().getSecurityManager().getPermission(this.session, n2, 2);
        if (!bl) {
            String string = SystemUtil.getResourceString("DontHaveWritablePermission");
            JOptionPane.showMessageDialog(this, string);
            return null;
        }
        return this.ppjarray[n];
    }

    public static void main(String[] stringArray) {
        new FSlipExplorer().show();
    }
}

