/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.AnnualData;
import arg.money.SlipManager;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.gui.AbstractReportPanel;
import arg.money.gui.TGroupBalance;
import arg.money.gui.TGroupProfitLoss;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class GroupReportPanel
extends AbstractReportPanel {
    SystemInfo info;
    int year;
    TGroupProfitLoss plTable;
    TGroupBalance balanceTable;
    JTabbedPane tab;
    JComboBox yearComboBox;

    public GroupReportPanel(SlipManager slipManager) {
        this.info = slipManager.getParent();
        this.setupGui();
    }

    void setupGui() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel(SystemUtil.getResourceString("ConsolidatedAccounts"));
        jLabel.setForeground(Color.black);
        jLabel.setFont(new Font("Serif", 0, 18));
        jLabel.setForeground(Color.red);
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, "North");
        JLabel jLabel2 = new JLabel(SystemUtil.getResourceString("ConsolidatedAccountsComment"));
        jLabel2.setForeground(Color.white);
        jLabel2.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel2, "Center");
        JPanel jPanel2 = new JPanel();
        this.yearComboBox = new JComboBox();
        this.yearComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GroupReportPanel.this.yearChanged();
            }
        });
        this.yearComboBox.setBorder(new TitledBorder(SystemUtil.getResourceString("CurrentYear")));
        Integer[] integerArray = this.getRuningYears();
        int n = 0;
        while (n < integerArray.length) {
            this.yearComboBox.addItem(integerArray[n]);
            ++n;
        }
        jPanel2.add(this.yearComboBox);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "North");
        this.tab = new JTabbedPane();
        this.plTable = new TGroupProfitLoss(this.info, this.getSelectedYear());
        this.balanceTable = new TGroupBalance(this.info, this.getSelectedYear());
        this.tab.addTab(SystemUtil.getResourceString("BalanceTable"), new JScrollPane(this.balanceTable));
        this.tab.addTab(SystemUtil.getResourceString("ProfitLossTable"), new JScrollPane(this.plTable));
        this.add((Component)this.tab, "Center");
    }

    Integer[] getRuningYears() {
        Integer[] integerArray;
        int n = -1;
        int n2 = -1;
        List list = this.info.getProjectManager().getProjects();
        int n3 = 0;
        while (n3 < list.size()) {
            integerArray = (Integer[])list.get(n3);
            List list2 = integerArray.getAnnuals();
            int n4 = 0;
            while (n4 < list2.size()) {
                AnnualData annualData = (AnnualData)list2.get(n4);
                if (annualData.getYear() < n || n == -1) {
                    n = annualData.getYear();
                }
                if (annualData.getYear() > n2 || n2 == -1) {
                    n2 = annualData.getYear();
                }
                ++n4;
            }
            ++n3;
        }
        if (n2 == -1 || n == -1) {
            SystemUtil.logMessage("invalid annual year in GroupReportPanel.");
            n2 = n = SystemUtil.getYear();
        }
        integerArray = new Integer[n2 - n + 1];
        int n5 = 0;
        while (n5 < integerArray.length) {
            integerArray[n5] = new Integer(n + n5);
            ++n5;
        }
        return integerArray;
    }

    void yearChanged() {
        try {
            Integer n = (Integer)this.yearComboBox.getSelectedItem();
            int n2 = n;
            this.plTable.setYear(n2);
            this.balanceTable.setYear(n2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    int getSelectedYear() {
        Integer n = (Integer)this.yearComboBox.getSelectedItem();
        if (n == null) {
            SystemUtil.logMessage("invalid selected year in GroupReportPanel.");
            n = new Integer(SystemUtil.getYear());
        }
        return n;
    }

    public void update() {
        this.plTable.update();
        this.balanceTable.update();
    }

    public void print() {
        int n = this.tab.getSelectedIndex();
        if (n == 0) {
            this.balanceTable.print();
        }
        if (n == 1) {
            this.plTable.print();
        }
    }
}

