/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ASlipLine;
import arg.money.AmountData;
import arg.money.AnnualData;
import arg.money.CurrentAmountData;
import arg.money.DataLockingException;
import arg.money.ProjectData;
import arg.money.ProjectManager;
import arg.money.SessionData;
import arg.money.SlipElement;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectMoney;
import arg.money.SystemUtil;
import arg.money.TransferSlip;
import arg.money.gui.CellManager;
import arg.money.gui.DTransferSlipEdit;
import arg.money.gui.MyCellRender;
import arg.money.gui.SubjectsUtil;
import arg.money.print.TablePrinter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class PProjectPanel
extends JPanel
implements CellManager {
    Frame parent;
    int pid;
    ProjectManager projects;
    SlipManager slipManager;
    SessionData session;
    boolean writable = true;
    SubjectsUtil utils;
    int curSubjectId = -1;
    NumberFormat form = NumberFormat.getInstance();
    MessageFormat keyform = new MessageFormat("y{0}p{1}s{2}");
    Map modelStore = new HashMap();
    List elements;
    List slips;
    String[] titles = new String[]{SystemUtil.getResourceString("Date"), SystemUtil.getResourceString("ReceiptNo"), SystemUtil.getResourceString("Subject"), SystemUtil.getResourceString("Summary"), SystemUtil.getResourceString("Credit"), SystemUtil.getResourceString("Debit"), SystemUtil.getResourceString("Amount")};
    String[] aligns = new String[]{"c", "c", "c", "l", "r", "r", "r"};
    private JPanel jPanel1;
    private JLabel titleLabel;
    private JLabel commentLabel;
    private JPanel jPanel2;
    private JPanel groupPanel;
    private JScrollPane jScrollPane5;
    private JList groupList;
    private JPanel subgroupPanel;
    private JScrollPane jScrollPane6;
    private JList subgroupList;
    private JPanel subjectPanel;
    private JScrollPane jScrollPane7;
    private JList subjectList;
    private JPanel tsPanel;
    private JScrollPane jScrollPane8;
    private JTable slipTable;
    private JPanel amountPanel;
    private JPanel creditPanel;
    private JTextField leftAmount;
    private JPanel debtorPanel;
    private JTextField rightAmount;
    private JPanel totalPanel;
    private JTextField totalAmount;
    private JPanel jPanel3;
    private JLabel subjectLabel;
    private JLabel subjectCommentLabel;

    public PProjectPanel(Frame frame, int n, SlipManager slipManager, SessionData sessionData, boolean bl) {
        this();
        this.parent = frame;
        this.session = sessionData;
        this.pid = n;
        this.slipManager = slipManager;
        this.writable = bl;
        this.initData();
        this.slipTable.setRowMargin(4);
        this.slipTable.setSelectionMode(0);
        this.slipTable.setAutoResizeMode(2);
        this.slipTable.setDefaultRenderer("".getClass(), new MyCellRender(this, this.aligns));
    }

    public ProjectData getProjectData() {
        return this.slipManager.getParent().getProjectManager().getProjectData(this.pid);
    }

    void initData() {
        ProjectData projectData = this.getProjectData();
        if (this.utils == null) {
            this.utils = new SubjectsUtil(projectData, this.groupList, this.subgroupList, this.subjectList, new MessageListener(){

                public void message(String string, int n, Object object) {
                    if (PProjectPanel.this.curSubjectId == -1) {
                        PProjectPanel.this.updateTable(n);
                    }
                }
            });
        } else {
            this.curSubjectId = this.utils.getSelectedSubject().getId();
            this.utils.update(projectData, this.curSubjectId);
            this.updateTable(this.curSubjectId);
        }
        this.commentLabel.setText(projectData.getComment());
        this.titleLabel.setText(projectData.getName());
        this.subjectLabel.setText(this.utils.getSelectedSubject().getName());
        this.leftAmount.setBackground(Color.white);
        this.rightAmount.setBackground(Color.white);
        this.totalAmount.setBackground(new Color(0xE0FFFF));
    }

    public void updateExt() {
        this.curSubjectId = this.utils.getSelectedSubject().getId();
        this.utils.updateGroupList();
        this.modelStore.clear();
        this.utils.setSelectedSubject(this.curSubjectId);
        this.updateTable(this.curSubjectId);
        this.curSubjectId = -1;
        ProjectData projectData = this.getProjectData();
        this.slipManager.modify(projectData.getCurYear(), projectData.getId());
    }

    public TransferSlip getSelectedSlip() {
        int n = this.slipTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        TableModel tableModel = this.slipTable.getModel();
        if (tableModel instanceof SlipModel) {
            SlipModel slipModel = (SlipModel)tableModel;
            return slipModel.getSlip(n);
        }
        return null;
    }

    boolean securityCheck() {
        boolean bl = this.slipManager.getParent().getSecurityManager().getPermission(this.session, this.pid, 2);
        if (!bl) {
            String string = SystemUtil.getResourceString("DontHaveWritablePermission");
            JOptionPane.showMessageDialog(this, string);
            return false;
        }
        return true;
    }

    public void onModify() {
        if (!this.securityCheck()) {
            return;
        }
        TransferSlip transferSlip = this.getSelectedSlip();
        if (transferSlip == null) {
            return;
        }
        try {
            transferSlip = this.slipManager.lockSlip(transferSlip.getYear(), transferSlip.getPid(), transferSlip.getId());
        }
        catch (DataLockingException dataLockingException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("SlipLockError"));
            return;
        }
        if (transferSlip == null) {
            System.out.println("null slip error");
            return;
        }
        DTransferSlipEdit dTransferSlipEdit = new DTransferSlipEdit(this.parent, transferSlip, this.slipManager);
        dTransferSlipEdit.show();
        if (dTransferSlipEdit.isOk()) {
            transferSlip.setUid(this.session.getUid());
            this.slipManager.comitSlip(transferSlip);
        } else {
            this.slipManager.cancelSlip(transferSlip);
        }
    }

    public void onDelete() {
        Object[] objectArray;
        if (!this.securityCheck()) {
            return;
        }
        TransferSlip transferSlip = this.getSelectedSlip();
        if (transferSlip == null) {
            return;
        }
        try {
            this.slipManager.lockSlip(transferSlip.getYear(), transferSlip.getPid(), transferSlip.getId());
        }
        catch (DataLockingException dataLockingException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("SlipLockError"));
            return;
        }
        List list = transferSlip.getLines();
        if (list.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            objectArray = (Object[])list.get(n);
            if (objectArray != null) {
                stringBuffer.append(objectArray.getSummary()).append(" ");
            }
            ++n;
        }
        objectArray = new Object[]{StringUtil.datej(transferSlip.getDate()), this.slipManager.getParent().getSecurityManager().getUserManager().getUser(transferSlip.getUid()), new Integer(list.size()), stringBuffer.toString()};
        Object[] objectArray2 = new Object[]{MessageFormat.format(SystemUtil.getResourceString("TransferSlipExpression"), objectArray)};
        String string = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"), objectArray2);
        int n2 = JOptionPane.showConfirmDialog(this, string, SystemUtil.getResourceString("Confirm"), 0);
        if (n2 == 0) {
            this.slipManager.removeSlip(transferSlip.getYear(), transferSlip.getPid(), transferSlip.getId());
            return;
        }
        this.slipManager.cancelSlip(transferSlip);
    }

    public void onAdd() {
        if (!this.securityCheck()) {
            return;
        }
        ProjectData projectData = this.getProjectData();
        TransferSlip transferSlip = this.slipManager.makeSlip(projectData, this.session.getUid());
        DTransferSlipEdit dTransferSlipEdit = new DTransferSlipEdit(this.parent, transferSlip, this.slipManager);
        dTransferSlipEdit.show();
        if (dTransferSlipEdit.isOk()) {
            this.slipManager.comitSlip(transferSlip);
        }
    }

    public void print() {
        ProjectData projectData = this.getProjectData();
        Object[] objectArray = new Object[]{projectData.getName(), new Integer(projectData.getCurYear()), SystemUtil.getResourceString("SlipList"), this.utils.getSelectedSubject().getName()};
        String string = MessageFormat.format(SystemUtil.getResourceString("SubjectSheetTitle"), objectArray);
        String[] stringArray = new String[]{"c", "c", "c", "c", "r", "r", "r"};
        int[] nArray = new int[]{12, 12, 12, 12, 16, 16, 16};
        TablePrinter tablePrinter = new TablePrinter(string, this.slipTable, stringArray, nArray, null);
        tablePrinter.print();
    }

    void updateTable(int n) {
        Object object;
        ProjectData projectData = this.getProjectData();
        Object[] objectArray = new Object[]{new Integer(projectData.getCurYear()), new Integer(projectData.getId()), new Integer(n)};
        String string = this.keyform.format(objectArray);
        TableModel tableModel = (TableModel)this.modelStore.get(string);
        if (tableModel == null) {
            object = this.slipManager.query(projectData.getCurYear(), projectData.getId());
            this.slipManager.queryBySubject(n, n, (List)object);
            tableModel = new SlipModel(projectData.getSubject(n), this.slipManager.getList((List)object));
        }
        this.slipTable.setModel(tableModel);
        this.slipTable.sizeColumnsToFit(-1);
        this.subjectLabel.setText(projectData.getSubject(n).getName());
        this.subjectCommentLabel.setText(projectData.getSubject(n).getComment());
        object = projectData.getAnnual(projectData.getCurYear()).getCurrentMoney(n).getAmounts(this.slipManager);
        this.leftAmount.setText(this.form.format(((AmountData)object).getCreditAmount()));
        this.rightAmount.setText(this.form.format(((AmountData)object).getDebitAmount()));
        this.totalAmount.setText(this.form.format(((CurrentAmountData)object).getCurrentAmount()));
    }

    public boolean isStrongCell(int n, int n2) {
        try {
            SElement sElement = (SElement)this.elements.get(n);
            boolean bl = sElement.getSlip().isLocked();
            return bl;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return false;
        }
    }

    protected PProjectPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.commentLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.groupPanel = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.groupList = new JList();
        this.subgroupPanel = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.subgroupList = new JList();
        this.subjectPanel = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.subjectList = new JList();
        this.tsPanel = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.slipTable = new JTable();
        this.amountPanel = new JPanel();
        this.creditPanel = new JPanel();
        this.leftAmount = new JTextField();
        this.debtorPanel = new JPanel();
        this.rightAmount = new JTextField();
        this.totalPanel = new JPanel();
        this.totalAmount = new JTextField();
        this.jPanel3 = new JPanel();
        this.subjectLabel = new JLabel();
        this.subjectCommentLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(2, 1, 5, 0));
        this.titleLabel.setAlignmentX(0.1f);
        this.titleLabel.setText("jLabel1");
        this.titleLabel.setForeground(Color.black);
        this.titleLabel.setFont(new Font("Serif", 0, 18));
        this.jPanel1.add(this.titleLabel);
        this.commentLabel.setAlignmentX(0.1f);
        this.commentLabel.setText("jLabel2");
        this.commentLabel.setForeground(Color.white);
        this.jPanel1.add(this.commentLabel);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.groupPanel.setLayout(new BorderLayout());
        this.groupPanel.setBorder(new TitledBorder("Group"));
        SubjectsUtil.borderTitle(this.groupPanel, SystemUtil.getResourceString("Group"));
        this.groupList.setFixedCellWidth(150);
        this.groupList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                PProjectPanel.this.groupListKeyPressed(keyEvent);
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PProjectPanel.this.groupListValueChanged(listSelectionEvent);
            }
        });
        this.groupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PProjectPanel.this.groupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane5.setViewportView(this.groupList);
        this.groupPanel.add((Component)this.jScrollPane5, "Center");
        this.jPanel2.add(this.groupPanel);
        this.subgroupPanel.setLayout(new BorderLayout());
        this.subgroupPanel.setBorder(new TitledBorder("Subgroup"));
        SubjectsUtil.borderTitle(this.subgroupPanel, SystemUtil.getResourceString("Subgroup"));
        this.subgroupList.setFixedCellWidth(150);
        this.subgroupList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                PProjectPanel.this.subgroupListKeyPressed(keyEvent);
            }
        });
        this.subgroupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PProjectPanel.this.subgroupListValueChanged(listSelectionEvent);
            }
        });
        this.subgroupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PProjectPanel.this.subgroupListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane6.setViewportView(this.subgroupList);
        this.subgroupPanel.add((Component)this.jScrollPane6, "Center");
        this.jPanel2.add(this.subgroupPanel);
        this.subjectPanel.setLayout(new BorderLayout());
        this.subjectPanel.setBorder(new TitledBorder("Subject"));
        SubjectsUtil.borderTitle(this.subjectPanel, SystemUtil.getResourceString("Subject"));
        this.subjectList.setFixedCellWidth(150);
        this.subjectList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                PProjectPanel.this.subjectListKeyPressed(keyEvent);
            }
        });
        this.subjectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PProjectPanel.this.subjectListValueChanged(listSelectionEvent);
            }
        });
        this.subjectList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PProjectPanel.this.subjectListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane7.setViewportView(this.subjectList);
        this.subjectPanel.add((Component)this.jScrollPane7, "Center");
        this.jPanel2.add(this.subjectPanel);
        this.add((Component)this.jPanel2, "West");
        this.tsPanel.setLayout(new BorderLayout());
        this.tsPanel.setBorder(new TitledBorder("Transfer Slips"));
        SubjectsUtil.borderTitle(this.tsPanel, SystemUtil.getResourceString("TransferSlips"));
        this.slipTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                PProjectPanel.this.slipTableKeyPressed(keyEvent);
            }
        });
        this.slipTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PProjectPanel.this.slipTableMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane8.setViewportView(this.slipTable);
        this.tsPanel.add((Component)this.jScrollPane8, "Center");
        this.amountPanel.setLayout(new BoxLayout(this.amountPanel, 0));
        this.amountPanel.setBorder(new TitledBorder("Amount"));
        SubjectsUtil.borderTitle(this.amountPanel, SystemUtil.getResourceString("Amount"));
        this.creditPanel.setBorder(new TitledBorder("Credit"));
        SubjectsUtil.borderTitle(this.creditPanel, SystemUtil.getResourceString("CreditAmount"));
        this.leftAmount.setDisabledTextColor(Color.white);
        this.leftAmount.setEditable(false);
        this.leftAmount.setColumns(14);
        this.leftAmount.setText("jTextField1");
        this.creditPanel.add(this.leftAmount);
        this.amountPanel.add(this.creditPanel);
        this.debtorPanel.setBorder(new TitledBorder("Debtor"));
        SubjectsUtil.borderTitle(this.debtorPanel, SystemUtil.getResourceString("DebtorAmount"));
        this.rightAmount.setDisabledTextColor(Color.white);
        this.rightAmount.setEditable(false);
        this.rightAmount.setColumns(14);
        this.rightAmount.setText("jTextField2");
        this.debtorPanel.add(this.rightAmount);
        this.amountPanel.add(this.debtorPanel);
        this.totalPanel.setBorder(new TitledBorder("Total"));
        SubjectsUtil.borderTitle(this.totalPanel, SystemUtil.getResourceString("TotalAmount"));
        this.totalAmount.setDisabledTextColor(Color.white);
        this.totalAmount.setEditable(false);
        this.totalAmount.setColumns(14);
        this.totalAmount.setText("jTextField3");
        this.totalPanel.add(this.totalAmount);
        this.amountPanel.add(this.totalPanel);
        this.tsPanel.add((Component)this.amountPanel, "South");
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.subjectLabel.setText("jLabel1");
        this.subjectLabel.setForeground(Color.yellow);
        this.subjectLabel.setFont(new Font("SansSerif", 0, 24));
        this.jPanel3.add(this.subjectLabel);
        this.subjectCommentLabel.setText("jLabel1");
        this.subjectCommentLabel.setForeground(Color.white);
        this.jPanel3.add(this.subjectCommentLabel);
        this.tsPanel.add((Component)this.jPanel3, "North");
        this.add((Component)this.tsPanel, "Center");
    }

    private void slipTableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.onModify();
        }
    }

    private void slipTableKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.subjectList.requestFocus();
        }
    }

    private void subjectListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.subgroupList.requestFocus();
        }
        if (keyEvent.getKeyCode() == 39) {
            this.slipTable.requestFocus();
        }
    }

    private void subjectListMouseClicked(MouseEvent mouseEvent) {
        this.updateTable(this.utils.getSelectedSubject().getId());
    }

    private void subjectListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateTable(this.utils.getSelectedSubject().getId());
    }

    private void subgroupListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.groupList.requestFocus();
        }
        if (keyEvent.getKeyCode() == 39) {
            this.subjectList.requestFocus();
        }
    }

    private void subgroupListMouseClicked(MouseEvent mouseEvent) {
        this.utils.updateSubjectList();
    }

    private void subgroupListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.utils.updateSubjectList();
    }

    private void groupListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 39) {
            this.subgroupList.requestFocus();
        }
    }

    private void groupListMouseClicked(MouseEvent mouseEvent) {
        this.utils.updateSubgroupList();
    }

    private void groupListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.utils.updateSubgroupList();
    }

    class SElement {
        TransferSlip ts;
        Subject sbj;
        String summary;
        long credit;
        long debit;
        long currentMoney;

        SElement(TransferSlip transferSlip, Subject subject, String string, long l, long l2, long l3) {
            this.ts = transferSlip;
            this.sbj = subject;
            this.summary = string;
            this.credit = l;
            this.debit = l2;
            this.currentMoney = l3;
        }

        TransferSlip getSlip() {
            return this.ts;
        }
    }

    class SlipModel
    extends AbstractTableModel {
        Subject subject;

        SlipModel(Subject subject, List list) {
            this.subject = subject;
            PProjectPanel.this.slips = list;
            ProjectData projectData = PProjectPanel.this.getProjectData();
            AnnualData annualData = projectData.getAnnual(projectData.getCurYear());
            SubjectGroup subjectGroup = projectData.getGroupBySubject(this.subject.getId());
            SubjectMoney subjectMoney = annualData.getInitialMoney(this.subject.getId());
            long l = subjectMoney.getMoney();
            PProjectPanel.this.elements = new ArrayList();
            Iterator iterator = PProjectPanel.this.slips.iterator();
            while (iterator.hasNext()) {
                long l2;
                long l3;
                SlipElement slipElement;
                SlipElement slipElement2;
                ASlipLine aSlipLine;
                TransferSlip transferSlip = (TransferSlip)iterator.next();
                Iterator iterator2 = transferSlip.getSlipLineByLeftSubject(this.subject.getId());
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        aSlipLine = (ASlipLine)iterator2.next();
                        slipElement2 = aSlipLine.getRight();
                        slipElement = aSlipLine.getLeft();
                        l3 = slipElement.getMoney();
                        if (l3 != (l2 = slipElement2.getMoney())) {
                            l3 = Math.min(l3, l2);
                        }
                        PProjectPanel.this.elements.add(new SElement(transferSlip, projectData.getSubject(slipElement2.getId()), aSlipLine.getSummary(), l3, -1L, l += subjectGroup.getTotalAmount(l3, 0L)));
                    }
                }
                if ((iterator2 = transferSlip.getSlipLineByRightSubject(this.subject.getId())) == null) continue;
                while (iterator2.hasNext()) {
                    aSlipLine = (ASlipLine)iterator2.next();
                    slipElement2 = aSlipLine.getRight();
                    slipElement = aSlipLine.getLeft();
                    l3 = slipElement.getMoney();
                    if (l3 != (l2 = slipElement2.getMoney())) {
                        l2 = Math.min(l3, l2);
                    }
                    PProjectPanel.this.elements.add(new SElement(transferSlip, projectData.getSubject(slipElement.getId()), aSlipLine.getSummary(), -1L, l2, l += subjectGroup.getTotalAmount(0L, l2)));
                }
            }
        }

        TransferSlip getSlip(int n) {
            if (n >= 0 && n < PProjectPanel.this.elements.size()) {
                SElement sElement = (SElement)PProjectPanel.this.elements.get(n);
                return sElement.ts;
            }
            return null;
        }

        public int getColumnCount() {
            return PProjectPanel.this.titles.length;
        }

        public Class getColumnClass(int n) {
            if (n >= 0 && n < PProjectPanel.this.titles.length) {
                return "".getClass();
            }
            return super.getColumnClass(n);
        }

        public int getRowCount() {
            return PProjectPanel.this.elements.size();
        }

        public String getColumnName(int n) {
            return PProjectPanel.this.titles[n];
        }

        public Object getValueAt(int n, int n2) {
            SElement sElement = (SElement)PProjectPanel.this.elements.get(n);
            switch (n2) {
                case 0: {
                    if (sElement.getSlip().isLocked()) {
                        return SystemUtil.getResourceString("SlipLocked");
                    }
                    return StringUtil.datel(sElement.ts.getDate());
                }
                case 1: {
                    return new Integer(sElement.ts.getReceiptNumber());
                }
                case 2: {
                    return sElement.sbj.getName();
                }
                case 3: {
                    return sElement.summary;
                }
                case 4: {
                    if (sElement.credit == -1L) {
                        return null;
                    }
                    return PProjectPanel.this.form.format(sElement.credit);
                }
                case 5: {
                    if (sElement.debit == -1L) {
                        return null;
                    }
                    return PProjectPanel.this.form.format(sElement.debit);
                }
                case 6: {
                    return PProjectPanel.this.form.format(sElement.currentMoney);
                }
            }
            return null;
        }
    }
}

