/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.AnnualData;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.SystemUtil;
import arg.money.gui.AbstractReportPanel;
import arg.money.gui.TBalance;
import arg.money.gui.TProfitLoss;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.swing.DateComponent;

public class PReport
extends AbstractReportPanel {
    int pid;
    SlipManager manager;
    TProfitLoss plTable;
    TBalance balanceTable;
    DateComponent startedDate;
    DateComponent closedDate;
    JComboBox yearComboBox;
    JTabbedPane tab;

    public PReport(int n, SlipManager slipManager) {
        this.pid = n;
        this.manager = slipManager;
        this.setupGui();
    }

    ProjectData getProjectData() {
        return this.manager.getParent().getProjectManager().getProjectData(this.pid);
    }

    void setupGui() {
        AnnualData annualData;
        this.setLayout(new BorderLayout());
        ProjectData projectData = this.getProjectData();
        JPanel jPanel = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel(projectData.getName());
        jLabel.setForeground(Color.black);
        jLabel.setFont(new Font("Serif", 0, 18));
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, "North");
        JLabel jLabel2 = new JLabel(projectData.getComment());
        jLabel2.setForeground(Color.white);
        jLabel2.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel2, "Center");
        JPanel jPanel2 = new JPanel();
        this.yearComboBox = new JComboBox();
        this.yearComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PReport.this.yearChanged();
            }
        });
        this.yearComboBox.setBorder(new TitledBorder(SystemUtil.getResourceString("CurrentYear")));
        List list = projectData.getAnnuals();
        Iterator iterator = list.iterator();
        Integer n = null;
        while (iterator.hasNext()) {
            annualData = (AnnualData)iterator.next();
            Integer n2 = new Integer(annualData.getId());
            this.yearComboBox.addItem(n2);
            if (projectData.getCurYear() != annualData.getId()) continue;
            n = n2;
        }
        this.yearComboBox.setSelectedItem(n);
        jPanel2.add(this.yearComboBox);
        annualData = projectData.getAnnual(projectData.getCurYear());
        this.startedDate = new DateComponent();
        this.startedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("StartedDate")));
        this.startedDate.setDate(annualData.getStartedDate());
        jPanel2.add(this.startedDate);
        this.closedDate = new DateComponent();
        this.closedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("ClosedDate")));
        this.closedDate.setDate(annualData.getClosedDate());
        jPanel2.add(this.closedDate);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "North");
        this.tab = new JTabbedPane();
        this.plTable = new TProfitLoss(projectData, this.manager, projectData.getCurYear());
        this.balanceTable = new TBalance(projectData, this.manager, projectData.getCurYear());
        this.tab.addTab(SystemUtil.getResourceString("BalanceTable"), new JScrollPane(this.balanceTable));
        this.tab.addTab(SystemUtil.getResourceString("ProfitLossTable"), new JScrollPane(this.plTable));
        this.add((Component)this.tab, "Center");
    }

    public void update() {
        this.plTable.update();
        this.balanceTable.update();
    }

    JComboBox makeYearComboBox(ProjectData projectData) {
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PReport.this.yearChanged();
            }
        });
        jComboBox.setBorder(new TitledBorder(SystemUtil.getResourceString("CurrentYear")));
        List list = projectData.getAnnuals();
        Iterator iterator = list.iterator();
        Integer n = null;
        while (iterator.hasNext()) {
            AnnualData annualData = (AnnualData)iterator.next();
            Integer n2 = new Integer(annualData.getId());
            jComboBox.addItem(n2);
            if (projectData.getCurYear() != annualData.getId()) continue;
            n = n2;
        }
        this.yearComboBox.setSelectedItem(n);
        return this.yearComboBox;
    }

    void yearChanged() {
        try {
            ProjectData projectData = this.getProjectData();
            Integer n = (Integer)this.yearComboBox.getSelectedItem();
            int n2 = n;
            AnnualData annualData = projectData.getAnnual(n2);
            Date date = annualData.getStartedDate();
            this.startedDate.setDate(date);
            date = annualData.getClosedDate();
            this.closedDate.setDate(date);
            this.plTable.setYear(n2);
            this.balanceTable.setYear(n2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void print() {
        int n = this.tab.getSelectedIndex();
        if (n == 0) {
            this.balanceTable.print();
        }
        if (n == 1) {
            this.plTable.print();
        }
    }
}

