/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ASlipLine;
import arg.money.AnnualData;
import arg.money.DataLockingException;
import arg.money.ProjectData;
import arg.money.ProjectManager;
import arg.money.SecurityManager;
import arg.money.SessionData;
import arg.money.SlipManager;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.TransferSlip;
import arg.money.UserData;
import arg.money.gui.DGeneralList;
import arg.money.gui.DSubjectSelect;
import arg.money.gui.DTransferSlipEdit;
import arg.money.gui.SubjectsUtil;
import arg.money.gui.TSlips;
import arg.money.print.LineListener;
import arg.money.print.TablePrinter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import jp.gr.java_conf.ccs2.comp.swing.DateComponent;
import jp.gr.java_conf.ccs2.frame.CView;
import jp.gr.java_conf.ccs2.frame.Document;

public class SearchPanel
extends JPanel {
    protected ProjectManager projectManager;
    protected SecurityManager securityManager;
    protected SlipManager slipManager;
    protected SessionData session;
    int debitId = -1;
    int creditId = -1;
    int searchUser = -1;
    protected Frame ownerFrame;
    protected DateComponent startDate;
    protected DateComponent endDate;
    protected int curPid;
    protected int curYear;
    protected TSlips tableSlips;
    private int[] parray;
    CView view;
    protected NumberFormat NF = NumberFormat.getInstance();
    private JPanel topPanel;
    private JLabel topLabel;
    private JTabbedPane pageTab;
    private JPanel timePane;
    private JPanel ypPanel;
    private JComboBox yearBox;
    private JComboBox projectBox;
    private JPanel datePanel;
    private JPanel subjectPane;
    private JPanel subjectPanel;
    private JPanel creditPanel;
    private JTextField creditText;
    private JPanel debitPanel;
    private JTextField debitText;
    private JPanel summaryPanel;
    private JTextField summaryText;
    private JPanel infoPane;
    private JPanel userPanel;
    private JLabel userLabel;
    private JButton userButton;
    private JPanel repPanel;
    private JTextField repText;
    private JPanel moneyPanel;
    private JTextField moneyText;
    private JPanel jPanel6;
    private JButton searchButton;
    private JButton resetButton;
    private JButton printButton;
    private JButton exitButton;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JTextField leftSumText;
    private JTextField rightSumText;

    public SearchPanel() {
        this.initComponents();
    }

    public SearchPanel(Frame frame, SystemInfo systemInfo, SessionData sessionData, Document document) {
        this.ownerFrame = frame;
        this.session = sessionData;
        this.projectManager = systemInfo.getProjectManager();
        this.securityManager = systemInfo.getSecurityManager();
        this.slipManager = systemInfo.getSlipManager();
        this.setDocument(document);
        this.initComponents();
        this.pageTab.setTitleAt(0, SystemUtil.getResourceString("SearchTimePage"));
        this.pageTab.setTitleAt(1, SystemUtil.getResourceString("SearchSubjectPage"));
        this.pageTab.setTitleAt(2, SystemUtil.getResourceString("SearchInfoPage"));
        this.startDate = new DateComponent();
        this.startDate.setBorder(new TitledBorder(SystemUtil.getResourceString("SearchStartDate")));
        this.endDate = new DateComponent();
        this.endDate.setBorder(new TitledBorder(SystemUtil.getResourceString("SearchEndDate")));
        this.datePanel.add(this.startDate);
        this.datePanel.add(this.endDate);
        List list = this.securityManager.getPermittedProjects(this.session.getUid(), 1);
        this.parray = new int[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ProjectData projectData = (ProjectData)iterator.next();
            this.parray[n++] = projectData.getId();
            this.projectBox.addItem(projectData.getName());
        }
        this.setProject(this.parray[0]);
        this.tableSlips = new TSlips(this.slipManager, this.curPid, null);
        this.tableSlips.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SearchPanel.this.showDialog();
                }
            }
        });
        this.add((Component)new JScrollPane(this.tableSlips), "Center");
        this.reset();
    }

    boolean securityCheck() {
        boolean bl = this.securityManager.getPermission(this.session, this.curPid, 2);
        if (!bl) {
            String string = SystemUtil.getResourceString("DontHaveWritablePermission");
            JOptionPane.showMessageDialog(this, string);
            return false;
        }
        return true;
    }

    ASlipLine getSelectedSlip() {
        int n = this.tableSlips.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.tableSlips.getLine(n);
    }

    void setDocument(Document document) {
        this.view = new CView(document){

            public void update(Object object) {
                if (object == null) {
                    SearchPanel.this.onExit();
                    return;
                }
                int n = (Integer)object;
                SearchPanel.this.updateContents(n);
            }
        };
    }

    void updateContents(int n) {
        if (n < 0) {
            return;
        }
        this.tableSlips.getMyModel().fireTableDataChanged();
    }

    void showDialog() {
        if (!this.securityCheck()) {
            return;
        }
        TransferSlip transferSlip = this.getSelectedSlip().getParent();
        if (transferSlip == null) {
            return;
        }
        try {
            transferSlip = this.slipManager.lockSlip(transferSlip.getYear(), transferSlip.getPid(), transferSlip.getId());
        }
        catch (DataLockingException dataLockingException) {
            JOptionPane.showMessageDialog(this, SystemUtil.getResourceString("SlipLockError"));
            return;
        }
        if (transferSlip == null) {
            System.out.println("null slip error");
            return;
        }
        DTransferSlipEdit dTransferSlipEdit = new DTransferSlipEdit(this.ownerFrame, transferSlip, this.slipManager);
        dTransferSlipEdit.show();
        if (dTransferSlipEdit.isOk()) {
            transferSlip.setUid(this.session.getUid());
            this.slipManager.comitSlip(transferSlip);
        } else {
            this.slipManager.cancelSlip(transferSlip);
        }
    }

    void onExit() {
        this.ownerFrame.dispose();
        this.view.closeView();
    }

    void setProject(int n) {
        ProjectData projectData = this.projectManager.getProjectData(n);
        if (projectData == null) {
            return;
        }
        this.curPid = n;
        List list = projectData.getAnnuals();
        this.yearBox.removeAllItems();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AnnualData annualData = (AnnualData)iterator.next();
            this.yearBox.addItem(new Integer(annualData.getId()));
        }
        this.setYear(projectData.getCurYear());
        this.debitId = -1;
        this.creditId = -1;
        this.creditText.setText("");
        this.debitText.setText("");
    }

    void setYear(int n) {
        this.curYear = n;
        ComboBoxModel comboBoxModel = this.yearBox.getModel();
        int n2 = 0;
        while (n2 < comboBoxModel.getSize()) {
            Integer n3 = (Integer)comboBoxModel.getElementAt(n2);
            if (this.curYear == n3) {
                this.yearBox.setSelectedItem(n3);
                break;
            }
            ++n2;
        }
    }

    void reset() {
        int n = this.pageTab.getSelectedIndex();
        if (n == -1) {
            return;
        }
        switch (n) {
            case 0: {
                this.setProject(this.parray[0]);
                this.startDate.setDate(null);
                this.endDate.setDate(null);
                break;
            }
            case 1: {
                this.creditId = -1;
                this.debitId = -1;
                this.creditText.setText("");
                this.debitText.setText("");
                this.summaryText.setText("");
                break;
            }
            case 2: {
                this.userButton.setText(SystemUtil.getResourceString("notSelected"));
                this.searchUser = -1;
                this.repText.setText("");
                this.moneyText.setText("");
                break;
            }
        }
    }

    void tableUpdate() {
        if (this.tableSlips != null) {
            List list = this.slipManager.query(this.curYear, this.curPid);
            this.creditId = -1;
            this.debitId = -1;
            this.tableUpdate(list);
        }
    }

    void tableUpdate(List list) {
        List list2 = this.slipManager.getList(list);
        this.tableSlips.setSlips(list2, this.curPid, this.creditId, this.debitId);
        long[] lArray = this.tableSlips.getAmounts();
        this.leftSumText.setText(this.NF.format(lArray[0]));
        this.rightSumText.setText(this.NF.format(lArray[1]));
    }

    void search() {
        int n = this.pageTab.getSelectedIndex();
        if (n == -1) {
            return;
        }
        switch (n) {
            case 0: {
                List list = this.slipManager.query(this.curYear, this.curPid);
                this.slipManager.queryByDate(this.startDate.getDate(), this.endDate.getDate(), list);
                this.tableUpdate(list);
                break;
            }
            case 1: {
                List list = this.tableSlips.getSlips();
                list = this.slipManager.query(list);
                this.slipManager.queryBySubject(this.creditId, this.debitId, list);
                String string = this.summaryText.getText();
                if (string == null || string.length() == 0) {
                    this.tableUpdate(list);
                    break;
                }
                this.slipManager.queryBySummary(string, list);
                this.tableUpdate(list);
                break;
            }
            case 2: {
                long l;
                int n2;
                List list = this.tableSlips.getSlips();
                list = this.slipManager.query(list);
                if (this.searchUser != -1) {
                    this.slipManager.queryByUser(this.searchUser, list);
                }
                if ((n2 = this.transInteger(this.repText.getText(), -1)) != -1) {
                    this.slipManager.queryByReceipt(n2, list);
                }
                if ((l = this.transLong(this.moneyText.getText(), -1L)) != -1L) {
                    this.slipManager.queryByMoney(l, list);
                }
                this.tableUpdate(list);
                break;
            }
        }
    }

    public int transInteger(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private long transLong(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    protected void onPrint() {
        LineListener lineListener = new LineListener(){

            public int getColumnLine(TableModel tableModel, int n) {
                return 1;
            }

            public int getRowLine(TableModel tableModel, int n) {
                if ((n & 5) == 4) {
                    return 1;
                }
                return 0;
            }

            public boolean isStrong(TableModel tableModel, int n, int n2) {
                return false;
            }
        };
        TablePrinter tablePrinter = new TablePrinter(SystemUtil.getResourceString("SearchResult"), this.tableSlips, this.tableSlips.aligns, this.tableSlips.lengthes, lineListener);
        tablePrinter.print();
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.topLabel = new JLabel();
        this.pageTab = new JTabbedPane();
        this.timePane = new JPanel();
        this.ypPanel = new JPanel();
        this.yearBox = new JComboBox();
        this.projectBox = new JComboBox();
        this.datePanel = new JPanel();
        this.subjectPane = new JPanel();
        this.subjectPanel = new JPanel();
        this.creditPanel = new JPanel();
        this.creditText = new JTextField();
        this.debitPanel = new JPanel();
        this.debitText = new JTextField();
        this.summaryPanel = new JPanel();
        this.summaryText = new JTextField();
        this.infoPane = new JPanel();
        this.userPanel = new JPanel();
        this.userLabel = new JLabel();
        this.userButton = new JButton();
        this.repPanel = new JPanel();
        this.repText = new JTextField();
        this.moneyPanel = new JPanel();
        this.moneyText = new JTextField();
        this.jPanel6 = new JPanel();
        this.searchButton = new JButton();
        this.resetButton = new JButton();
        this.printButton = new JButton();
        this.exitButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.leftSumText = new JTextField();
        this.rightSumText = new JTextField();
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.topLabel.setText(SystemUtil.getResourceString("SearchPanel"));
        this.topLabel.setFont(new Font("Serif", 0, 24));
        this.topPanel.add((Component)this.topLabel, "North");
        this.timePane.setLayout(new BoxLayout(this.timePane, 1));
        this.ypPanel.setBorder(new TitledBorder("Year and Project"));
        SubjectsUtil.borderTitle(this.ypPanel, SystemUtil.getResourceString("YearAndProject"));
        this.yearBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SearchPanel.this.yearBoxItemStateChanged(itemEvent);
            }
        });
        this.ypPanel.add(this.yearBox);
        this.projectBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SearchPanel.this.projectBoxItemStateChanged(itemEvent);
            }
        });
        this.ypPanel.add(this.projectBox);
        this.timePane.add(this.ypPanel);
        this.datePanel.setBorder(new TitledBorder("Date"));
        SubjectsUtil.borderTitle(this.datePanel, SystemUtil.getResourceString("Date"));
        this.timePane.add(this.datePanel);
        this.pageTab.addTab("jPanel1", this.timePane);
        this.subjectPane.setLayout(new BoxLayout(this.subjectPane, 1));
        this.subjectPanel.setLayout(new GridLayout(1, 2));
        this.subjectPanel.setBorder(new TitledBorder("Subject"));
        SubjectsUtil.borderTitle(this.subjectPanel, SystemUtil.getResourceString("Subject"));
        this.creditPanel.setBorder(new TitledBorder(new EtchedBorder(), "Credit", 2, 2, new Font("Dialog", 0, 11), Color.black));
        SubjectsUtil.borderTitle(this.creditPanel, SystemUtil.getResourceString("Credit"));
        this.creditText.setColumns(12);
        this.creditText.setBackground(new Color(255, 224, 223));
        this.creditText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SearchPanel.this.creditTextMousePressed(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                SearchPanel.this.creditTextMouseClicked(mouseEvent);
            }
        });
        this.creditPanel.add(this.creditText);
        this.subjectPanel.add(this.creditPanel);
        this.debitPanel.setBorder(new TitledBorder(new EtchedBorder(), "Debit", 2, 2, new Font("Dialog", 0, 11), Color.black));
        SubjectsUtil.borderTitle(this.debitPanel, SystemUtil.getResourceString("Debtor"));
        this.debitText.setColumns(12);
        this.debitText.setBackground(new Color(255, 220, 221));
        this.debitText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SearchPanel.this.debitTextMousePressed(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                SearchPanel.this.debitTextMouseClicked(mouseEvent);
            }
        });
        this.debitPanel.add(this.debitText);
        this.subjectPanel.add(this.debitPanel);
        this.subjectPane.add(this.subjectPanel);
        this.summaryPanel.setBorder(new TitledBorder("Summary"));
        SubjectsUtil.borderTitle(this.summaryPanel, SystemUtil.getResourceString("Summary"));
        this.summaryText.setColumns(18);
        this.summaryPanel.add(this.summaryText);
        this.subjectPane.add(this.summaryPanel);
        this.pageTab.addTab("jPanel6", this.subjectPane);
        this.infoPane.setLayout(new BoxLayout(this.infoPane, 1));
        this.userPanel.setBorder(new TitledBorder("User"));
        SubjectsUtil.borderTitle(this.userPanel, SystemUtil.getResourceString("User"));
        this.userLabel.setText(SystemUtil.getResourceString("User"));
        this.userPanel.add(this.userLabel);
        this.userButton.setText(SystemUtil.getResourceString("notSelected"));
        this.userButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.userButtonActionPerformed(actionEvent);
            }
        });
        this.userPanel.add(this.userButton);
        this.infoPane.add(this.userPanel);
        this.repPanel.setBorder(new TitledBorder("Reciept No."));
        SubjectsUtil.borderTitle(this.repPanel, SystemUtil.getResourceString("ReceiptNumber"));
        this.repText.setColumns(10);
        this.repPanel.add(this.repText);
        this.infoPane.add(this.repPanel);
        this.moneyPanel.setBorder(new TitledBorder("Money"));
        SubjectsUtil.borderTitle(this.moneyPanel, SystemUtil.getResourceString("Amount"));
        this.moneyText.setColumns(16);
        this.moneyPanel.add(this.moneyText);
        this.infoPane.add(this.moneyPanel);
        this.pageTab.addTab("jPanel8", this.infoPane);
        this.topPanel.add((Component)this.pageTab, "Center");
        this.jPanel6.setLayout(new GridLayout(4, 1, 0, 5));
        this.searchButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Find24.gif")));
        this.searchButton.setText(SystemUtil.getResourceString("SearchButton"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.searchButton);
        this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Redo24.gif")));
        this.resetButton.setText(SystemUtil.getResourceString("Cancel"));
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.resetButton);
        this.printButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Print24.gif")));
        this.printButton.setText(SystemUtil.getResourceString("Print"));
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.printButton);
        this.exitButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
        this.exitButton.setText(SystemUtil.getResourceString("Exit"));
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.exitButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.exitButton);
        this.topPanel.add((Component)this.jPanel6, "East");
        this.add((Component)this.topPanel, "North");
        this.jLabel1.setText(SystemUtil.getResourceString("Total"));
        this.jPanel1.add(this.jLabel1);
        this.leftSumText.setBorder(new TitledBorder("CreditAmount"));
        this.leftSumText.setColumns(16);
        SubjectsUtil.borderTitle(this.leftSumText, SystemUtil.getResourceString("LeftAmount"));
        this.jPanel1.add(this.leftSumText);
        this.rightSumText.setBorder(new TitledBorder("DebitAmount"));
        this.rightSumText.setColumns(16);
        SubjectsUtil.borderTitle(this.rightSumText, SystemUtil.getResourceString("RightAmount"));
        this.jPanel1.add(this.rightSumText);
        this.add((Component)this.jPanel1, "South");
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.onExit();
    }

    private void debitTextMousePressed(MouseEvent mouseEvent) {
        this.debitText.transferFocus();
        ProjectData projectData = this.projectManager.getProjectData(this.curPid);
        DSubjectSelect dSubjectSelect = new DSubjectSelect(this.ownerFrame, projectData);
        dSubjectSelect.show();
        if (dSubjectSelect.isOk()) {
            this.debitId = dSubjectSelect.getId();
            this.debitText.setText(projectData.getSubject(dSubjectSelect.getId()).getName());
        }
    }

    private void creditTextMousePressed(MouseEvent mouseEvent) {
        this.creditText.transferFocus();
        ProjectData projectData = this.projectManager.getProjectData(this.curPid);
        DSubjectSelect dSubjectSelect = new DSubjectSelect(this.ownerFrame, projectData);
        dSubjectSelect.show();
        if (dSubjectSelect.isOk()) {
            this.creditId = dSubjectSelect.getId();
            this.creditText.setText(projectData.getSubject(dSubjectSelect.getId()).getName());
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.onPrint();
    }

    private void creditTextMouseClicked(MouseEvent mouseEvent) {
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.reset();
    }

    private void debitTextMouseClicked(MouseEvent mouseEvent) {
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.search();
    }

    private void userButtonActionPerformed(ActionEvent actionEvent) {
        List list = this.securityManager.getUserManager().getUsers();
        DGeneralList dGeneralList = new DGeneralList(this.ownerFrame, "", list);
        dGeneralList.show();
        int n = dGeneralList.getIndex();
        if (n == -1) {
            return;
        }
        UserData userData = (UserData)list.get(n);
        this.searchUser = userData.getId();
        this.userButton.setText(userData.getName());
    }

    private void projectBoxItemStateChanged(ItemEvent itemEvent) {
        int n = this.projectBox.getSelectedIndex();
        if (n < 0 || n >= this.parray.length) {
            return;
        }
        this.setProject(this.parray[n]);
        this.tableUpdate();
    }

    private void yearBoxItemStateChanged(ItemEvent itemEvent) {
        try {
            Integer n = (Integer)this.yearBox.getSelectedItem();
            this.curYear = n;
            this.tableUpdate();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

