/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ProjectData;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectSubgroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.MessageListener;

public class SubjectsUtil {
    JList groupList;
    JList subgroupList;
    JList subjectList;
    ProjectData project;
    MessageListener listener;
    SubjectGroup[] garray;
    SubjectSubgroup[] sgarray;
    Subject[] sarray;
    Color activeColor = new Color(0xFFE0E0);
    Color normalColor = Color.white;
    FocusListener listFocus = new FocusAdapter(){

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            component.setBackground(SubjectsUtil.this.activeColor);
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            component.setBackground(SubjectsUtil.this.normalColor);
        }
    };

    public static void borderTitle(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        if (border instanceof TitledBorder) {
            ((TitledBorder)border).setTitle(string);
        }
    }

    public static void setCenter(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        ((Component)window).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public SubjectsUtil(ProjectData projectData, JList jList, JList jList2, JList jList3, MessageListener messageListener) {
        this.project = projectData;
        this.groupList = jList;
        this.subgroupList = jList2;
        this.subjectList = jList3;
        this.listener = messageListener;
        jList.addFocusListener(this.listFocus);
        jList2.addFocusListener(this.listFocus);
        jList3.addFocusListener(this.listFocus);
        this.updateGroupList();
    }

    public void update(ProjectData projectData) {
        this.project = projectData;
        this.updateGroupList();
    }

    public void update(ProjectData projectData, int n) {
        MessageListener messageListener = this.listener;
        this.listener = null;
        this.update(projectData);
        this.listener = messageListener;
        if (n >= 0) {
            this.setSelectedSubject(n);
            this.sendMessage();
        }
    }

    public void setSelectedSubject(int n) {
        SubjectGroup subjectGroup = this.project.getGroupBySubject(n);
        if (subjectGroup == null) {
            return;
        }
        int n2 = subjectGroup.getId();
        int n3 = 0;
        while (n3 < this.garray.length) {
            if (this.garray[n3].getId() == n2) {
                this.groupList.setSelectedIndex(n3);
                break;
            }
            ++n3;
        }
        int n4 = this.project.getSubgroupBySubject(n).getId();
        int n5 = 0;
        while (n5 < this.sgarray.length) {
            if (this.sgarray[n5].getId() == n4) {
                this.subgroupList.setSelectedIndex(n5);
                break;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.sarray.length) {
            if (this.sarray[n6].getId() == n) {
                this.subjectList.setSelectedIndex(n6);
                break;
            }
            ++n6;
        }
    }

    public void updateGroupList() {
        List list = this.project.getSubjectGroups();
        if (list.size() != 0) {
            this.garray = new SubjectGroup[list.size()];
            int n = 0;
            while (n < this.garray.length) {
                this.garray[n] = (SubjectGroup)list.get(n);
                ++n;
            }
            this.groupList.setListData(this.garray);
            try {
                this.groupList.setSelectedIndex(0);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.updateSubgroupList();
    }

    public void updateSubgroupList() {
        try {
            SubjectGroup subjectGroup = this.getSelectedGroup();
            List list = this.project.getSubjectSubgroups();
            Iterator iterator = list.iterator();
            LinkedList<SubjectSubgroup> linkedList = new LinkedList<SubjectSubgroup>();
            while (iterator.hasNext()) {
                SubjectSubgroup subjectSubgroup = (SubjectSubgroup)iterator.next();
                if (subjectSubgroup.getGroupId() != subjectGroup.getId()) continue;
                linkedList.add(subjectSubgroup);
            }
            this.sgarray = new SubjectSubgroup[linkedList.size()];
            int n = 0;
            while (n < this.sgarray.length) {
                this.sgarray[n] = (SubjectSubgroup)linkedList.get(n);
                ++n;
            }
            this.subgroupList.setListData(this.sgarray);
            this.subgroupList.setSelectedIndex(0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.updateSubjectList();
    }

    public void updateSubjectList() {
        try {
            SubjectSubgroup subjectSubgroup = this.getSelectedSubgroup();
            List list = this.project.getSubjects();
            Iterator iterator = list.iterator();
            LinkedList<Subject> linkedList = new LinkedList<Subject>();
            while (iterator.hasNext()) {
                Subject subject = (Subject)iterator.next();
                if (subject.getSubgroupId() != subjectSubgroup.getId()) continue;
                linkedList.add(subject);
            }
            this.sarray = new Subject[linkedList.size()];
            int n = 0;
            while (n < this.sarray.length) {
                this.sarray[n] = (Subject)linkedList.get(n);
                ++n;
            }
            this.subjectList.setListData(this.sarray);
            this.subjectList.setSelectedIndex(0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.sendMessage();
    }

    private void sendMessage() {
        Subject subject;
        if (this.listener != null && (subject = this.getSelectedSubject()) != null) {
            this.listener.message("", subject.getId(), null);
        }
    }

    public Subject getSelectedSubject() {
        try {
            int n = this.subjectList.getSelectedIndex();
            if (n == -1) {
                n = 0;
            }
            Subject subject = this.sarray[n];
            return subject;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public SubjectSubgroup getSelectedSubgroup() {
        try {
            int n = this.subgroupList.getSelectedIndex();
            if (n == -1) {
                n = 0;
            }
            return this.sgarray[n];
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public SubjectGroup getSelectedGroup() {
        try {
            int n = this.groupList.getSelectedIndex();
            if (n == -1) {
                n = 0;
            }
            return this.garray[n];
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

