/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.AnnualData;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectCurrentMoney;
import arg.money.SubjectMoney;
import arg.money.SystemUtil;
import arg.money.gui.CellManager;
import arg.money.gui.TAbstract;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class TAbstractProject
extends TAbstract
implements CellManager {
    protected ProjectData project;
    protected SlipManager manager;
    protected AnnualData annual;
    String title;

    public String getTitle() {
        Object[] objectArray = new Object[]{this.project.getName(), new Integer(this.annual.getYear()), this.title};
        String string = MessageFormat.format(SystemUtil.getResourceString("SheetTitle"), objectArray);
        return string;
    }

    protected void init(ProjectData projectData, SlipManager slipManager, int n, String string) {
        this.title = string;
        this.project = projectData;
        this.manager = slipManager;
        this.annual = this.project.getAnnual(n);
        this.setModel(this.initModel());
    }

    void setYear(int n) {
        this.annual = this.project.getAnnual(n);
        this.update();
    }

    protected Iterator getIterator(Map map) {
        Iterator iterator = map.values().iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList.iterator();
    }

    public abstract boolean isStrongCell(int var1, int var2);

    public TAbstractProject(ProjectData projectData, SlipManager slipManager, int n, String string) {
        this.init(projectData, slipManager, n, string);
    }

    class TableElement
    extends TAbstract.AbstractTableElement {
        Subject subject;

        String getName() {
            return this.subject.getName();
        }

        long getMoney() {
            SubjectCurrentMoney subjectCurrentMoney = TAbstractProject.this.annual.getCurrentMoney(this.subject.getId());
            if (subjectCurrentMoney == null) {
                return 0L;
            }
            return subjectCurrentMoney.getCurrentAmount(TAbstractProject.this.manager);
        }

        long getInitMoney() {
            SubjectMoney subjectMoney = TAbstractProject.this.annual.getInitialMoney(this.subject.getId());
            if (subjectMoney == null) {
                return 0L;
            }
            return subjectMoney.getMoney();
        }

        long getEndMoney() {
            SubjectCurrentMoney subjectCurrentMoney = TAbstractProject.this.annual.getCurrentMoney(this.subject.getId());
            if (subjectCurrentMoney == null) {
                return 0L;
            }
            return subjectCurrentMoney.getCurrentAmount(TAbstractProject.this.manager);
        }

        TableElement(Subject subject) {
            this.subject = subject;
        }
    }
}

