/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.NameCommentObject;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectSubgroup;
import arg.money.SystemUtil;
import arg.money.gui.MyCellRender;
import arg.money.gui.TAbstract;
import arg.money.gui.TAbstractProject;
import arg.money.print.LineListener;
import arg.money.print.TablePrinter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TBalance
extends TAbstractProject {
    TAbstract.AbstractTableElement[] assets;
    TAbstract.AbstractTableElement[] debts;
    TAbstract.AbstractTableElement[] capitals;

    public TBalance(ProjectData projectData, SlipManager slipManager, int n) {
        super(projectData, slipManager, n, SystemUtil.getResourceString("BalanceTable"));
        this.setDefaultRenderer("".getClass(), new MyCellRender(this));
    }

    public void print() {
        LineListener lineListener = new LineListener(){

            public int getColumnLine(TableModel tableModel, int n) {
                return 1;
            }

            public int getRowLine(TableModel tableModel, int n) {
                if (tableModel.getRowCount() - 2 == n) {
                    return 1;
                }
                return 0;
            }

            public boolean isStrong(TableModel tableModel, int n, int n2) {
                return TBalance.this.isStrongCell(n, n2);
            }
        };
        String[] stringArray = this.getAligns();
        int[] nArray = this.getChops();
        TablePrinter tablePrinter = new TablePrinter(this.getTitle(), this, stringArray, nArray, lineListener);
        tablePrinter.print();
    }

    protected AbstractTableModel initModel() {
        return new BalanceModel();
    }

    public int[] getChops() {
        int[] nArray = new int[]{12, 16, 16, 12, 16, 16};
        return nArray;
    }

    public String[] getAligns() {
        String[] stringArray = new String[]{"c", "r", "r", "c", "r", "r"};
        return stringArray;
    }

    public boolean isStrongCell(int n, int n2) {
        boolean bl = false;
        try {
            switch (n2) {
                case 0: 
                case 1: 
                case 2: {
                    if (this.assets.length <= n || !(this.assets[n] instanceof TAbstract.SpElement)) break;
                    bl = true;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (this.debts.length <= n || !(this.debts[n] instanceof TAbstract.SpElement)) break;
                    bl = true;
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return bl;
    }

    class BalanceModel
    extends AbstractTableModel {
        int rows;
        String[] columns = new String[]{SystemUtil.getResourceString("Assets"), SystemUtil.getResourceString("Beginning"), SystemUtil.getResourceString("End"), SystemUtil.getResourceString("DebtAndCapital"), SystemUtil.getResourceString("Beginning"), SystemUtil.getResourceString("End")};

        BalanceModel() {
            Subject subject;
            Serializable serializable;
            NameCommentObject nameCommentObject;
            Iterator iterator;
            Object object;
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            Iterator iterator2 = TBalance.this.project.getSubjects().iterator();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (iterator2.hasNext()) {
                object = (Subject)iterator2.next();
                iterator = TBalance.this.project.getGroupBySubject(((Subject)object).getId());
                nameCommentObject = TBalance.this.project.getSubgroupBySubject(((Subject)object).getId());
                serializable = null;
                switch (((SubjectGroup)((Object)iterator)).getBalanceGroup()) {
                    case 0: {
                        serializable = (List)hashMap.get(nameCommentObject);
                        if (serializable == null) {
                            serializable = new LinkedList();
                            hashMap.put(nameCommentObject, serializable);
                            ++n;
                        }
                        serializable.add(object);
                        ++n;
                        break;
                    }
                    case 1: {
                        serializable = (List)hashMap2.get(nameCommentObject);
                        if (serializable == null) {
                            serializable = new LinkedList();
                            hashMap2.put(nameCommentObject, serializable);
                            ++n2;
                        }
                        serializable.add(object);
                        ++n2;
                        break;
                    }
                    case 2: {
                        serializable = (List)hashMap3.get(nameCommentObject);
                        if (serializable == null) {
                            serializable = new LinkedList();
                            hashMap3.put(nameCommentObject, serializable);
                            ++n3;
                        }
                        serializable.add(object);
                        ++n3;
                        break;
                    }
                }
            }
            TBalance.this.assets = new TAbstract.AbstractTableElement[n];
            iterator2 = TBalance.this.getIterator(hashMap);
            n = 0;
            while (iterator2.hasNext()) {
                object = (List)iterator2.next();
                iterator = object.iterator();
                nameCommentObject = (Subject)object.get(0);
                serializable = TBalance.this.project.getSubgroupBySubject(((Subject)nameCommentObject).getId());
                TBalance.this.assets[n++] = new TAbstract.SpElement(((SubjectSubgroup)serializable).getName());
                while (iterator.hasNext()) {
                    subject = (Subject)iterator.next();
                    TBalance.this.assets[n++] = new TAbstractProject.TableElement(subject);
                }
            }
            TBalance.this.debts = new TAbstract.AbstractTableElement[n2];
            iterator2 = TBalance.this.getIterator(hashMap2);
            n2 = 0;
            while (iterator2.hasNext()) {
                object = (List)iterator2.next();
                iterator = object.iterator();
                nameCommentObject = (Subject)object.get(0);
                serializable = TBalance.this.project.getSubgroupBySubject(((Subject)nameCommentObject).getId());
                TBalance.this.debts[n2++] = new TAbstract.SpElement(((SubjectSubgroup)serializable).getName());
                while (iterator.hasNext()) {
                    subject = (Subject)iterator.next();
                    TBalance.this.debts[n2++] = new TAbstractProject.TableElement(subject);
                }
            }
            TBalance.this.capitals = new TAbstract.AbstractTableElement[n3];
            iterator2 = TBalance.this.getIterator(hashMap3);
            n3 = 0;
            while (iterator2.hasNext()) {
                object = (List)iterator2.next();
                iterator = object.iterator();
                nameCommentObject = (Subject)object.get(0);
                serializable = TBalance.this.project.getSubgroupBySubject(((Subject)nameCommentObject).getId());
                TBalance.this.capitals[n3++] = new TAbstract.SpElement(((SubjectSubgroup)serializable).getName());
                while (iterator.hasNext()) {
                    subject = (Subject)iterator.next();
                    TBalance.this.capitals[n3++] = new TAbstractProject.TableElement(subject);
                }
            }
            this.rows = Math.max(TBalance.this.assets.length + 1, TBalance.this.capitals.length + TBalance.this.debts.length + 2);
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public Class getColumnClass(int n) {
            if (n >= 0 && n <= 5) {
                return "".getClass();
            }
            return super.getColumnClass(n);
        }

        public int getColumnCount() {
            return 6;
        }

        public int getRowCount() {
            return this.rows;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (this.rows - 1 == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (TBalance.this.assets.length <= n) break;
                    return TBalance.this.assets[n].getName();
                }
                case 1: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n3 = 0;
                        while (n3 < TBalance.this.assets.length) {
                            l += TBalance.this.assets[n3].getInitMoney();
                            ++n3;
                        }
                        return TBalance.this.NF.format(l);
                    }
                    if (TBalance.this.assets.length <= n) break;
                    if (TBalance.this.assets[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TBalance.this.NF.format(TBalance.this.assets[n].getInitMoney());
                }
                case 2: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n4 = 0;
                        while (n4 < TBalance.this.assets.length) {
                            l += TBalance.this.assets[n4].getEndMoney();
                            ++n4;
                        }
                        return TBalance.this.NF.format(l);
                    }
                    if (TBalance.this.assets.length <= n) break;
                    if (TBalance.this.assets[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TBalance.this.NF.format(TBalance.this.assets[n].getEndMoney());
                }
                case 3: {
                    if (this.rows - 1 == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (this.rows - 2 == n) {
                        return SystemUtil.getResourceString("Capital");
                    }
                    if (TBalance.this.debts.length <= n) break;
                    return TBalance.this.debts[n].getName();
                }
                case 4: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n5 = 0;
                        while (n5 < TBalance.this.debts.length) {
                            l += TBalance.this.debts[n5].getInitMoney();
                            ++n5;
                        }
                        int n6 = 0;
                        while (n6 < TBalance.this.capitals.length) {
                            l += TBalance.this.capitals[n6].getInitMoney();
                            ++n6;
                        }
                        return TBalance.this.NF.format(l);
                    }
                    if (this.rows - 2 == n) {
                        long l = 0L;
                        int n7 = 0;
                        while (n7 < TBalance.this.capitals.length) {
                            l += TBalance.this.capitals[n7].getInitMoney();
                            ++n7;
                        }
                        return TBalance.this.NF.format(l);
                    }
                    if (TBalance.this.debts.length <= n) break;
                    if (TBalance.this.debts[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TBalance.this.NF.format(TBalance.this.debts[n].getInitMoney());
                }
                case 5: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n8 = 0;
                        while (n8 < TBalance.this.debts.length) {
                            l += TBalance.this.debts[n8].getEndMoney();
                            ++n8;
                        }
                        int n9 = 0;
                        while (n9 < TBalance.this.capitals.length) {
                            l += TBalance.this.capitals[n9].getEndMoney();
                            ++n9;
                        }
                        return TBalance.this.NF.format(l);
                    }
                    if (this.rows - 2 == n) {
                        long l = 0L;
                        int n10 = 0;
                        while (n10 < TBalance.this.capitals.length) {
                            l += TBalance.this.capitals[n10].getEndMoney();
                            ++n10;
                        }
                        return TBalance.this.NF.format(l);
                    }
                    if (TBalance.this.debts.length <= n) break;
                    if (TBalance.this.debts[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TBalance.this.NF.format(TBalance.this.debts[n].getEndMoney());
                }
            }
            return "";
        }
    }
}

