/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.AnnualData;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectCurrentMoney;
import arg.money.SubjectGroup;
import arg.money.SubjectMoney;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.gui.TAbstract;
import arg.money.print.LineListener;
import arg.money.print.TablePrinter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TGroupBalance
extends TAbstract {
    TAbstract.AbstractTableElement[] assets;
    TAbstract.AbstractTableElement[] debts;
    TAbstract.AbstractTableElement capital;
    SystemInfo info;
    int year;

    public TGroupBalance(SystemInfo systemInfo, int n) {
        this.info = systemInfo;
        this.year = n;
        this.setModel(this.initModel());
    }

    int getYear() {
        return this.year;
    }

    void setYear(int n) {
        this.year = n;
        this.update();
    }

    public String getTitle() {
        Object[] objectArray = new Object[]{SystemUtil.getResourceString("ConsolidatedAccounts"), new Integer(this.getYear())};
        String string = MessageFormat.format(SystemUtil.getResourceString("SheetTitleLite"), objectArray);
        return string;
    }

    public void print() {
        LineListener lineListener = new LineListener(){

            public int getColumnLine(TableModel tableModel, int n) {
                return 1;
            }

            public int getRowLine(TableModel tableModel, int n) {
                if (tableModel.getRowCount() - 2 == n) {
                    return 1;
                }
                return 0;
            }

            public boolean isStrong(TableModel tableModel, int n, int n2) {
                return false;
            }
        };
        String[] stringArray = this.getAligns();
        int[] nArray = this.getChops();
        TablePrinter tablePrinter = new TablePrinter(this.getTitle(), this, stringArray, nArray, lineListener);
        tablePrinter.print();
    }

    protected AbstractTableModel initModel() {
        return new BalanceModel();
    }

    public int[] getChops() {
        int[] nArray = new int[]{12, 16, 16, 12, 16, 16};
        return nArray;
    }

    public String[] getAligns() {
        String[] stringArray = new String[]{"c", "r", "r", "c", "r", "r"};
        return stringArray;
    }

    class BalanceModel
    extends AbstractTableModel {
        int rows;
        String[] columns = new String[]{SystemUtil.getResourceString("Assets"), SystemUtil.getResourceString("Beginning"), SystemUtil.getResourceString("End"), SystemUtil.getResourceString("DebtAndCapital"), SystemUtil.getResourceString("Beginning"), SystemUtil.getResourceString("End")};

        BalanceModel() {
            Object[] objectArray;
            ArrayList<TableElement> arrayList = new ArrayList<TableElement>();
            ArrayList<TableElement> arrayList2 = new ArrayList<TableElement>();
            List list = TGroupBalance.this.info.getProjectManager().getProjects();
            SlipManager slipManager = TGroupBalance.this.info.getSlipManager();
            int n = 0;
            while (n < list.size()) {
                objectArray = (Object[])list.get(n);
                AnnualData annualData = objectArray.getAnnual(TGroupBalance.this.getYear());
                if (annualData != null) {
                    Object[] objectArray2 = new Object[]{objectArray.getName(), SystemUtil.getResourceString("Assets")};
                    arrayList.add(new TableElement(MessageFormat.format(SystemUtil.getResourceString("GroupAmountLabel"), objectArray2), this.getGroupInitialAmount(0, annualData), this.getGroupCurrentAmount(0, annualData)));
                    Object[] objectArray3 = new Object[]{objectArray.getName(), SystemUtil.getResourceString("Debt")};
                    arrayList2.add(new TableElement(MessageFormat.format(SystemUtil.getResourceString("GroupAmountLabel"), objectArray3), this.getGroupInitialAmount(1, annualData), this.getGroupCurrentAmount(1, annualData)));
                }
                ++n;
            }
            TGroupBalance.this.assets = new TAbstract.AbstractTableElement[arrayList.size()];
            TGroupBalance.this.assets = arrayList.toArray(TGroupBalance.this.assets);
            TGroupBalance.this.debts = new TAbstract.AbstractTableElement[arrayList2.size()];
            TGroupBalance.this.debts = arrayList2.toArray(TGroupBalance.this.debts);
            objectArray = new Object[]{SystemUtil.getResourceString("Total"), SystemUtil.getResourceString("Capital")};
            TGroupBalance.this.capital = new TableElement(MessageFormat.format(SystemUtil.getResourceString("GroupAmountLabel"), objectArray), this.getInitialCapitalAmount(), this.getCurrentCapitalAmount());
            this.rows = TGroupBalance.this.assets.length + 2;
        }

        long getGroupInitialAmount(int n, AnnualData annualData) {
            SlipManager slipManager = TGroupBalance.this.info.getSlipManager();
            ProjectData projectData = annualData.getParent();
            Iterator iterator = projectData.getSubjects().iterator();
            long l = 0L;
            while (iterator.hasNext()) {
                Subject subject = (Subject)iterator.next();
                SubjectMoney subjectMoney = annualData.getInitialMoney(subject.getId());
                if (subjectMoney == null) continue;
                SubjectGroup subjectGroup = annualData.getParent().getGroupBySubject(subjectMoney.getId());
                if (subjectGroup == null) {
                    SystemUtil.logMessage("SubjectGroup not found : in TGroupBalance.");
                    continue;
                }
                if (subjectGroup.getBalanceGroup() != n) continue;
                l += subjectMoney.getMoney();
            }
            return l;
        }

        long getGroupCurrentAmount(int n, AnnualData annualData) {
            SlipManager slipManager = TGroupBalance.this.info.getSlipManager();
            ProjectData projectData = annualData.getParent();
            Iterator iterator = projectData.getSubjects().iterator();
            long l = 0L;
            while (iterator.hasNext()) {
                Subject subject = (Subject)iterator.next();
                SubjectCurrentMoney subjectCurrentMoney = annualData.getCurrentMoney(subject.getId());
                if (subjectCurrentMoney == null) continue;
                SubjectGroup subjectGroup = annualData.getParent().getGroupBySubject(subjectCurrentMoney.getId());
                if (subjectGroup == null) {
                    SystemUtil.logMessage("SubjectGroup not found : in TGroupBalance.");
                    continue;
                }
                if (subjectGroup.getBalanceGroup() != n) continue;
                l += subjectCurrentMoney.getCurrentAmount(slipManager);
            }
            return l;
        }

        long getInitialCapitalAmount() {
            SlipManager slipManager = TGroupBalance.this.info.getSlipManager();
            List list = TGroupBalance.this.info.getProjectManager().getProjects();
            long l = 0L;
            int n = 0;
            while (n < list.size()) {
                ProjectData projectData = (ProjectData)list.get(n);
                AnnualData annualData = projectData.getAnnual(TGroupBalance.this.getYear());
                if (annualData != null) {
                    List list2 = annualData.getInitialMoneys();
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        SubjectMoney subjectMoney = (SubjectMoney)list2.get(n2);
                        SubjectGroup subjectGroup = projectData.getGroupBySubject(subjectMoney.getId());
                        if (subjectGroup.getBalanceGroup() == 2) {
                            l += subjectMoney.getMoney();
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return l;
        }

        long getCurrentCapitalAmount() {
            SlipManager slipManager = TGroupBalance.this.info.getSlipManager();
            List list = TGroupBalance.this.info.getProjectManager().getProjects();
            long l = 0L;
            int n = 0;
            while (n < list.size()) {
                ProjectData projectData = (ProjectData)list.get(n);
                AnnualData annualData = projectData.getAnnual(TGroupBalance.this.getYear());
                if (annualData != null) {
                    List list2 = annualData.getCurrentMoneys();
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        SubjectCurrentMoney subjectCurrentMoney = (SubjectCurrentMoney)list2.get(n2);
                        SubjectGroup subjectGroup = projectData.getGroupBySubject(subjectCurrentMoney.getId());
                        if (subjectGroup.getBalanceGroup() == 2) {
                            l += subjectCurrentMoney.getCurrentAmount(slipManager);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return l;
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public Class getColumnClass(int n) {
            if (n >= 0 && n <= 5) {
                return "".getClass();
            }
            return super.getColumnClass(n);
        }

        public int getColumnCount() {
            return 6;
        }

        public int getRowCount() {
            return this.rows;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (this.rows == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (TGroupBalance.this.assets.length <= n) break;
                    return TGroupBalance.this.assets[n].getName();
                }
                case 1: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n3 = 0;
                        while (n3 < TGroupBalance.this.assets.length) {
                            l += TGroupBalance.this.assets[n3].getInitMoney();
                            ++n3;
                        }
                        return TGroupBalance.this.NF.format(l);
                    }
                    if (TGroupBalance.this.assets.length <= n) break;
                    if (TGroupBalance.this.assets[n] == null) {
                        return "";
                    }
                    return TGroupBalance.this.NF.format(TGroupBalance.this.assets[n].getInitMoney());
                }
                case 2: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n4 = 0;
                        while (n4 < TGroupBalance.this.assets.length) {
                            l += TGroupBalance.this.assets[n4].getEndMoney();
                            ++n4;
                        }
                        return TGroupBalance.this.NF.format(l);
                    }
                    if (TGroupBalance.this.assets.length <= n) break;
                    if (TGroupBalance.this.assets[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TGroupBalance.this.NF.format(TGroupBalance.this.assets[n].getEndMoney());
                }
                case 3: {
                    if (this.rows - 1 == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (this.rows - 2 == n) {
                        return SystemUtil.getResourceString("Capital");
                    }
                    if (TGroupBalance.this.debts.length <= n) break;
                    return TGroupBalance.this.debts[n].getName();
                }
                case 4: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n5 = 0;
                        while (n5 < TGroupBalance.this.debts.length) {
                            l += TGroupBalance.this.debts[n5].getInitMoney();
                            ++n5;
                        }
                        return TGroupBalance.this.NF.format(l += TGroupBalance.this.capital.getInitMoney());
                    }
                    if (this.rows - 2 == n) {
                        return TGroupBalance.this.NF.format(TGroupBalance.this.capital.getInitMoney());
                    }
                    if (TGroupBalance.this.debts.length <= n) break;
                    if (TGroupBalance.this.debts[n] == null) {
                        return "";
                    }
                    return TGroupBalance.this.NF.format(TGroupBalance.this.debts[n].getInitMoney());
                }
                case 5: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n6 = 0;
                        while (n6 < TGroupBalance.this.debts.length) {
                            l += TGroupBalance.this.debts[n6].getEndMoney();
                            ++n6;
                        }
                        return TGroupBalance.this.NF.format(l += TGroupBalance.this.capital.getEndMoney());
                    }
                    if (this.rows - 2 == n) {
                        return TGroupBalance.this.NF.format(TGroupBalance.this.capital.getEndMoney());
                    }
                    if (TGroupBalance.this.debts.length <= n) break;
                    if (TGroupBalance.this.debts[n] == null) {
                        return "";
                    }
                    return TGroupBalance.this.NF.format(TGroupBalance.this.debts[n].getEndMoney());
                }
            }
            return "";
        }
    }

    protected class TableElement
    extends TAbstract.AbstractTableElement {
        String name;
        long initMoney;
        long endMoney;

        TableElement(String string, long l, long l2) {
            this.name = string;
            this.initMoney = l;
            this.endMoney = l2;
        }

        String getName() {
            return this.name;
        }

        long getInitMoney() {
            return this.initMoney;
        }

        long getEndMoney() {
            return this.endMoney;
        }
    }
}

