/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.AnnualData;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectCurrentMoney;
import arg.money.SubjectGroup;
import arg.money.SystemInfo;
import arg.money.SystemUtil;
import arg.money.gui.TAbstract;
import arg.money.print.LineListener;
import arg.money.print.TablePrinter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TGroupProfitLoss
extends TAbstract {
    SystemInfo info;
    TAbstract.AbstractTableElement[] profits;
    TAbstract.AbstractTableElement[] expenses;
    int year;

    public TGroupProfitLoss(SystemInfo systemInfo, int n) {
        this.info = systemInfo;
        this.year = n;
        this.setModel(this.initModel());
    }

    int getYear() {
        return this.year;
    }

    void setYear(int n) {
        this.year = n;
        this.update();
    }

    protected AbstractTableModel initModel() {
        return new PLModel();
    }

    public int[] getChops() {
        int[] nArray = new int[]{12, 16, 12, 16};
        return nArray;
    }

    public String[] getAligns() {
        String[] stringArray = new String[]{"c", "r", "c", "r"};
        return stringArray;
    }

    public String getTitle() {
        Object[] objectArray = new Object[]{SystemUtil.getResourceString("ConsolidatedAccounts"), new Integer(this.getYear())};
        String string = MessageFormat.format(SystemUtil.getResourceString("SheetTitleLite"), objectArray);
        return string;
    }

    public void print() {
        LineListener lineListener = new LineListener(){

            public int getColumnLine(TableModel tableModel, int n) {
                return 1;
            }

            public int getRowLine(TableModel tableModel, int n) {
                if (tableModel.getRowCount() - 3 == n) {
                    return 1;
                }
                return 0;
            }

            public boolean isStrong(TableModel tableModel, int n, int n2) {
                return false;
            }
        };
        String[] stringArray = this.getAligns();
        int[] nArray = this.getChops();
        TablePrinter tablePrinter = new TablePrinter(this.getTitle(), this, stringArray, nArray, lineListener);
        tablePrinter.print();
    }

    class PLModel
    extends AbstractTableModel {
        int rows;
        String[] columns = new String[]{SystemUtil.getResourceString("Profit"), SystemUtil.getResourceString("Amount"), SystemUtil.getResourceString("Expense"), SystemUtil.getResourceString("Amount")};

        PLModel() {
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<TableElement> arrayList = new ArrayList<TableElement>();
            ArrayList<TableElement> arrayList2 = new ArrayList<TableElement>();
            List list = TGroupProfitLoss.this.info.getProjectManager().getProjects();
            SlipManager slipManager = TGroupProfitLoss.this.info.getSlipManager();
            int n = 0;
            while (n < list.size()) {
                ProjectData projectData = (ProjectData)list.get(n);
                AnnualData annualData = projectData.getAnnual(TGroupProfitLoss.this.getYear());
                if (annualData != null) {
                    Object[] objectArray = new Object[]{projectData.getName(), SystemUtil.getResourceString("Profit")};
                    arrayList.add(new TableElement(MessageFormat.format(SystemUtil.getResourceString("GroupAmountLabel"), objectArray), this.getGroupAmount(3, annualData, slipManager)));
                    Object[] objectArray2 = new Object[]{projectData.getName(), SystemUtil.getResourceString("Expense")};
                    arrayList2.add(new TableElement(MessageFormat.format(SystemUtil.getResourceString("GroupAmountLabel"), objectArray2), this.getGroupAmount(4, annualData, slipManager)));
                }
                ++n;
            }
            TGroupProfitLoss.this.profits = new TAbstract.AbstractTableElement[arrayList.size()];
            TGroupProfitLoss.this.profits = arrayList.toArray(TGroupProfitLoss.this.profits);
            TGroupProfitLoss.this.expenses = new TAbstract.AbstractTableElement[arrayList2.size()];
            TGroupProfitLoss.this.expenses = arrayList2.toArray(TGroupProfitLoss.this.expenses);
            this.rows = TGroupProfitLoss.this.profits.length;
        }

        long getGroupAmount(int n, AnnualData annualData, SlipManager slipManager) {
            ProjectData projectData = annualData.getParent();
            Iterator iterator = projectData.getSubjects().iterator();
            long l = 0L;
            while (iterator.hasNext()) {
                Subject subject = (Subject)iterator.next();
                SubjectCurrentMoney subjectCurrentMoney = annualData.getCurrentMoney(subject.getId());
                if (subjectCurrentMoney == null) continue;
                SubjectGroup subjectGroup = annualData.getParent().getGroupBySubject(subjectCurrentMoney.getId());
                if (subjectGroup == null) {
                    SystemUtil.logMessage("SubjectGroup not found : in TGroupProfitLoss.");
                    continue;
                }
                if (subject.getSpecialLabel() == 3 || subjectGroup.getBalanceGroup() != n) continue;
                l += subjectCurrentMoney.getCurrentAmount(slipManager);
            }
            return l;
        }

        public Class getColumnClass(int n) {
            if (n >= 0 && n <= 3) {
                return "".getClass();
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return this.rows + 2;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (this.rows == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (this.rows + 1 == n) {
                        return SystemUtil.getResourceString("CurrentProfit");
                    }
                    if (TGroupProfitLoss.this.profits.length <= n) break;
                    return TGroupProfitLoss.this.profits[n].getName();
                }
                case 1: {
                    if (this.rows == n) {
                        long l = 0L;
                        int n3 = 0;
                        while (n3 < TGroupProfitLoss.this.profits.length) {
                            l += TGroupProfitLoss.this.profits[n3].getMoney();
                            ++n3;
                        }
                        return TGroupProfitLoss.this.NF.format(l);
                    }
                    if (this.rows + 1 == n) {
                        long l = 0L;
                        int n4 = 0;
                        while (n4 < TGroupProfitLoss.this.profits.length) {
                            l += TGroupProfitLoss.this.profits[n4].getMoney();
                            ++n4;
                        }
                        int n5 = 0;
                        while (n5 < TGroupProfitLoss.this.expenses.length) {
                            l -= TGroupProfitLoss.this.expenses[n5].getMoney();
                            ++n5;
                        }
                        return TGroupProfitLoss.this.NF.format(l);
                    }
                    if (n < TGroupProfitLoss.this.profits.length) {
                        return TGroupProfitLoss.this.NF.format(TGroupProfitLoss.this.profits[n].getMoney());
                    }
                    return "";
                }
                case 2: {
                    if (this.rows == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (TGroupProfitLoss.this.expenses.length <= n) break;
                    return TGroupProfitLoss.this.expenses[n].getName();
                }
                case 3: {
                    if (this.rows == n) {
                        long l = 0L;
                        int n6 = 0;
                        while (n6 < TGroupProfitLoss.this.expenses.length) {
                            l += TGroupProfitLoss.this.expenses[n6].getMoney();
                            ++n6;
                        }
                        return TGroupProfitLoss.this.NF.format(l);
                    }
                    if (TGroupProfitLoss.this.expenses.length <= n) break;
                    return TGroupProfitLoss.this.NF.format(TGroupProfitLoss.this.expenses[n].getMoney());
                }
            }
            return "";
        }
    }

    protected class TableElement
    extends TAbstract.AbstractTableElement {
        String name;
        long money;

        TableElement(String string, long l) {
            this.name = string;
            this.money = l;
        }

        String getName() {
            return this.name;
        }

        long getMoney() {
            return this.money;
        }
    }
}

