/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.NameCommentObject;
import arg.money.ProjectData;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SubjectGroup;
import arg.money.SubjectSubgroup;
import arg.money.SystemUtil;
import arg.money.gui.MyCellRender;
import arg.money.gui.TAbstract;
import arg.money.gui.TAbstractProject;
import arg.money.print.LineListener;
import arg.money.print.TablePrinter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TProfitLoss
extends TAbstractProject {
    TAbstract.AbstractTableElement[] profits;
    TAbstract.AbstractTableElement[] expenses;

    public TProfitLoss(ProjectData projectData, SlipManager slipManager, int n) {
        super(projectData, slipManager, n, SystemUtil.getResourceString("ProfitLossTable"));
        this.setDefaultRenderer("".getClass(), new MyCellRender(this));
    }

    protected AbstractTableModel initModel() {
        PLModel pLModel = new PLModel();
        return pLModel;
    }

    public int[] getChops() {
        int[] nArray = new int[]{12, 16, 12, 16};
        return nArray;
    }

    public String[] getAligns() {
        String[] stringArray = new String[]{"c", "r", "c", "r"};
        return stringArray;
    }

    public void print() {
        LineListener lineListener = new LineListener(){

            public int getColumnLine(TableModel tableModel, int n) {
                return 1;
            }

            public int getRowLine(TableModel tableModel, int n) {
                if (tableModel.getRowCount() - 3 == n) {
                    return 1;
                }
                return 0;
            }

            public boolean isStrong(TableModel tableModel, int n, int n2) {
                return TProfitLoss.this.isStrongCell(n, n2);
            }
        };
        String[] stringArray = this.getAligns();
        int[] nArray = this.getChops();
        TablePrinter tablePrinter = new TablePrinter(this.getTitle(), this, stringArray, nArray, lineListener);
        tablePrinter.print();
    }

    public boolean isStrongCell(int n, int n2) {
        boolean bl = false;
        try {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.profits.length <= n || !(this.profits[n] instanceof TAbstract.SpElement)) break;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    if (this.expenses.length <= n || !(this.expenses[n] instanceof TAbstract.SpElement)) break;
                    bl = true;
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return bl;
    }

    class PLModel
    extends AbstractTableModel {
        int rows;
        String[] columns = new String[]{SystemUtil.getResourceString("Profit"), SystemUtil.getResourceString("Amount"), SystemUtil.getResourceString("Expense"), SystemUtil.getResourceString("Amount")};

        PLModel() {
            Subject subject;
            Serializable serializable;
            NameCommentObject nameCommentObject;
            Iterator iterator;
            Object object;
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            Iterator iterator2 = TProfitLoss.this.project.getSubjects().iterator();
            int n = 0;
            int n2 = 0;
            while (iterator2.hasNext()) {
                object = (Subject)iterator2.next();
                iterator = TProfitLoss.this.project.getGroupBySubject(((Subject)object).getId());
                nameCommentObject = TProfitLoss.this.project.getSubgroupBySubject(((Subject)object).getId());
                serializable = null;
                switch (((SubjectGroup)((Object)iterator)).getBalanceGroup()) {
                    case 3: {
                        serializable = (List)hashMap.get(nameCommentObject);
                        if (serializable == null) {
                            serializable = new LinkedList();
                            hashMap.put(nameCommentObject, serializable);
                            ++n;
                        }
                        serializable.add(object);
                        ++n;
                        break;
                    }
                    case 4: {
                        serializable = (List)hashMap2.get(nameCommentObject);
                        if (serializable == null) {
                            serializable = new LinkedList();
                            hashMap2.put(nameCommentObject, serializable);
                            ++n2;
                        }
                        serializable.add(object);
                        ++n2;
                        break;
                    }
                }
            }
            TProfitLoss.this.profits = new TAbstract.AbstractTableElement[n];
            iterator2 = TProfitLoss.this.getIterator(hashMap);
            n = 0;
            while (iterator2.hasNext()) {
                object = (List)iterator2.next();
                iterator = object.iterator();
                nameCommentObject = (Subject)object.get(0);
                serializable = TProfitLoss.this.project.getSubgroupBySubject(((Subject)nameCommentObject).getId());
                TProfitLoss.this.profits[n++] = new TAbstract.SpElement(((SubjectSubgroup)serializable).getName());
                while (iterator.hasNext()) {
                    subject = (Subject)iterator.next();
                    TProfitLoss.this.profits[n++] = new TAbstractProject.TableElement(subject);
                }
            }
            TProfitLoss.this.expenses = new TAbstract.AbstractTableElement[n2];
            iterator2 = TProfitLoss.this.getIterator(hashMap2);
            n2 = 0;
            while (iterator2.hasNext()) {
                object = (List)iterator2.next();
                iterator = object.iterator();
                nameCommentObject = (Subject)object.get(0);
                serializable = TProfitLoss.this.project.getSubgroupBySubject(((Subject)nameCommentObject).getId());
                TProfitLoss.this.expenses[n2++] = new TAbstract.SpElement(((SubjectSubgroup)serializable).getName());
                while (iterator.hasNext()) {
                    subject = (Subject)iterator.next();
                    TProfitLoss.this.expenses[n2++] = new TAbstractProject.TableElement(subject);
                }
            }
            this.rows = Math.max(TProfitLoss.this.profits.length + 1, TProfitLoss.this.expenses.length + 1);
        }

        public Class getColumnClass(int n) {
            if (n >= 0 && n <= 3) {
                return "".getClass();
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return this.rows + 1;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (this.rows - 1 == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (this.rows == n) {
                        return SystemUtil.getResourceString("CurrentProfit");
                    }
                    if (TProfitLoss.this.profits.length <= n) break;
                    return TProfitLoss.this.profits[n].getName();
                }
                case 1: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n3 = 0;
                        while (n3 < TProfitLoss.this.profits.length) {
                            l += TProfitLoss.this.profits[n3].getMoney();
                            ++n3;
                        }
                        return TProfitLoss.this.NF.format(l);
                    }
                    if (this.rows == n) {
                        long l = 0L;
                        int n4 = 0;
                        while (n4 < TProfitLoss.this.profits.length) {
                            l += TProfitLoss.this.profits[n4].getMoney();
                            ++n4;
                        }
                        int n5 = 0;
                        while (n5 < TProfitLoss.this.expenses.length) {
                            l -= TProfitLoss.this.expenses[n5].getMoney();
                            ++n5;
                        }
                        return TProfitLoss.this.NF.format(l);
                    }
                    if (TProfitLoss.this.profits.length <= n) break;
                    if (TProfitLoss.this.profits[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TProfitLoss.this.NF.format(TProfitLoss.this.profits[n].getMoney());
                }
                case 2: {
                    if (this.rows - 1 == n) {
                        return SystemUtil.getResourceString("Total");
                    }
                    if (TProfitLoss.this.expenses.length <= n) break;
                    return TProfitLoss.this.expenses[n].getName();
                }
                case 3: {
                    if (this.rows - 1 == n) {
                        long l = 0L;
                        int n6 = 0;
                        while (n6 < TProfitLoss.this.expenses.length) {
                            l += TProfitLoss.this.expenses[n6].getMoney();
                            ++n6;
                        }
                        return TProfitLoss.this.NF.format(l);
                    }
                    if (TProfitLoss.this.expenses.length <= n) break;
                    if (TProfitLoss.this.expenses[n] instanceof TAbstract.SpElement) {
                        return "";
                    }
                    return TProfitLoss.this.NF.format(TProfitLoss.this.expenses[n].getMoney());
                }
            }
            return "";
        }
    }
}

