/*
 * Decompiled with CFR 0.152.
 */
package arg.money.gui;

import arg.money.ASlipLine;
import arg.money.ProjectData;
import arg.money.ProjectManager;
import arg.money.SlipElement;
import arg.money.SlipManager;
import arg.money.Subject;
import arg.money.SystemUtil;
import arg.money.TransferSlip;
import arg.money.UserManager;
import arg.money.gui.CellManager;
import arg.money.gui.MyCellRender;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class TSlips
extends JTable
implements CellManager {
    protected NumberFormat NF = NumberFormat.getInstance();
    protected ProjectData project;
    protected ProjectManager projectManager;
    protected SlipManager manager;
    protected UserManager userManager;
    protected SlipLineModel model;
    protected long[] amounts = new long[]{0L, 0L};
    protected int leftFilter = -1;
    protected int rightFilter = -1;
    public String[] titles = new String[]{SystemUtil.getResourceString("Date"), SystemUtil.getResourceString("ReceiptNo"), SystemUtil.getResourceString("User"), SystemUtil.getResourceString("SubjectName"), SystemUtil.getResourceString("Credit"), SystemUtil.getResourceString("Summary"), SystemUtil.getResourceString("Debtor"), SystemUtil.getResourceString("SubjectName")};
    public String[] aligns = new String[]{"c", "c", "c", "c", "r", "c", "r", "c"};
    public int[] lengthes = new int[]{12, 5, 8, 6, 12, 10, 12, 6};
    List slips;

    public TSlips(SlipManager slipManager, int n, List list) {
        this.manager = slipManager;
        this.projectManager = this.manager.getParent().getProjectManager();
        this.project = this.projectManager.getProjectData(n);
        this.userManager = slipManager.getParent().getSecurityManager().getUserManager();
        if (list == null) {
            list = this.manager.getList(this.manager.query(this.project.getCurYear(), this.project.getId()));
        }
        this.setDefaultRenderer("".getClass(), new MyCellRender(this, this.aligns));
        this.setSlips(list, n, -1, -1);
    }

    public void setSlips(List list, int n, int n2, int n3) {
        this.slips = list;
        this.project = this.projectManager.getProjectData(n);
        this.leftFilter = n2;
        this.rightFilter = n3;
        this.amounts[0] = 0L;
        this.amounts[1] = 0L;
        this.initModel();
    }

    public long[] getAmounts() {
        return this.amounts;
    }

    public ASlipLine getLine(int n) {
        try {
            return (ASlipLine)this.model.elements.get(n);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
    }

    public List getSlips() {
        return this.slips;
    }

    void initModel() {
        this.model = new SlipLineModel(this.slips);
        this.setModel(this.model);
    }

    void update() {
        this.tableChanged(new TableModelEvent(this.model));
    }

    public AbstractTableModel getMyModel() {
        return this.model;
    }

    public boolean isStrongCell(int n, int n2) {
        try {
            return this.getLine(n).getParent().isLocked();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return false;
        }
    }

    class SlipLineModel
    extends AbstractTableModel {
        List curSlips;
        Subject subject;
        List elements;

        SlipLineModel(List list) {
            this.curSlips = list;
            this.elements = new ArrayList();
            Iterator iterator = this.curSlips.iterator();
            while (iterator.hasNext()) {
                TransferSlip transferSlip = (TransferSlip)iterator.next();
                Iterator iterator2 = transferSlip.getLines().iterator();
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    ASlipLine aSlipLine = (ASlipLine)iterator2.next();
                    boolean bl = true;
                    if (TSlips.this.leftFilter != -1 && aSlipLine.getLeft().getId() != TSlips.this.leftFilter) {
                        bl = false;
                    }
                    if (TSlips.this.rightFilter != -1 && aSlipLine.getRight().getId() != TSlips.this.rightFilter) {
                        bl = false;
                    }
                    if (!bl) continue;
                    long l = Math.min(aSlipLine.getLeft().getMoney(), aSlipLine.getRight().getMoney());
                    TSlips.this.amounts[0] = TSlips.this.amounts[0] + l;
                    TSlips.this.amounts[1] = TSlips.this.amounts[1] + l;
                    this.elements.add(aSlipLine);
                }
            }
        }

        TransferSlip getSlip(int n) {
            if (n >= 0 && n < this.elements.size()) {
                ASlipLine aSlipLine = (ASlipLine)this.elements.get(n);
                return aSlipLine.getParent();
            }
            return null;
        }

        public Class getColumnClass(int n) {
            if (n >= 0 && n <= 7) {
                return "".getClass();
            }
            return super.getColumnClass(n);
        }

        public int getColumnCount() {
            return TSlips.this.titles.length;
        }

        public int getRowCount() {
            return this.elements.size();
        }

        public String getColumnName(int n) {
            return TSlips.this.titles[n];
        }

        public Object getValueAt(int n, int n2) {
            ASlipLine aSlipLine = (ASlipLine)this.elements.get(n);
            switch (n2) {
                case 0: {
                    return StringUtil.datel(aSlipLine.getParent().getDate());
                }
                case 1: {
                    return Integer.toString(aSlipLine.getParent().getReceiptNumber());
                }
                case 2: {
                    return TSlips.this.userManager.getUser(aSlipLine.getParent().getUid()).getName();
                }
                case 3: {
                    return TSlips.this.project.getSubject(aSlipLine.getLeft().getId()).getName();
                }
                case 4: 
                case 6: {
                    SlipElement slipElement = aSlipLine.getRight();
                    SlipElement slipElement2 = aSlipLine.getLeft();
                    long l = slipElement2.getMoney();
                    long l2 = slipElement.getMoney();
                    return TSlips.this.NF.format(Math.min(l, l2));
                }
                case 5: {
                    return aSlipLine.getSummary();
                }
                case 7: {
                    return TSlips.this.project.getSubject(aSlipLine.getRight().getId()).getName();
                }
            }
            return null;
        }
    }
}

