/*
 * Decompiled with CFR 0.152.
 */
package arg.money.print;

import arg.money.print.LineListener;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.gr.java_conf.ccs2.io.EasyWriter;

public class TablePrinter {
    JTable table;
    int maxRows = 43;
    int[] lengthes;
    String[] aligns;
    LineListener liner;
    HashMap hash = new HashMap();
    String title;

    public String getString(String string) {
        return (String)this.hash.get(string);
    }

    void init() {
        this.hash.put("pageBegin", "\\documentclass[9pt]{jarticle} \\topmargin=-0.8in \\oddsidemargin=-0.3in \\evensidemargin=-0.3in \\textheight47\\baselineskip \\textwidth 50zw \\def\\Hline{\\noalign{\\hrule height1pt}}");
        this.hash.put("titleBegin", "\\title{");
        this.hash.put("titleEnd", "}");
        this.hash.put("docBegin", "\\begin{document} \\maketitle \\begin{center}");
        this.hash.put("docEnd", "\\end{center} \\end{document}");
        this.hash.put("pageEnd", "");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.aligns.length) {
            stringBuffer.append(this.aligns[n]);
            int n2 = this.liner.getColumnLine(this.table.getModel(), n);
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append("|");
                    ++n3;
                }
            }
            ++n;
        }
        String string = "\\begin{tabular}{|" + stringBuffer.toString() + "} \\hline";
        this.hash.put("tableBegin", string);
        this.hash.put("tableEnd", "\\end{tabular}");
        this.hash.put("tableReturn", "\\\\");
        this.hash.put("hline", "\\hline");
        this.hash.put("Hline", "\\Hline");
        this.hash.put("Dline", "\\hline\\hline");
        this.hash.put("bfBegin", "\\bf{");
        this.hash.put("bfEnd", "}");
        this.hash.put("newpage", "\\newpage");
    }

    public TablePrinter(String string, JTable jTable, String[] stringArray, int[] nArray) {
        this(string, jTable, stringArray, nArray, null);
    }

    public TablePrinter(String string, JTable jTable, String[] stringArray, int[] nArray, LineListener lineListener) {
        int n;
        int n2;
        TableModel tableModel;
        this.table = jTable;
        this.title = string;
        if (stringArray == null) {
            tableModel = jTable.getModel();
            n2 = tableModel.getColumnCount();
            stringArray = new String[n2];
            n = 0;
            while (n < n2) {
                stringArray[n] = "l";
                ++n;
            }
        }
        this.aligns = stringArray;
        if (nArray == null) {
            tableModel = jTable.getModel();
            n2 = tableModel.getColumnCount();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = 12;
                ++n;
            }
        }
        this.lengthes = nArray;
        if (lineListener == null) {
            lineListener = new LineListener(){

                public int getColumnLine(TableModel tableModel, int n) {
                    return 1;
                }

                public int getRowLine(TableModel tableModel, int n) {
                    if (n % 5 == 4) {
                        return 1;
                    }
                    return 0;
                }

                public boolean isStrong(TableModel tableModel, int n, int n2) {
                    return false;
                }
            };
        }
        this.liner = lineListener;
        this.init();
    }

    public void print() {
        EasyWriter easyWriter = new EasyWriter("temp.tex");
        easyWriter.println(this.getString("pageBegin"));
        easyWriter.println(this.getString("titleBegin"));
        easyWriter.println(this.title);
        easyWriter.println(this.getString("titleEnd"));
        easyWriter.println(this.getString("docBegin"));
        int n = 0;
        while (n >= 0) {
            if (n != 0) {
                easyWriter.println(this.getString("newpage"));
            }
            n = this.outputPage(easyWriter, this.table, n);
        }
        easyWriter.println(this.getString("docEnd"));
        easyWriter.println(this.getString("pageEnd"));
        easyWriter.close();
        System.gc();
    }

    private int outputPage(EasyWriter easyWriter, JTable jTable, int n) {
        easyWriter.println(this.getString("tableBegin"));
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        int n2 = tableColumnModel.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0) {
                easyWriter.print(" & ");
            }
            TableColumn tableColumn = tableColumnModel.getColumn(n3);
            String string = (String)tableColumn.getIdentifier();
            easyWriter.print(this.getString("bfBegin"));
            easyWriter.print(string);
            easyWriter.print(this.getString("bfEnd"));
            ++n3;
        }
        easyWriter.println(this.getString("tableReturn"));
        easyWriter.println(this.getString("Dline"));
        int n4 = this.maxRows;
        if (n == 0) {
            n4 -= 10;
        }
        int n5 = n;
        int n6 = n;
        while (n6 < tableModel.getRowCount() && n6 - n < n4) {
            int n7 = 0;
            while (n7 < tableModel.getColumnCount()) {
                Object object;
                if (n7 != 0) {
                    easyWriter.print(" & ");
                }
                if ((object = tableModel.getValueAt(n6, n7)) == null) {
                    object = new String("");
                }
                if (this.liner.isStrong(tableModel, n6, n7)) {
                    easyWriter.print(this.getString("bfBegin"));
                }
                easyWriter.print(this.chop(object.toString(), n7));
                if (this.liner.isStrong(tableModel, n6, n7)) {
                    easyWriter.print(this.getString("bfEnd"));
                }
                ++n7;
            }
            easyWriter.println(this.getString("tableReturn"));
            int n8 = this.liner.getRowLine(tableModel, n6);
            if (n8 > 0) {
                int n9 = 0;
                while (n9 < n8) {
                    easyWriter.println(this.getString("hline"));
                    ++n9;
                }
            } else if (n8 < 0) {
                easyWriter.println(this.getString("Hline"));
            }
            ++n5;
            ++n6;
        }
        if (n5 >= tableModel.getRowCount()) {
            n5 = -1;
        }
        easyWriter.println(this.getString("hline"));
        easyWriter.println(this.getString("tableEnd"));
        return n5;
    }

    private String chop(String string, int n) {
        if (string.length() > this.lengthes[n]) {
            return string.substring(0, this.lengthes[n]) + "...";
        }
        return string;
    }
}

