/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import jp.gr.java_conf.ccs2.comp.FontInfo;
import jp.gr.java_conf.ccs2.comp.OriginalFont;

public class RichString {
    protected FontInfo orgFont;
    protected int fontNumber = 0;
    protected String contents;
    protected int voff = 3;
    protected int hoff = 3;
    private int ac;
    private int dc;
    private boolean changed = true;
    private Dimension currentSize;

    public RichString() {
        this("", Color.black, null, new Font("SansSerif", 0, 12));
    }

    public RichString(String string, Color color, Color color2, Font font) {
        this.contents = string;
        this.orgFont = new OriginalFont(color, color2, font);
    }

    public RichString(String string, FontInfo fontInfo) {
        this(string, fontInfo, 0);
    }

    public RichString(String string, FontInfo fontInfo, int n) {
        this.contents = string;
        this.orgFont = fontInfo;
        this.fontNumber = n;
    }

    void setFontInfo(FontInfo fontInfo) {
        this.orgFont = fontInfo;
        this.changed = true;
    }

    void setFontNumber(int n) {
        this.fontNumber = n;
        this.changed = true;
    }

    public void setContents(String string) {
        this.contents = string;
        this.changed = true;
    }

    public String getContents() {
        return this.contents;
    }

    public FontInfo getFontInfo() {
        return this.orgFont;
    }

    public Color getForeground() {
        return this.orgFont.getColor(0);
    }

    public Color getBackground() {
        return this.orgFont.getColor(1);
    }

    public Font getFont() {
        return this.orgFont.getFont(this.fontNumber);
    }

    public int getVarticalOffset() {
        return this.voff;
    }

    public int getHolizontalOffset() {
        return this.hoff;
    }

    public void setVarticalOffset(int n) {
        this.voff = n;
    }

    public void setHolizontalOffset(int n) {
        this.hoff = n;
    }

    public Dimension getSize(Component component) {
        if (this.changed) {
            this.mesureSize(component.getFontMetrics(this.getFont()));
        }
        return this.currentSize;
    }

    public Dimension getSize(Graphics graphics) {
        if (this.changed) {
            this.mesureSize(graphics.getFontMetrics(this.getFont()));
        }
        return this.currentSize;
    }

    protected void mesureSize(FontMetrics fontMetrics) {
        this.currentSize = new Dimension();
        if (fontMetrics != null) {
            this.currentSize.height = fontMetrics.getHeight() + this.voff * 2;
            this.currentSize.width = fontMetrics.stringWidth(this.contents) + this.hoff * 2;
            this.ac = fontMetrics.getAscent();
            this.dc = fontMetrics.getDescent();
            this.changed = false;
        } else {
            System.out.println("Null FontMetrics");
            this.currentSize.height = this.getFont().getSize() + this.hoff * 2;
            this.currentSize.width = this.getFont().getSize() * this.contents.length();
        }
    }

    public Dimension drawContents(Graphics graphics, int n, int n2) {
        Dimension dimension = this.getSize(graphics);
        Color color = this.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n, n2, dimension.width, dimension.height);
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawString(this.contents, n += this.hoff, n2 += this.ac + this.voff);
        return dimension;
    }
}

