/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.gr.java_conf.ccs2.comp.ColorInfo;
import jp.gr.java_conf.ccs2.comp.FontInfo;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.OriginalFont;
import jp.gr.java_conf.ccs2.comp.Shader;
import jp.gr.java_conf.ccs2.comp.TabItem;
import jp.gr.java_conf.ccs2.util.ColorEditor;

public class TabCtrl
extends Panel
implements FontInfo,
ColorInfo {
    Vector parents = new Vector();
    Hashtable table = new Hashtable();
    String activeTab = "";
    boolean isRepaint = false;
    int stringHeight = 15;
    int bottomOffset = 2;
    int topOffset = 1;
    int varticalOffset = 2;
    int horizontalOffset = 3;
    int delta = 2;
    int cutSize = 2;
    double spaceParam = 1.2;
    Color darkGray = Color.darkGray;
    Color lightGray = Color.white;
    Color gray = Color.gray;
    Color forground = Color.black;
    Color background = Color.lightGray;
    static final int DARKGRAY = 2;
    static final int LIGHTGRAY = 3;
    static final int GRAY = 4;
    Font font1;
    Font font2;
    OriginalFont orgFont;
    OriginalFont sFont;

    public TabCtrl() {
        this.initFont();
        this.initLayout();
        this.setBackground(this.background);
    }

    public TabCtrl(MessageListener messageListener) {
        this();
        this.addMessageListener(messageListener);
    }

    public void addMessageListener(MessageListener messageListener) {
        this.parents.addElement(messageListener);
    }

    public void setFont(int n) {
        this.setFont(n, 0);
    }

    public void setFont(int n, int n2) {
        this.stringHeight = (int)((double)n * 1.5);
        Font font = null;
        font = this.font1 == null ? new Font("SansSerif", 0, n) : new Font(this.font1.getName(), this.font1.getStyle(), n);
        this.setFont(font, n2);
    }

    public void setFont(Font font) {
        this.setFont(font, font.getStyle());
    }

    public void setFont(Font font, int n) {
        this.font1 = font;
        this.font2 = new Font(font.getName(), n, font.getSize());
        this.orgFont = new OriginalFont(this.forground, this.background, this.font1);
        this.sFont = new OriginalFont(this.forground, this.background, this.font2);
    }

    public void setColor(Color color, Color color2) {
        this.forground = color;
        this.background = color2;
        this.setBackground(color2);
        this.lightGray = ColorEditor.getBrighter(color2);
        this.darkGray = ColorEditor.getDarker(color2);
        this.orgFont.setColor(this.background, this.forground);
        this.sFont.setColor(this.background, ColorEditor.getDarker(this.forground));
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ((TabItem)enumeration.nextElement()).updateInfo();
        }
        this.updateImmediate();
    }

    public void setTabName(String string, String string2) {
        TabItem tabItem = (TabItem)this.table.get(string);
        if (tabItem == null) {
            return;
        }
        tabItem.setTabName(string2);
        this.isRepaint = true;
        this.updateImmediate();
    }

    public void addTab(String string, String string2) {
        if (this.table.containsKey(string2)) {
            System.out.println("TabCtrl warning : the same key[" + string2 + "]");
            return;
        }
        TabItem tabItem = new TabItem(string, string2, this);
        this.add(tabItem);
        this.table.put(string2, tabItem);
        if (this.table.size() == 1) {
            tabItem.setActive(true);
            this.activeTab = string2;
            this.setActive(string2);
        }
        this.isRepaint = true;
        TabItem tabItem2 = (TabItem)this.table.get(this.getActive());
        if (tabItem2 == null) {
            this.getParent().doLayout();
        } else {
            this.updateImmediate();
        }
    }

    public String getActive() {
        return this.activeTab;
    }

    public void removeTab(String string) {
        TabItem tabItem = (TabItem)this.table.remove(string);
        if (tabItem != null) {
            this.remove(tabItem);
        }
        this.setActive(null);
        this.isRepaint = true;
    }

    public void removeAllTabs() {
        this.table.clear();
        this.removeAll();
        this.isRepaint = true;
    }

    public void setActive(String string) {
        if (this.table.isEmpty()) {
            return;
        }
        TabItem tabItem = string == null ? (TabItem)this.getComponent(1) : (TabItem)this.table.get(string);
        this.selectTab(tabItem);
    }

    int getCutSize() {
        return this.cutSize;
    }

    double getSpaceParam() {
        return this.spaceParam;
    }

    int getDelta() {
        return this.delta;
    }

    OriginalFont getSelectedFontInfo() {
        return this.sFont;
    }

    OriginalFont getFontInfo() {
        return this.orgFont;
    }

    int getStringHeight() {
        return this.stringHeight;
    }

    int getBottomOffset() {
        return this.bottomOffset;
    }

    int getTopOffset() {
        return this.topOffset;
    }

    int getVarticalOffset() {
        return this.varticalOffset;
    }

    int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    int getTotalWidth(int n) {
        return (int)((double)n * this.getSpaceParam()) + this.getHorizontalOffset() * 2;
    }

    int getTotalHeight(int n) {
        return n + this.getVarticalOffset() * 2 + this.getTopOffset() + this.getBottomOffset() + this.delta * 2;
    }

    public void addNotify() {
        super.addNotify();
        int n = 0;
        int n2 = 0;
        if (!this.table.isEmpty()) {
            Enumeration enumeration = this.table.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                Dimension dimension = component.getSize();
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
        } else {
            n = 120;
            n2 = 40;
        }
        this.setSize(n + 2, n2);
    }

    public void update(Graphics graphics) {
        if (this.isRepaint) {
            this.isRepaint = false;
        }
        super.update(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.table.isEmpty()) {
            graphics.drawString("no tab item...", 10, 5);
        }
    }

    public Font getFont(int n) {
        return this.font1;
    }

    public Color getColor(int n) {
        switch (n) {
            case 0: {
                return this.forground;
            }
            case 1: {
                return this.background;
            }
            case 3: {
                return this.lightGray;
            }
            case 4: {
                return this.gray;
            }
        }
        return this.darkGray;
    }

    protected void selectTab(TabItem tabItem) {
        TabItem tabItem2 = (TabItem)this.table.get(this.getActive());
        if (tabItem == tabItem2) {
            return;
        }
        tabItem.setActive(true);
        if (tabItem2 != null) {
            tabItem2.setActive(false);
        }
        this.updateImmediate();
        this.activeTab = tabItem.getKey();
        this.sendMessage(tabItem);
    }

    protected void sendMessage(TabItem tabItem) {
        if (this.parents.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.parents.elements();
        while (enumeration.hasMoreElements()) {
            ((MessageListener)enumeration.nextElement()).message("tab", 0, tabItem.getKey());
        }
    }

    private void initFont() {
        this.setFont(this.stringHeight);
    }

    private void initLayout() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBackground(this.background);
        this.isRepaint = true;
    }

    private void updateImmediate() {
        this.invalidate();
        this.doLayout();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("test tab");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Shader shader = new Shader("Tab Component", 0xCCCCCC, 0xFFFFFF, 0x99BB99, "SansSerif", 0, 3);
        frame.add((Component)shader, "Center");
        TabCtrl tabCtrl = new TabCtrl();
        frame.add((Component)tabCtrl, "North");
        tabCtrl.addTab("first", "first");
        tabCtrl.addTab("tab", "message");
        tabCtrl.addTab("This", "this");
        tabCtrl.addTab("test TabCtrl.", "tab tab");
        tabCtrl.addTab("Ok?", "this is key");
        tabCtrl.setFont(16);
        tabCtrl.setColor(Color.blue.darker(), ColorEditor.getMixed(Color.red, Color.white));
        final TextField textField = new TextField();
        frame.add((Component)textField, "South");
        tabCtrl.addMessageListener(new MessageListener(){

            public void message(String string, int n, Object object) {
                textField.setText((String)object);
            }
        });
        frame.pack();
        frame.show();
    }
}

