/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jp.gr.java_conf.ccs2.comp.RichString;
import jp.gr.java_conf.ccs2.comp.TabCtrl;

class TabItem
extends Canvas {
    RichString contents;
    TabCtrl parent;
    boolean active;
    boolean isRepaint;
    String key;

    TabItem(String string, String string2, TabCtrl tabCtrl) {
        this.contents = new RichString(string, tabCtrl.getFontInfo());
        this.parent = tabCtrl;
        this.key = string2;
        this.isRepaint = true;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TabItem.this.parent.selectTab(TabItem.this);
            }
        });
    }

    public void updateInfo() {
        if (this.isActive()) {
            this.contents.setFontInfo(this.parent.getSelectedFontInfo());
        } else {
            this.contents.setFontInfo(this.parent.getFontInfo());
        }
        this.repaint();
    }

    String getKey() {
        return this.key;
    }

    void setActive(boolean bl) {
        this.active = bl;
        this.updateInfo();
    }

    boolean isActive() {
        return this.active;
    }

    String getTabName() {
        return this.contents.getContents();
    }

    void setTabName(String string) {
        this.contents.setContents(string);
        this.isRepaint = true;
    }

    protected Color getDarkGray() {
        return this.parent.getColor(2);
    }

    protected Color getLightGray() {
        return this.parent.getColor(3);
    }

    protected Color getTabForground() {
        return this.parent.getColor(0);
    }

    protected Color getTabBackground() {
        return this.parent.getColor(1);
    }

    protected Color getGray() {
        return this.parent.getColor(4);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.mesureSize();
        this.setSize(this.parent.getTotalWidth(dimension.width), this.parent.getTotalHeight(dimension.height));
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    protected Dimension mesureSize() {
        Dimension dimension = this.contents.getSize(this);
        return dimension;
    }

    public void update(Graphics graphics) {
        if (this.isActive()) {
            this.contents.setFontInfo(this.parent.getSelectedFontInfo());
        } else {
            this.contents.setFontInfo(this.parent.getFontInfo());
        }
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension;
        if (this.isRepaint) {
            dimension = this.contents.getSize(graphics);
            this.setSize(this.parent.getTotalWidth(dimension.width), this.parent.getTotalHeight(dimension.height));
            this.isRepaint = false;
            this.parent.doLayout();
        }
        if ((dimension = this.getSize()) == null) {
            this.isRepaint = true;
            return;
        }
        Color color = this.getTabBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        int n = this.parent.getDelta();
        --dimension.width;
        --dimension.height;
        int n2 = n;
        if (this.isActive()) {
            n2 = 0;
        }
        int n3 = n2;
        int n4 = this.parent.getTopOffset() + n2;
        int n5 = dimension.width + n2 - n;
        int n6 = dimension.height - this.parent.getBottomOffset();
        graphics.setColor(this.getTabForground());
        this.contents.drawContents(graphics, n3 + this.parent.getHorizontalOffset(), n4 + this.parent.getVarticalOffset());
        graphics.setColor(this.getGray());
        graphics.drawLine(n3, n4 + this.parent.getCutSize(), n3, n6);
        graphics.drawLine(n3, n4 + this.parent.getCutSize(), n3 + this.parent.getCutSize(), n4);
        graphics.drawLine(n3 + this.parent.getCutSize(), n4, n5, n4);
        graphics.drawLine(n5 - 1, n4 + 1, n5 - 1, n6);
        graphics.setColor(this.getTabBackground());
        if (!this.isActive()) {
            graphics.fillRect(0, n6, n5 + n, n6 + this.parent.getBottomOffset());
        } else {
            graphics.drawLine(n5, n6, n5 + n, n6);
            graphics.fillRect(n5 + 1, n4 + 2, n, n6 - 3 - n4);
        }
        graphics.setColor(this.getLightGray());
        graphics.drawLine(n3 + 1, n4 + this.parent.getCutSize(), n3 + 1, n6 - 1);
        graphics.drawLine(n3 + 1, n4 + this.parent.getCutSize(), n3 + this.parent.getCutSize(), n4 + 1);
        graphics.drawLine(n3 + this.parent.getCutSize(), n4 + 1, n5 - 2, n4 + 1);
        if (!this.isActive()) {
            graphics.drawLine(0, n6, n5 + n, n6);
        } else {
            graphics.drawLine(n5, n6, n5 + n, n6);
        }
        graphics.setColor(this.getDarkGray());
        graphics.drawLine(n5, n4, n5, n6 - 1);
    }
}

