/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.util.Hashtable;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.Shader;
import jp.gr.java_conf.ccs2.comp.TabCtrl;
import jp.gr.java_conf.ccs2.comp.WFrame;

public class TabPanel
extends Panel {
    protected TabCtrl tabs;
    protected CardLayout layout;
    protected Panel client;
    protected Hashtable comps = new Hashtable();
    private int address = 0;

    public TabPanel() {
        this((MessageListener)null);
    }

    public TabPanel(MessageListener messageListener) {
        this.init();
        if (messageListener != null) {
            this.addMessageListener(messageListener);
        }
    }

    public String addPage(Component component, String string) {
        String string2 = this.getID();
        this.client.add(component, string2);
        this.tabs.addTab(string, string2);
        this.comps.put(string2, component);
        this.doLayout();
        return string2;
    }

    public String add(Component component, String string) {
        return this.addPage(component, string);
    }

    public void remove(String string) {
        try {
            Component component = (Component)this.comps.get(string);
            this.client.remove(component);
            this.tabs.removeTab(string);
            this.comps.remove(string);
            String string2 = this.tabs.getActive();
            this.change(string2);
        }
        catch (Exception exception) {
            System.out.println("TabPanel:removal error. (" + string + ")");
        }
    }

    public void removeAll() {
        try {
            this.client.removeAll();
            this.tabs.removeAllTabs();
            this.comps.clear();
        }
        catch (Exception exception) {
            System.out.println("TabPanel:removal error. ");
        }
    }

    public void change(String string) {
        this.tabs.setActive(string);
        this.layout.show(this.client, string);
        this.doLayout();
    }

    public String getActive() {
        return this.tabs.getActive();
    }

    public void addMessageListener(MessageListener messageListener) {
        this.tabs.addMessageListener(messageListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    public void doLayout() {
        super.doLayout();
        this.client.doLayout();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.layout = new CardLayout();
        this.client = new Panel();
        this.client.setLayout(this.layout);
        this.tabs = new TabCtrl();
        this.tabs.addMessageListener(new MessageListener(){

            public void message(String string, int n, Object object) {
                TabPanel.this.change((String)object);
            }
        });
        super.add((Component)this.tabs, "North");
        super.add((Component)this.client, "Center");
    }

    private String getID() {
        ++this.address;
        return "t" + this.address;
    }

    public static void main(String[] stringArray) {
        WFrame wFrame = new WFrame("tab panel test");
        TabPanel tabPanel = new TabPanel();
        tabPanel.add((Component)new Shader("hello label"), "hello");
        tabPanel.add((Component)new Label("Second Pane"), "second");
        tabPanel.add((Component)new Label("Next generation"), "Next generations!");
        wFrame.add(tabPanel);
        ((Component)wFrame).setSize(400, 300);
        wFrame.show();
    }
}

