/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class MessageMonitor {
    public static final int DEBUG = 0;
    public static final int VERBOSE = 1;
    public static final int NORMAL = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final String FORMAT_DATE = "%date%";
    public static final String FORMAT_LEVEL = "%level%";
    public static final String FORMAT_MESSAGE = "%message%";
    private static final String[] words = new String[]{"DEBUG", "VERBSE", "NORMAL", "WARNING", "ERROR"};
    String filename;
    PrintStream out;
    int logLevel;
    String format = "%date%|%level%|%message%";
    public static final String defaultName = "ccslog.txt";
    protected static MessageMonitor monitor = new MessageMonitor("ccslog.txt", 2, System.out);

    public MessageMonitor(String string, int n, PrintStream printStream) {
        this.filename = string;
        this.logLevel = n;
        this.out = printStream;
    }

    public MessageMonitor() {
        this(null, 2, System.out);
    }

    public MessageMonitor(int n) {
        this(null, n, System.out);
    }

    public MessageMonitor(String string) {
        this(string, 2, null);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int n) {
        if (n >= 0 && n <= 4) {
            this.logLevel = n;
        }
    }

    public PrintStream getOutput() {
        return this.out;
    }

    public void setOutput(PrintStream printStream) {
        this.out = printStream;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void debug(String string) {
        this.message(string, 0);
    }

    public void verbose(String string) {
        this.message(string, 1);
    }

    public void normal(String string) {
        this.message(string, 2);
    }

    public void warning(String string) {
        this.message(string, 3);
    }

    public void error(String string) {
        this.message(string, 4);
    }

    protected void message(String string, int n) {
        if (this.logLevel > n) {
            return;
        }
        String string2 = this.formatMessage(string, n);
        if (this.out != null) {
            this.out.println(string2);
        }
        if (this.filename != null) {
            try {
                FileWriter fileWriter = new FileWriter(this.filename, true);
                fileWriter.write(string2 + System.getProperty("line.separator"));
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.err.println("fatal error : IOException at MessageMonitor.");
                System.err.println(string2);
            }
        }
    }

    String formatMessage(String string, int n) {
        String string2 = StringUtil.replace(this.format, FORMAT_LEVEL, words[n]);
        Date date = new Date();
        string2 = StringUtil.replace(string2, FORMAT_DATE, date.toString());
        return StringUtil.replace(string2, FORMAT_MESSAGE, string);
    }

    public static void errorLog(String string) {
        monitor.error(string);
    }

    public static void warningLog(String string) {
        monitor.warning(string);
    }

    public static void messageLog(String string) {
        monitor.normal(string);
    }
}

