/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.io;

import java.io.BufferedReader;
import java.io.IOException;

public abstract class AbstractReader {
    protected BufferedReader input;

    protected AbstractReader(BufferedReader bufferedReader) {
        this.input = bufferedReader;
    }

    public boolean isOk() {
        if (this.input == null) {
            return false;
        }
        try {
            return this.input.ready();
        }
        catch (IOException iOException) {
            System.err.println("IOException in AbstractReader.isOk()");
            return false;
        }
    }

    public BufferedReader getReader() {
        return this.input;
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            System.err.println(" I/O exception durin closing in AbstractReader.");
        }
    }

    public boolean isEOF() {
        try {
            return !this.input.ready();
        }
        catch (IOException iOException) {
            System.err.println(" I/O exception during EOF check in AbstractReader.");
            return false;
        }
    }

    public String read() {
        try {
            return this.input.readLine();
        }
        catch (IOException iOException) {
            System.err.println(" I/O Exception during reading a line in AbstractReader.");
            return "";
        }
    }

    public int readInteger() {
        try {
            return Integer.parseInt(this.read());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long readLong() {
        try {
            return Long.parseLong(this.read());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public double readDouble() {
        try {
            return Double.valueOf(this.read());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public String read(String string) {
        try {
            return this.input.readLine();
        }
        catch (IOException iOException) {
            System.err.println(" I/O Exception during reading a line in AbstractReader.");
            return string;
        }
    }

    public int readInteger(int n) {
        try {
            return Integer.parseInt(this.read());
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long readLong(long l) {
        try {
            return Long.parseLong(this.read());
        }
        catch (Exception exception) {
            return l;
        }
    }

    public double readDouble(double d) {
        try {
            return Double.valueOf(this.read());
        }
        catch (Exception exception) {
            return d;
        }
    }
}

