/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.awt.Color;

public class ColorSet {
    public static Color[] geographIndex = new Color[]{new Color(0xCC00CC), Color.blue, Color.cyan, Color.yellow, Color.green, Color.red};
    public static Color[] rainbowIndex = new Color[]{new Color(0xCC00CC), Color.blue, Color.green, Color.yellow, Color.orange, Color.red};
    protected Color[] index;
    boolean rev = false;

    public ColorSet(Color color, Color color2, int n) {
        this.index = ColorSet.makeColorIndex(color, color2, n);
    }

    public ColorSet(Color[] colorArray, int n) {
        this.index = ColorSet.makeColorIndex(colorArray, n);
    }

    public static Color[] makeColorIndex(Color color, Color color2, int n) {
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        int n4 = n3 >> 16 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = n3 & 0xFF;
        double d = n2 >> 16 & 0xFF;
        double d2 = n2 >> 8 & 0xFF;
        double d3 = n2 & 0xFF;
        Color[] colorArray = new Color[n];
        int n7 = 0;
        while (n7 < n) {
            int n8 = n3 + (int)((d - (double)n4) * (double)n7 / (double)n) * 65536 + (int)((d2 - (double)n5) * (double)n7 / (double)n) * 256 + (int)((d3 - (double)n6) * (double)n7 / (double)n);
            colorArray[n7] = new Color(n8);
            ++n7;
        }
        return colorArray;
    }

    public static Color[] makeColorIndex(Color[] colorArray, int n) {
        Color[] colorArray2 = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            double d = (double)(colorArray.length - 1) / (double)n * (double)n2;
            int n3 = (int)d;
            Color color = colorArray[n3];
            Color color2 = colorArray[n3 + 1];
            double d2 = d - (double)n3;
            double d3 = 1.0 - d2;
            double d4 = color.getRed();
            double d5 = color.getGreen();
            double d6 = color.getBlue();
            double d7 = color2.getRed();
            double d8 = color2.getGreen();
            double d9 = color2.getBlue();
            int n4 = (int)(d4 * d3 + d7 * d2) * 65536 + (int)(d5 * d3 + d8 * d2) * 256 + (int)(d6 * d3 + d9 * d2);
            colorArray2[n2] = new Color(n4);
            ++n2;
        }
        return colorArray2;
    }

    public void setReversible(boolean bl) {
        this.rev = bl;
    }

    public Color getColor(int n) {
        if (n < 0) {
            n = this.rev ? -n : 0;
        }
        if (this.index.length <= n) {
            n = this.index.length - 1;
        }
        return this.index[n];
    }

    public Color getColor(double d) {
        return this.getColor((int)Math.rint(d * (double)this.index.length));
    }
}

