/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import jp.gr.java_conf.ccs2.util.Comparable;

public abstract class ComparableClass
implements Comparable {
    private static int THRESHOLD = 10;
    private static int STACKSIZE = 32;

    public final boolean greaterThan(Comparable comparable) {
        return this.getValue() > ((ComparableClass)comparable).getValue();
    }

    public final boolean equals(Comparable comparable) {
        return this.getValue() == ((ComparableClass)comparable).getValue();
    }

    public abstract double getValue();

    private static void inssort(Comparable[] comparableArray) {
        int n = comparableArray.length;
        int n2 = 1;
        while (n2 < n) {
            Comparable comparable = comparableArray[n2];
            int n3 = n2 - 1;
            while (n3 >= 0 && comparable.greaterThan(comparableArray[n3])) {
                comparableArray[n3 + 1] = comparableArray[n3];
                --n3;
            }
            comparableArray[n3 + 1] = comparable;
            ++n2;
        }
    }

    public static void qsort(Comparable[] comparableArray) {
        int n = comparableArray.length;
        int[] nArray = new int[STACKSIZE];
        int[] nArray2 = new int[STACKSIZE];
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 0;
        while (true) {
            if (n3 - n2 <= THRESHOLD) {
                if (n4 == 0) break;
                n2 = nArray[--n4];
                n3 = nArray2[n4];
            }
            Comparable comparable = comparableArray[(n2 + n3) / 2];
            int n5 = n2;
            int n6 = n3;
            while (true) {
                if (comparableArray[n5].greaterThan(comparable) && n5 < n3) {
                    ++n5;
                    continue;
                }
                while (comparable.greaterThan(comparableArray[n6]) && n6 > n2) {
                    --n6;
                }
                if (n5 >= n6) break;
                Comparable comparable2 = comparableArray[n5];
                comparableArray[n5] = comparableArray[n6];
                comparableArray[n6] = comparable2;
                ++n5;
                --n6;
            }
            if (n5 - n2 > n3 - n6) {
                if (n5 - n2 > THRESHOLD) {
                    nArray[n4] = n2;
                    nArray2[n4] = n5 - 1;
                    ++n4;
                }
                n2 = n6 + 1;
                continue;
            }
            if (n3 - n6 > THRESHOLD) {
                nArray[n4] = n6 + 1;
                nArray2[n4] = n3;
                ++n4;
            }
            n3 = n5 - 1;
        }
        ComparableClass.inssort(comparableArray);
    }
}

