/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jp.gr.java_conf.ccs2.util.JDBCUtil;

public class ConnectionBean
implements Serializable {
    String url;
    String driver;
    boolean driverExist = false;
    transient Connection connection;

    public ConnectionBean() {
    }

    public ConnectionBean(String string, String string2) {
        this.setDriver(string);
        this.setUrl(string2);
    }

    public ConnectionBean(Connection connection) {
        this.setConnection(connection);
    }

    public void setConnection(Connection connection) {
        this.driverExist = true;
        this.connection = connection;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDriver(String string) {
        this.driver = string;
        this.driverExist = JDBCUtil.registDriver(this.driver);
    }

    public String getDriver() {
        return this.driver;
    }

    public Connection getConnection() throws SQLException {
        if (!this.driverExist) {
            throw new RuntimeException("Driver [" + this.driver + "] doesn't exist!");
        }
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = DriverManager.getConnection(this.url);
        }
        return this.connection;
    }

    public void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            System.err.println("SQLException : " + sQLException.getMessage() + " in ConnectionBean.");
        }
    }

    protected void finalize() {
        this.closeConnection();
    }
}

