/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import jp.gr.java_conf.ccs2.util.StringTransformer;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class JDBCUtil {
    public static String CTRL = "%";
    public static boolean sjisEscape = true;

    public static boolean registDriver(String string) {
        try {
            Class.forName(string).newInstance();
            return true;
        }
        catch (Exception exception) {
            System.err.println("Unable to load driver [" + string + "].");
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultSet getResultSet(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        Statement statement = null;
        try {
            ResultSet resultSet2;
            statement = connection.createStatement();
            resultSet = resultSet2 = statement.executeQuery(string);
            Object var6_5 = null;
            if (statement == null) return resultSet;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return resultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultSet getResultSet(String string, String string2) throws SQLException {
        ResultSet resultSet;
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string);
            resultSet = JDBCUtil.getResultSet(connection, string2);
            Object var5_4 = null;
            if (connection == null) return resultSet;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
        return resultSet;
    }

    public static SQLException closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
        return null;
    }

    public static String getResult(Connection connection, String string) throws SQLException {
        ResultSet resultSet = JDBCUtil.getResultSet(connection, string);
        if (resultSet == null) {
            return null;
        }
        if (!resultSet.next()) {
            return null;
        }
        return JDBCUtil.esc(resultSet.getString(1));
    }

    public static String getResult(String string, String string2) throws SQLException {
        ResultSet resultSet = JDBCUtil.getResultSet(string, string2);
        if (resultSet == null) {
            return null;
        }
        if (!resultSet.next()) {
            return null;
        }
        return JDBCUtil.esc(resultSet.getString(1));
    }

    public static String[] layoutData(String string, ResultSet resultSet) throws SQLException {
        return JDBCUtil.layoutData(string, resultSet, null);
    }

    public static String[] layoutData(String string, ResultSet resultSet, Map map) throws SQLException {
        if (StringUtil.isNull(string)) {
            return null;
        }
        if (resultSet == null) {
            return JDBCUtil.clearLayoutDatas(string);
        }
        String[] stringArray = JDBCUtil.makeColumnArray(resultSet);
        String[] stringArray2 = new String[JDBCUtil.getRowNumber(resultSet)];
        int n = 0;
        while (resultSet.next()) {
            String string2 = string;
            int n2 = 0;
            while (n2 < stringArray.length) {
                StringTransformer stringTransformer;
                String string3 = JDBCUtil.esc(resultSet.getString(n2 + 1));
                if (map != null && (stringTransformer = (StringTransformer)map.get(stringArray[n2])) != null) {
                    string3 = stringTransformer.transform(string3);
                }
                string2 = StringUtil.replace(string2, JDBCUtil.columnCtrlCode(stringArray[n2]), string3);
                ++n2;
            }
            stringArray2[n] = string2;
            ++n;
        }
        return stringArray2;
    }

    private static String columnCtrlCode(String string) {
        return CTRL + string + CTRL;
    }

    static String[] makeColumnArray(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = resultSetMetaData.getColumnName(n2 + 1);
            ++n2;
        }
        return stringArray;
    }

    static String[] clearLayoutDatas(String string) {
        String[] stringArray = new String[]{JDBCUtil.clearLayoutData(string)};
        return stringArray;
    }

    static String clearLayoutData(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(CTRL)) != -1) {
            stringBuffer.append(string.substring(0, n));
            string = string.substring(n + 1);
            int n2 = string.indexOf(CTRL);
            if (n2 == -1) break;
            string = string.substring(n2 + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int getRowNumber(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return 0;
        }
        resultSet.last();
        int n = resultSet.getRow();
        resultSet.beforeFirst();
        return n;
    }

    public static String esc(String string) {
        if (sjisEscape) {
            return StringUtil.sjisEscape(string);
        }
        return string;
    }
}

