/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.sql.ResultSet;
import java.util.HashMap;
import jp.gr.java_conf.ccs2.util.ConnectionBean;
import jp.gr.java_conf.ccs2.util.IntNumberTransformer;
import jp.gr.java_conf.ccs2.util.JDBCUtil;
import jp.gr.java_conf.ccs2.util.QueryBean;
import jp.gr.java_conf.ccs2.util.StringTransformerClass;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.util.Time2DateTransformer;
import junit.framework.Assert;
import junit.framework.TestCase;

public class JDBCUtilTest
extends TestCase {
    ConnectionBean cb;

    public JDBCUtilTest(String string) {
        super(string);
    }

    public void setUp() {
        String string = "jdbc:mysql://leon/ss2001?user=sakurai&password=carol&useUnicode=true&characterEncoding=EUCJIS";
        this.cb = new ConnectionBean("org.gjt.mm.mysql.Driver", string);
    }

    public void tearDown() {
        this.cb.closeConnection();
    }

    public void testClear() {
        String string = "<td>%name%</td><td class=\"%fire arms%\">%BBC%</td>";
        String string2 = JDBCUtil.clearLayoutData(string);
        String string3 = "<td></td><td class=\"\"></td>";
        Assert.assertEquals((String)"Clear", (Object)string3, (Object)string2);
    }

    public void testQueryBean() {
        String string = "SELECT address.num,name,loginname,lastlogin FROM address INNER JOIN login ON address.num=login.num WHERE address.num = 5";
        QueryBean queryBean = new QueryBean(this.cb, string);
        queryBean.setLayout("(%num%) %name% : %loginname%");
        try {
            String[] stringArray = queryBean.layoutResultSet();
            Assert.assert((String)"same?", (boolean)StringUtil.assertEquals(stringArray[0], "(5) \u685c\u4e95 \u96c5\u53f2 : sakurai"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testInterrupt() {
        String string = "SELECT num,loginname,lastlogin,lastlogin login2 FROM login WHERE num = 5";
        QueryBean queryBean = new QueryBean(this.cb, string);
        queryBean.setLayout("%lastlogin% : %login2%");
        HashMap<String, StringTransformerClass> hashMap = new HashMap<String, StringTransformerClass>();
        hashMap.put("lastlogin", new Time2DateTransformer());
        hashMap.put("login2", new IntNumberTransformer());
        try {
            String[] stringArray = queryBean.layoutResultSet(hashMap);
            ResultSet resultSet = queryBean.getResultSet();
            resultSet.next();
            String string2 = new Time2DateTransformer().transform(resultSet.getString("lastlogin"));
            string2 = string2 + " : ";
            string2 = string2 + new IntNumberTransformer().transform(resultSet.getString("login2"));
            Assert.assert((String)"same?", (boolean)StringUtil.assertEquals(stringArray[0], string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

