/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class LSRFiles {
    String fs = System.getProperty("file.separator");
    private boolean subdir = true;
    private Vector files = new Vector();

    public LSRFiles(String string) throws IOException {
        this(string, true);
    }

    public LSRFiles(String string, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            string = System.getProperty("user.dir");
        }
        this.subdir = bl;
        this.initFiles(string);
    }

    public static LSRFiles getLSR(String string) {
        LSRFiles lSRFiles = null;
        try {
            lSRFiles = new LSRFiles(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return lSRFiles;
    }

    private void initFiles(String string) throws IOException {
        File file = new File(string);
        if (file.isFile()) {
            this.files.addElement(string);
        } else {
            Enumeration enumeration = this.getFilesByDir(string);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    this.files.addElement((String)enumeration.nextElement());
                }
            }
        }
        if (this.files.size() == 0) {
            System.err.println("file or directory not found.");
        }
    }

    private Enumeration getFilesByDir(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            Enumeration enumeration;
            String string2 = string + this.fs + stringArray[n];
            File file2 = new File(string2);
            if (file2.isFile()) {
                vector.addElement(file2.getAbsolutePath());
            } else if (this.subdir && (enumeration = this.getFilesByDir(string2)) != null) {
                while (enumeration.hasMoreElements()) {
                    vector.addElement((String)enumeration.nextElement());
                }
            }
            ++n;
        }
        return vector.elements();
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string = file.getParent();
            if (string == null) {
                file = new File(file.getAbsolutePath());
                string = file.getParent();
            }
            if (filenameFilter.accept(new File(string), file.getName())) {
                vector.addElement(file.getPath());
            }
            ++n;
        }
        this.files = vector;
    }

    public String[] getFilenames() {
        if (this.files.isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.files.elements();
        String[] stringArray = new String[this.files.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public File[] getFiles() {
        String[] stringArray = this.getFilenames();
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length != 0) {
            string = stringArray[0];
        }
        System.out.println("getting from [" + string + "]");
        LSRFiles lSRFiles = LSRFiles.getLSR(string);
        String[] stringArray2 = lSRFiles.getFilenames();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
    }
}

