/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>ASlipLine</code>]<br>
 *  Manage an information of one line of a transfer slip
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class ASlipLine implements Serializable {

    static final long serialVersionUID = 4286405975440866119L;

    transient TransferSlip parent ;
    String summary ;
    SlipElement left ;
    SlipElement right ;
    ASlipLine forward;

    public ASlipLine(TransferSlip p,ASlipLine f,String s,
		     SlipElement l,SlipElement r) {
	setParent(p);
	forward = f;
	setSummary(s);
	setLeft(l);
	setRight(r);
    }

    public String toString() {
	return getLeft().toString()+"  "+summary+"  "+getRight().toString();
    }
    public ASlipLine getForward() {return forward;}

    public void setParent(TransferSlip a) { parent = a; }
    public TransferSlip getParent() { return parent; }

    public void setSummary(String a) { 
	if (a != null)
	    summary = a; 
	else
	    summary = "";
    }
    public String getSummary() { return summary; }

    public void setLeft(SlipElement a) { left = a; }
    public SlipElement getLeft() { 
	if (left!= null)
	    return left; 
	//left is null
	if (getForward() == null) {
	    System.err.println("Left not found...");
	    return null;
	}
	return getForward().getLeft();
    }
    public boolean existLeft() {
	if (left == null) return false;
	return true;
    }

    public void setRight(SlipElement a) {right = a; }
    public SlipElement getRight() { 
	if (right!= null)
	    return right; 
	//right is null
	if (getForward() == null) {
	    System.err.println("Right not found...");
	    return null;
	}
	return getForward().getRight();
    }
    public boolean existRight() {
	if (right == null) return false;
	return true;
    }

}
