/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;


public abstract class AbstractManager {

    SystemInfo parent ;
    String systemFilename;

    protected AbstractManager(SystemInfo p,String f) {
	parent = p;
	systemFilename = f;
    }

    public SystemInfo getParent() { return parent; }

    /** system loading */
    public void initByLoad() {
	if (systemFilename == null) {
	    initByClean();
	    return;
	}
	try {
	    System.out.println("reading database file. ["+systemFilename+"]");
	    ObjectInputStream in
		= new ObjectInputStream(
                  new BufferedInputStream(
                  new FileInputStream(systemFilename)));
	    loadClasses(in);
	} catch(Exception e) {
	    System.err.println(e.getClass().getName());
	    e.printStackTrace();
	    System.err.println("-------------------------");
	    initByClean();
	}
    }

    /** called by system after system initialize all manager */
    public void onStartup() {}

    /** called by system before system system shutdown */
    public void onExit() {
	save();
    }
    
    void save() {
	if (systemFilename == null) return;
	if (systemFilename.equals("")) return;
	try {
	    ObjectOutputStream out;
	    out	= new ObjectOutputStream(
		     new BufferedOutputStream(
		      new FileOutputStream(systemFilename)));
	    System.out.println("writting database ["+systemFilename+"]...");
	    saveClasses(out);
	    out.flush();
	    out.close();
	    System.out.println("finished.");
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }

    protected abstract void initByClean();
    protected abstract void loadClasses(ObjectInputStream in) throws Exception;
    protected abstract void saveClasses(ObjectOutputStream out) throws Exception;
}
